/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.data_streams_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamsStatsItem
implements JsonpSerializable {
    private final int backingIndices;
    private final String dataStream;
    private final long maximumTimestamp;
    @Nullable
    private final String storeSize;
    private final long storeSizeBytes;
    public static final JsonpDeserializer<DataStreamsStatsItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamsStatsItem::setupDataStreamsStatsItemDeserializer);

    private DataStreamsStatsItem(Builder builder) {
        this.backingIndices = ApiTypeHelper.requireNonNull(builder.backingIndices, this, "backingIndices");
        this.dataStream = ApiTypeHelper.requireNonNull(builder.dataStream, this, "dataStream");
        this.maximumTimestamp = ApiTypeHelper.requireNonNull(builder.maximumTimestamp, this, "maximumTimestamp");
        this.storeSize = builder.storeSize;
        this.storeSizeBytes = ApiTypeHelper.requireNonNull(builder.storeSizeBytes, this, "storeSizeBytes");
    }

    public static DataStreamsStatsItem of(Function<Builder, ObjectBuilder<DataStreamsStatsItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int backingIndices() {
        return this.backingIndices;
    }

    public final String dataStream() {
        return this.dataStream;
    }

    public final long maximumTimestamp() {
        return this.maximumTimestamp;
    }

    @Nullable
    public final String storeSize() {
        return this.storeSize;
    }

    public final long storeSizeBytes() {
        return this.storeSizeBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("data_stream");
        generator.write(this.dataStream);
        generator.writeKey("maximum_timestamp");
        generator.write(this.maximumTimestamp);
        if (this.storeSize != null) {
            generator.writeKey("store_size");
            generator.write(this.storeSize);
        }
        generator.writeKey("store_size_bytes");
        generator.write(this.storeSizeBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamsStatsItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices");
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
        op.add(Builder::maximumTimestamp, JsonpDeserializer.longDeserializer(), "maximum_timestamp");
        op.add(Builder::storeSize, JsonpDeserializer.stringDeserializer(), "store_size");
        op.add(Builder::storeSizeBytes, JsonpDeserializer.longDeserializer(), "store_size_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamsStatsItem> {
        private Integer backingIndices;
        private String dataStream;
        private Long maximumTimestamp;
        @Nullable
        private String storeSize;
        private Long storeSizeBytes;

        public final Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        public final Builder dataStream(String value) {
            this.dataStream = value;
            return this;
        }

        public final Builder maximumTimestamp(long value) {
            this.maximumTimestamp = value;
            return this;
        }

        public final Builder storeSize(@Nullable String value) {
            this.storeSize = value;
            return this;
        }

        public final Builder storeSizeBytes(long value) {
            this.storeSizeBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamsStatsItem build() {
            this._checkSingleUse();
            return new DataStreamsStatsItem(this);
        }
    }
}

