/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure.test_grok_pattern;

import co.elastic.clients.elasticsearch.text_structure.test_grok_pattern.MatchedField;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MatchedText
implements JsonpSerializable {
    private final boolean matched;
    private final Map<String, List<MatchedField>> fields;
    public static final JsonpDeserializer<MatchedText> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatchedText::setupMatchedTextDeserializer);

    private MatchedText(Builder builder) {
        this.matched = ApiTypeHelper.requireNonNull(builder.matched, this, "matched");
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static MatchedText of(Function<Builder, ObjectBuilder<MatchedText>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean matched() {
        return this.matched;
    }

    public final Map<String, List<MatchedField>> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("matched");
        generator.write(this.matched);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, List<MatchedField>> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (MatchedField item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMatchedTextDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::matched, JsonpDeserializer.booleanDeserializer(), "matched");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(MatchedField._DESERIALIZER)), "fields");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MatchedText> {
        private Boolean matched;
        @Nullable
        private Map<String, List<MatchedField>> fields;

        public final Builder matched(boolean value) {
            this.matched = value;
            return this;
        }

        public final Builder fields(Map<String, List<MatchedField>> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, List<MatchedField> value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MatchedText build() {
            this._checkSingleUse();
            return new MatchedText(this);
        }
    }
}

