/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.link.plugin;

import io.meeds.content.link.model.LinkSetting;
import io.meeds.content.link.service.LinkService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkSettingTranslationPlugin
extends TranslationPlugin {
    public static final String LINK_SETTINGS_OBJECT_TYPE = "link-settings";
    private static final Log LOG = ExoLogger.getLogger(LinkSettingTranslationPlugin.class);
    @Autowired
    protected LinkService linkService;
    @Autowired
    protected IdentityRegistry identityRegistry;
    @Autowired
    protected OrganizationService organizationService;
    @Autowired
    protected TranslationService translationService;

    @PostConstruct
    public void init() {
        this.translationService.addPlugin((TranslationPlugin)this);
    }

    public String getObjectType() {
        return LINK_SETTINGS_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(long linkSettingId, String username) throws ObjectNotFoundException {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSetting(linkSettingId);
            return linkSetting != null && this.linkService.hasAccessPermission(linkSetting.getName(), this.getIdentity(username));
        }
        catch (Exception e) {
            LOG.warn("Error checking access permission on link setting with id {} for user {}", new Object[]{linkSettingId, username, e});
            return false;
        }
    }

    public boolean hasEditPermission(long linkSettingId, String username) throws ObjectNotFoundException {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSetting(linkSettingId);
            return linkSetting != null && this.linkService.hasEditPermission(linkSetting.getName(), this.getIdentity(username));
        }
        catch (Exception e) {
            LOG.warn("Error checking edit permission on link setting with id {} for user {}", new Object[]{linkSettingId, username, e});
            return false;
        }
    }

    public long getAudienceId(long objectId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(long objectId) throws ObjectNotFoundException {
        return 0L;
    }

    private Identity getIdentity(String username) throws Exception {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            List<MembershipEntry> entries = this.organizationService.getMembershipHandler().findMembershipsByUser(username).stream().map(membership -> new MembershipEntry(membership.getGroupId(), membership.getMembershipType())).toList();
            aclIdentity = new Identity(username, entries);
            this.identityRegistry.register(aclIdentity);
        }
        return aclIdentity;
    }
}

