/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryWithName;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.navigation.plugin.AbstractSpaceSidebarPlugin;
import io.meeds.social.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.social.core.space.SpaceFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=50)
public class SpaceCategorySidebarPlugin
extends AbstractSpaceSidebarPlugin {
    public static final String SPACE_CATEGORY_ID_PROP_NAME = "spaceCategoryId";
    public static final String SPACE_CATEGORY_IDS_PROP_NAME = "spaceCategoryIds";
    @Autowired
    private CategoryService categoryService;

    public SidebarItemType getType() {
        return SidebarItemType.SPACE_CATEGORY;
    }

    public boolean itemExists(SidebarItem item, String username) {
        if (item == null || item.getProperties() == null) {
            return false;
        }
        long categoryId = this.getCategoryId(item);
        Category category = this.categoryService.getCategory(categoryId);
        return category != null && this.categoryService.canAccess(category, username);
    }

    public SidebarItem resolveProperties(SidebarItem item, String username, Locale locale) {
        long categoryId = this.getCategoryId(item);
        CategoryWithName category = this.categoryService.getCategory(categoryId, username, locale);
        if (category != null) {
            item.setName(category.getName());
            item.setIcon(category.getIcon());
            item.setItems(this.getSpaces(item, username));
        }
        item.setDefaultPath(false);
        return item;
    }

    @Override
    protected void buildSpaceFilter(String username, SidebarItem item, SpaceFilter spaceFilter) {
        long categoryId = this.getCategoryId(item);
        List subCategoryIds = this.categoryService.getSubcategoryIds(username, categoryId, 0L, -1L, -1L);
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(categoryId);
        if (CollectionUtils.isNotEmpty((Collection)subCategoryIds)) {
            categoryIds.addAll(subCategoryIds);
        }
        item.setProperties(new HashMap(item.getProperties()));
        item.getProperties().put(SPACE_CATEGORY_IDS_PROP_NAME, JsonUtils.toJsonString(categoryIds));
        spaceFilter.setCategoryIds(categoryIds);
    }

    private long getCategoryId(SidebarItem item) {
        String spaceCategoryIdProperty = (String)item.getProperties().get(SPACE_CATEGORY_ID_PROP_NAME);
        return Long.parseLong(spaceCategoryIdProperty);
    }
}

