/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.filter.ActivitySearchFilter;
import org.exoplatform.social.core.activity.model.ActivitySearchResult;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ActivitySearchProcessor;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.tag.TagService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ActivitySearchConnector {
    private static final Log LOG = ExoLogger.getLogger(ActivitySearchConnector.class);
    public static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    public static final String SEARCH_QUERY_TERM = "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"@term@~\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},";
    public static final String SEARCH_QUERY_WITH_PHRASE = "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"(@term@) OR (\\\"@phrase@\\\"~)^5\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},";
    public static final String CATEGORY_IDS_QUERY = "{\n  \"terms\":{\n    \"categoryId\": [@categoryIds@]\n  }\n}\n";
    private static final String TERM_REPLACEMENT = "@term@";
    private static final String PHRASE_REPLACEMENT = "@phrase@";
    private final ConfigurationManager configurationManager;
    private final ActivitySearchProcessor activitySearchProcessor;
    private final IdentityManager identityManager;
    private final ActivityStorage activityStorage;
    private final ElasticSearchingClient client;
    private String index;
    private String searchQueryFilePath;
    private String searchQuery;

    public ActivitySearchConnector(ActivitySearchProcessor activitySearchProcessor, IdentityManager identityManager, ActivityStorage activityStorage, ConfigurationManager configurationManager, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.activitySearchProcessor = activitySearchProcessor;
        this.identityManager = identityManager;
        this.activityStorage = activityStorage;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.searchQuery = this.retrieveSearchQueryFromFile(this.searchQueryFilePath);
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<ActivitySearchResult> search(Identity viewerIdentity, ActivitySearchFilter filter, long offset, long limit) {
        if (viewerIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)filter.getTerm()) && !filter.isFavorites() && CollectionUtils.isEmpty(filter.getTagNames())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        return this.searchActivities(viewerIdentity, filter, offset, limit);
    }

    private List<ActivitySearchResult> searchActivities(Identity viewerIdentity, ActivitySearchFilter filter, long offset, long limit) {
        Set streamFeedOwnerIds = this.activityStorage.getStreamFeedOwnerIds(viewerIdentity);
        Map<String, List<String>> metadataFilters = this.buildMetadatasFilter(filter, viewerIdentity);
        String esQuery = this.buildQueryStatement(streamFeedOwnerIds, metadataFilters, filter, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse, viewerIdentity, streamFeedOwnerIds);
    }

    private String buildQueryStatement(Set<Long> streamFeedOwnerIds, Map<String, List<String>> metadataFilters, ActivitySearchFilter filter, long offset, long limit) {
        String termQuery = this.buildTermQueryStatement(filter.getTerm());
        String favoriteQuery = this.buildFavoriteQueryStatement(metadataFilters.get(FavoriteService.METADATA_TYPE.getName()));
        String tagsQuery = this.buildTagsQueryStatement(metadataFilters.get(TagService.METADATA_TYPE.getName()));
        String categoryQuery = this.buildCategoryIdQueryStatement(filter);
        return this.retrieveSearchQuery().replace("@term_query@", termQuery).replace("@favorite_query@", favoriteQuery).replace("@tags_query@", tagsQuery).replace("@category_query@", categoryQuery).replace("@permissions@", StringUtils.join(streamFeedOwnerIds, (String)",")).replace("@offset@", String.valueOf(offset)).replace("@limit@", String.valueOf(limit));
    }

    private List<ActivitySearchResult> buildResult(String jsonResponse, Identity viewerIdentity, Set<Long> streamFeedOwnerIds) {
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<ActivitySearchResult> results = new ArrayList<ActivitySearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                JSONArray bodyExcepts;
                ActivitySearchResult activitySearchResult = new ActivitySearchResult();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                Long id = this.parseLong(hitSource, "id");
                Long posterId = this.parseLong(hitSource, "posterId");
                Long parentId = this.parseLong(hitSource, "parentId");
                Long streamOwner = this.parseLong(hitSource, "streamOwner");
                if (!streamFeedOwnerIds.contains(streamOwner) && !streamFeedOwnerIds.contains(posterId)) {
                    LOG.warn("Activity '{}' is returned in search result while it's not permitted to user {}. Ignore it.", new Object[]{id, viewerIdentity.getId()});
                    continue;
                }
                Long postedTime = this.parseLong(hitSource, "postedTime");
                Long lastUpdatedTime = (Long)hitSource.get((Object)"lastUpdatedDate");
                String body = (String)hitSource.get((Object)"body");
                String type = (String)hitSource.get((Object)"type");
                JSONObject highlightSource = (JSONObject)jsonHitObject.get((Object)"highlight");
                List<Object> excerpts = new ArrayList();
                if (highlightSource != null && (bodyExcepts = (JSONArray)highlightSource.get((Object)"body")) != null) {
                    String[] bodyExceptsArray = (String[])bodyExcepts.toArray((Object[])new String[0]);
                    excerpts = Arrays.asList(bodyExceptsArray);
                }
                if (parentId == null) {
                    activitySearchResult.setId(id.longValue());
                    if (lastUpdatedTime != null) {
                        activitySearchResult.setLastUpdatedTime(lastUpdatedTime.longValue());
                    }
                    if (postedTime != null) {
                        activitySearchResult.setPostedTime(postedTime.longValue());
                    }
                    if (streamOwner != null) {
                        Identity streamOwnerIdentity = this.identityManager.getIdentity(streamOwner.toString());
                        activitySearchResult.setStreamOwner(streamOwnerIdentity);
                    }
                    if (posterId != null) {
                        Identity posterIdentity = this.identityManager.getIdentity(posterId.toString());
                        activitySearchResult.setPoster(posterIdentity);
                    }
                    activitySearchResult.setBody(body);
                    activitySearchResult.setType(type);
                    activitySearchResult.setExcerpts(excerpts);
                } else {
                    ActivitySearchResult commentSearchResult = new ActivitySearchResult();
                    commentSearchResult.setId(id.longValue());
                    if (lastUpdatedTime != null) {
                        commentSearchResult.setLastUpdatedTime(lastUpdatedTime.longValue());
                    }
                    if (postedTime != null) {
                        commentSearchResult.setPostedTime(postedTime.longValue());
                    }
                    if (streamOwner != null) {
                        Identity streamOwnerIdentity = this.identityManager.getIdentity(streamOwner.toString());
                        commentSearchResult.setStreamOwner(streamOwnerIdentity);
                    }
                    if (posterId != null) {
                        Identity posterIdentity = this.identityManager.getIdentity(posterId.toString());
                        commentSearchResult.setPoster(posterIdentity);
                    }
                    commentSearchResult.setBody(body);
                    commentSearchResult.setType(type);
                    commentSearchResult.setExcerpts(excerpts);
                    activitySearchResult.setComment(commentSearchResult);
                    this.activitySearchProcessor.formatSearchResult(commentSearchResult);
                    this.transformActivityToResult(activitySearchResult, parentId);
                }
                results.add(activitySearchResult);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing activity search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private void transformActivityToResult(ActivitySearchResult activitySearchResult, Long parentId) {
        ActivityStream activityStream;
        ExoSocialActivity activity = this.activityStorage.getActivity(parentId.toString());
        activitySearchResult.setType(activity.getType());
        activitySearchResult.setId(Long.parseLong(activity.getId()));
        if (activity.getUpdated() != null) {
            activitySearchResult.setLastUpdatedTime(activity.getUpdated().getTime());
        }
        if (activity.getPostedTime() != null) {
            activitySearchResult.setPostedTime(activity.getPostedTime().longValue());
        }
        if ((activityStream = activity.getActivityStream()) != null) {
            String prettyId = activityStream.getPrettyId();
            String providerId = activityStream.getType().getProviderId();
            Identity streamOwnerIdentity = this.identityManager.getOrCreateIdentity(providerId, prettyId);
            activitySearchResult.setStreamOwner(streamOwnerIdentity);
        }
        if (activity.getPosterId() != null) {
            Identity posterIdentity = this.identityManager.getIdentity(activity.getPosterId());
            activitySearchResult.setPoster(posterIdentity);
        }
        if (StringUtils.isNotBlank((CharSequence)activity.getTitle())) {
            activitySearchResult.setBody(activity.getTitle());
        } else {
            activitySearchResult.setBody(activity.getBody());
        }
        this.activitySearchProcessor.formatSearchResult(activitySearchResult);
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((CharSequence)this.searchQuery) || PropertyManager.isDevelopping()) {
            this.searchQuery = this.retrieveSearchQueryFromFile(this.searchQueryFilePath);
        }
        return this.searchQuery;
    }

    private String retrieveSearchQueryFromFile(String filePath) {
        try {
            InputStream queryFileIS = this.configurationManager.getInputStream(filePath);
            return IOUtil.getStreamContentAsString((InputStream)queryFileIS);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving search query from file: " + filePath, e);
        }
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replace("'", " ");
        return string;
    }

    private Map<String, List<String>> buildMetadatasFilter(ActivitySearchFilter filter, Identity viewerIdentity) {
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (filter.isFavorites()) {
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(viewerIdentity.getId()));
        }
        if (CollectionUtils.isNotEmpty(filter.getTagNames())) {
            metadataFilters.put(TagService.METADATA_TYPE.getName(), filter.getTagNames());
        }
        return metadataFilters;
    }

    private String buildFavoriteQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        return "{\"terms\":{" + "\"metadatas.favorites.metadataName.keyword\": [\"" + StringUtils.join(values, (String)"\",\"") + "\"]}},";
    }

    private String buildTagsQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        List<String> tagsQueryParts = values.stream().map(value -> "{\"term\": {\n" + "            \"metadatas.tags.metadataName.keyword\": {\n" + "              \"value\": \"" + value + "\",\n" + "              \"case_insensitive\":true\n" + "            }\n" + "          }}").toList();
        return ",\"should\": [\n" + StringUtils.join(tagsQueryParts, (String)",") + "      ],\n" + "      \"minimum_should_match\": 1";
    }

    private String buildCategoryIdQueryStatement(ActivitySearchFilter filter) {
        if (CollectionUtils.isNotEmpty(filter.getCategoryIds())) {
            return CATEGORY_IDS_QUERY.replace("@categoryIds@", StringUtils.join(filter.getCategoryIds(), (String)","));
        }
        return "";
    }

    private String buildTermQueryStatement(String phrase) {
        if (StringUtils.isBlank((CharSequence)phrase)) {
            return "";
        }
        if (StringUtils.contains((CharSequence)(phrase = this.removeSpecialCharacters(phrase)), (CharSequence)" ")) {
            String terms = Arrays.stream(StringUtils.split((String)phrase, (String)" ")).map(keyword -> {
                String keywordTrim = keyword.trim();
                if (keywordTrim.length() > 4) {
                    return keywordTrim + "~";
                }
                return keywordTrim;
            }).reduce("", (key1, key2) -> key1 + " " + key2);
            return SEARCH_QUERY_WITH_PHRASE.replace(TERM_REPLACEMENT, terms).replace(PHRASE_REPLACEMENT, phrase);
        }
        return SEARCH_QUERY_TERM.replace(TERM_REPLACEMENT, phrase);
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }
}

