/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.plugin;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class ActivityAttachmentPlugin
extends AttachmentPlugin {
    public static final String ACTIVITY_ATTACHMENT_TYPE = "activity";
    private final ActivityManager activityManager;

    public ActivityAttachmentPlugin(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    public String getObjectType() {
        return ACTIVITY_ATTACHMENT_TYPE;
    }

    public boolean hasAccessPermission(Identity userIdentity, String activityId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.getActivity(activityId);
        return activity != null && this.activityManager.isActivityViewable(activity, userIdentity);
    }

    public boolean hasEditPermission(Identity userIdentity, String activityId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.getActivity(activityId);
        return activity != null && this.activityManager.isActivityEditable(activity, userIdentity);
    }

    public long getAudienceId(String activityId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.getParentActivity(activityId);
        return activity == null || StringUtils.isBlank((CharSequence)activity.getStreamId()) ? 0L : Long.parseLong(activity.getStreamId());
    }

    public long getSpaceId(String activityId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.getParentActivity(activityId);
        return activity == null || StringUtils.isBlank((CharSequence)activity.getSpaceId()) ? 0L : Long.parseLong(activity.getSpaceId());
    }

    private ExoSocialActivity getParentActivity(String activityId) throws ObjectNotFoundException {
        ExoSocialActivity activity = this.getActivity(activityId);
        if (activity != null && activity.isComment()) {
            activity = this.getActivity(activity.getParentId());
        }
        return activity;
    }

    private ExoSocialActivity getActivity(String activityId) throws ObjectNotFoundException {
        if (StringUtils.isBlank((CharSequence)(activityId = StringUtils.replace((String)activityId, (String)"comment", (String)"")))) {
            return null;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " wasn't found");
        }
        return activity;
    }
}

