/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.routing;

import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.routing.RoutingResolver;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;

public class DefaultRoutingResolver
implements RoutingResolver {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ? extends ElasticsearchPersistentProperty> mappingContext;

    public DefaultRoutingResolver(MappingContext<? extends ElasticsearchPersistentEntity<?>, ? extends ElasticsearchPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    @Override
    public String getRouting() {
        return null;
    }

    @Override
    @Nullable
    public <T> String getRouting(T bean) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(bean.getClass());
        if (persistentEntity != null) {
            return persistentEntity.resolveRouting(bean);
        }
        return null;
    }
}

