/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.StringWriter;
import java.io.Writer;
import org.gatein.common.io.WriterCharWriter;
import org.gatein.common.text.CharWriter;
import org.gatein.common.text.EncodingException;
import org.gatein.common.text.EntityEncoder;
import org.gatein.common.util.ParameterValidation;

public class HTMLEntityEncoder
extends EntityEncoder {
    private static volatile HTMLEntityEncoder singletonInstance;
    private final String[] hexToEntity = this.buildHexEntityNumberArray();
    private static final char[] IMMUNE_HTML;
    private static final char[] IMMUNE_HTMLATTR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HTMLEntityEncoder getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<HTMLEntityEncoder> clazz = HTMLEntityEncoder.class;
        synchronized (HTMLEntityEncoder.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new HTMLEntityEncoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    public String encodeHTML(String input) {
        return this.encode(input, IMMUNE_HTML);
    }

    public String encodeHTMLAttribute(String input) {
        return this.encode(input, IMMUNE_HTMLATTR);
    }

    public void safeEncode(char[] chars, int off, int len, CharWriter writer) throws EncodingException {
        this.safeEncode(chars, off, len, writer, IMMUNE_HTML);
    }

    private void safeEncode(char[] chars, int off, int len, CharWriter writer, char[] immune) throws EncodingException {
        int previous = off;
        int to = off + len;
        boolean isPreviousHighSurrogate = false;
        for (int current = off; current < to; ++current) {
            String replacement;
            char c = chars[current];
            if (this.isImmutable(immune, c)) continue;
            if (Character.isHighSurrogate(c)) {
                isPreviousHighSurrogate = true;
                writer.append(chars, previous, current - previous);
                previous = current + 1;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                if (isPreviousHighSurrogate) {
                    replacement = Integer.toHexString(Character.codePointAt(chars, current - 1, current + 1));
                    writer.append((CharSequence)"&#x").append((CharSequence)replacement).append(';');
                    previous = current + 1;
                }
                isPreviousHighSurrogate = false;
                continue;
            }
            replacement = this.lookupEntityName(c);
            if (replacement != null) {
                writer.append(chars, previous, current - previous);
                writer.append('&').append((CharSequence)replacement).append(';');
                previous = current + 1;
                isPreviousHighSurrogate = false;
                continue;
            }
            String hex = this.lookupHexEntityNumber(c);
            if (hex != null) {
                writer.append(chars, previous, current - previous);
                writer.append((CharSequence)"&#x").append((CharSequence)hex).append(';');
                previous = current + 1;
                isPreviousHighSurrogate = false;
                continue;
            }
            isPreviousHighSurrogate = false;
        }
        writer.append(chars, previous, chars.length - previous);
    }

    public final String lookupEntityName(char c) {
        return this.lookup(c);
    }

    public final String lookupHexEntityNumber(char c) {
        if (c < '\u00ff') {
            return this.hexToEntity[c];
        }
        return Integer.toHexString(c);
    }

    private boolean isImmutable(char[] array, char c) {
        for (char ch : array) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    private String encode(String input, char[] immutable) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)input, (String)"String");
        StringWriter sw = new StringWriter();
        WriterCharWriter charWriter = new WriterCharWriter((Writer)sw);
        this.safeEncode(input.toCharArray(), 0, input.length(), (CharWriter)charWriter, immutable);
        return ((Object)sw).toString();
    }

    private String[] buildHexEntityNumberArray() {
        String[] array = new String[256];
        for (int c = 0; c < 255; c = (int)((char)(c + 1))) {
            array[c] = c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 ? null : Integer.toHexString(c);
        }
        return array;
    }

    static {
        IMMUNE_HTML = new char[]{',', '.', '-', '_', ' '};
        IMMUNE_HTMLATTR = new char[]{',', '.', '-', '_'};
    }
}

