/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.openssl;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import org.apache.tomcat.util.openssl.openssl_h;

public class openssl_h_Compatibility {
    public static final boolean OPENSSL;
    public static final boolean OPENSSL3;
    public static final boolean BORINGSSL;
    public static final boolean LIBRESSL;
    public static final int SSL_CTRL_OPTIONS = 32;
    public static final int SSL_CTRL_CLEAR_OPTIONS = 77;

    public static int FIPS_mode() {
        class Holder {
            static final String NAME = "FIPS_mode";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("FIPS_mode"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("FIPS_mode", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int FIPS_mode_set(int r) {
        class Holder {
            static final String NAME = "FIPS_mode_set";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("FIPS_mode_set"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("FIPS_mode_set", r);
            }
            return mh$.invokeExact(r);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int EVP_PKEY_base_id(MemorySegment pkey) {
        class Holder {
            static final String NAME = "EVP_PKEY_base_id";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("EVP_PKEY_base_id"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("EVP_PKEY_base_id", pkey);
            }
            return mh$.invokeExact(pkey);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int EVP_PKEY_bits(MemorySegment pkey) {
        class Holder {
            static final String NAME = "EVP_PKEY_bits";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("EVP_PKEY_bits"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("EVP_PKEY_bits", pkey);
            }
            return mh$.invokeExact(pkey);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment SSL_get_peer_certificate(MemorySegment s) {
        if (OPENSSL3) {
            return openssl_h.SSL_get1_peer_certificate(s);
        }
        class Holder {
            static final String NAME = "SSL_get_peer_certificate";
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_get_peer_certificate"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            if (openssl_h.TRACE_DOWNCALLS) {
                openssl_h.traceDowncall("SSL_get_peer_certificate", s);
            }
            return mh$.invokeExact(s);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static long SSL_CTX_get_options(MemorySegment ctx) {
        if (LIBRESSL) {
            return openssl_h.SSL_CTX_ctrl(ctx, 32, 0L, MemorySegment.NULL);
        }
        return openssl_h.SSL_CTX_get_options(ctx);
    }

    public static long SSL_CTX_set_options(MemorySegment ctx, long op) {
        if (LIBRESSL) {
            return openssl_h.SSL_CTX_ctrl(ctx, 32, op, MemorySegment.NULL);
        }
        return openssl_h.SSL_CTX_set_options(ctx, op);
    }

    public static long SSL_get_options(MemorySegment s) {
        if (LIBRESSL) {
            return openssl_h.SSL_ctrl(s, 32, 0L, MemorySegment.NULL);
        }
        return openssl_h.SSL_get_options(s);
    }

    public static long SSL_set_options(MemorySegment s, long op) {
        if (LIBRESSL) {
            return openssl_h.SSL_ctrl(s, 32, op, MemorySegment.NULL);
        }
        return openssl_h.SSL_set_options(s, op);
    }

    public static long SSL_CTX_clear_options(MemorySegment ctx, long op) {
        if (LIBRESSL) {
            return openssl_h.SSL_CTX_ctrl(ctx, 77, op, MemorySegment.NULL);
        }
        return openssl_h.SSL_CTX_clear_options(ctx, op);
    }

    public static int OPENSSL_sk_num(MemorySegment x0) {
        if (LIBRESSL) {
            class Holder {
                static final String NAME = "sk_num";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_INT, openssl_h.C_POINTER);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("sk_num"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("sk_num", x0);
                }
                return mh$.invokeExact(x0);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.OPENSSL_sk_num(x0);
    }

    public static MemorySegment OPENSSL_sk_value(MemorySegment x0, int x1) {
        if (LIBRESSL) {
            class Holder {
                static final String NAME = "sk_value";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_INT);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("sk_value"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("sk_value", x0, x1);
                }
                return mh$.invokeExact(x0, x1);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.OPENSSL_sk_value(x0, x1);
    }

    public static void SSL_set_verify_result(MemorySegment ssl, long v) {
        if (!BORINGSSL) {
            openssl_h.SSL_set_verify_result(ssl, v);
        }
    }

    static {
        String versionString = openssl_h.OpenSSL_version(0).getString(0L);
        OPENSSL = versionString.contains("OpenSSL");
        OPENSSL3 = OPENSSL && openssl_h.OpenSSL_version_num() >= 0x3000000FL;
        BORINGSSL = versionString.contains("BoringSSL");
        LIBRESSL = versionString.contains("LibreSSL");
    }
}

