/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.social.space.service.SpaceLayoutService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.ImportList;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;
import org.picocontainer.Startable;

public class NotesAutoImportService
implements Startable {
    public static final String NOTES_IMPORT_SCOPE_NAME = "NOTES_IMPORT_SCOPE";
    public static final String NOTES_IMPORT_CONTEXT_NAME = "NOTES_IMPORT_CONTEXT";
    public static final Context NOTES_IMPORT_CONTEXT = Context.GLOBAL.id("NOTES_IMPORT_CONTEXT");
    public static final Scope NOTES_IMPORT_SCOPE = Scope.APPLICATION.id("NOTES_IMPORT_SCOPE");
    private static final Log log = ExoLogger.getLogger(NotesAutoImportService.class);
    private static final String EN_KNOWLEDGE_BASE_SPACE_NAME_PARAM = "enKnowledgeBaseSpaceName";
    private static final String FR_KNOWLEDGE_BASE_SPACE_NAME_PARAM = "frKnowledgeBaseSpaceName ";
    private static final String EN_KNOWLEDGE_BASE_SPACE_NAME_DISPLAY_PARAM = "enKnowledgeBaseSpaceDispalyName";
    private static final String FR_KNOWLEDGE_BASE_SPACE_DISPLAY_NAME_PARAM = "frKnowledgeBaseSpaceDispalyName";
    private static final String EN_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM = "enKnowledgeBaseSpaceDescription";
    private static final String FR_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM = "frKnowledgeBaseSpaceDescription";
    private static final String IMPORT_ENABLED_PARAM = "importEnabled";
    private static final String IMPORT_CONFLICT_MODE_PARAM = "importConflictMode";
    private static final String FR_EXPORT_ZIP_LOCATION = "/notesExports/fr/kb_export_fr.zip";
    private static final String EN_EXPORT_ZIP_LOCATION = "/notesExports/en/kb_export_en.zip";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private final InitParams initParams;
    private static NoteService noteService;
    private static SpaceService spaceService;
    private static NavigationService navigationService;
    private static SpaceTemplateService spaceTemplateService;
    private static SpaceLayoutService spaceLayoutService;
    private static WikiService wikiService;
    private static SettingService settingService;
    private static UserACL userACL;
    private static String enKnowledgeBaseSpaceName;
    private static String frKnowledgeBaseSpaceName;
    private static String enKnowledgeBaseSpaceDispalyName;
    private static String frKnowledgeBaseSpaceDispalyName;
    private static String enKnowledgeBaseSpaceDescription;
    private static String frKnowledgeBaseSpaceDescription;
    private static boolean importEnabled;
    private static String importConflictMode;

    public NotesAutoImportService(InitParams initParams, SettingService settingService, NoteService noteService, WikiService wikiService, SpaceService spaceService, SpaceTemplateService spaceTemplateService, SpaceLayoutService spaceLayoutService, NavigationService navigationService, UserACL userACL) {
        this.initParams = initParams;
        NotesAutoImportService.settingService = settingService;
        NotesAutoImportService.noteService = noteService;
        NotesAutoImportService.wikiService = wikiService;
        NotesAutoImportService.spaceService = spaceService;
        NotesAutoImportService.spaceTemplateService = spaceTemplateService;
        NotesAutoImportService.spaceLayoutService = spaceLayoutService;
        NotesAutoImportService.navigationService = navigationService;
        NotesAutoImportService.userACL = userACL;
        if (initParams != null) {
            if (initParams.getValueParam(IMPORT_ENABLED_PARAM) != null) {
                importEnabled = initParams.getValueParam(IMPORT_ENABLED_PARAM).getValue().equals("true");
            }
            if (initParams.getValueParam(IMPORT_CONFLICT_MODE_PARAM) != null) {
                importConflictMode = initParams.getValueParam(IMPORT_CONFLICT_MODE_PARAM).getValue();
            }
            if (initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_PARAM) != null) {
                enKnowledgeBaseSpaceName = initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_DISPLAY_PARAM) != null) {
                enKnowledgeBaseSpaceDispalyName = initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_DISPLAY_PARAM).getValue();
            }
            if (initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM) != null) {
                enKnowledgeBaseSpaceDescription = initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM).getValue();
            }
            if (initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_NAME_PARAM) != null) {
                frKnowledgeBaseSpaceName = initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DISPLAY_NAME_PARAM) != null) {
                frKnowledgeBaseSpaceDispalyName = initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DISPLAY_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM) != null) {
                frKnowledgeBaseSpaceDescription = initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM).getValue();
            }
        }
    }

    public void start() {
        NotesAutoImportService.createKnowledgeBase();
    }

    public void stop() {
    }

    public static void createKnowledgeBase() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
            membershipEntries.add(new MembershipEntry(userACL.getAdminGroups(), "*"));
            Identity superUserIdentity = new Identity(userACL.getSuperUser(), membershipEntries);
            NotesAutoImportService.importNotes(frKnowledgeBaseSpaceName, frKnowledgeBaseSpaceDispalyName, frKnowledgeBaseSpaceDescription, FR_EXPORT_ZIP_LOCATION, superUserIdentity);
            NotesAutoImportService.importNotes(enKnowledgeBaseSpaceName, enKnowledgeBaseSpaceDispalyName, enKnowledgeBaseSpaceDescription, EN_EXPORT_ZIP_LOCATION, superUserIdentity);
        }
        catch (Exception e) {
            log.error(" Error occured when trying to import notes for spaces {} and {}", new Object[]{enKnowledgeBaseSpaceName, frKnowledgeBaseSpaceName, e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private static void importNotes(String spaceName, String spaceDisplayName, String spaceDescription, String zipPath, Identity superUserIdentity) {
        block21: {
            if (importEnabled) {
                try {
                    SettingValue settingsValue;
                    String settingsValueString;
                    String groupId = "/spaces/" + spaceName;
                    Space space = spaceService.getSpaceByGroupId(groupId);
                    if (space == null) {
                        space = NotesAutoImportService.createSpace(spaceName, spaceDisplayName, spaceDescription, superUserIdentity);
                    }
                    if (space == null) break block21;
                    String folderPath = System.getProperty(TEMP_DIRECTORY_PATH);
                    ArrayList<String> files = new ArrayList<String>();
                    File destDir = new File(folderPath);
                    if (!destDir.exists()) {
                        destDir.mkdir();
                    }
                    Object notesFilePath = "";
                    InputStream in = NotesAutoImportService.class.getResourceAsStream(zipPath);
                    try (ZipInputStream zipIn = new ZipInputStream(in);){
                        ZipEntry entry = zipIn.getNextEntry();
                        while (entry != null) {
                            String filePath = folderPath + File.separator + entry.getName();
                            if (!entry.isDirectory()) {
                                Utils.extractFile(zipIn, filePath);
                                if (filePath.contains("notesExport_")) {
                                    notesFilePath = filePath;
                                }
                                files.add(filePath);
                            } else {
                                File dir = new File(filePath);
                                dir.mkdirs();
                            }
                            zipIn.closeEntry();
                            entry = zipIn.getNextEntry();
                        }
                    }
                    long exportTime = 0L;
                    if (StringUtils.isNotEmpty((CharSequence)notesFilePath)) {
                        ObjectMapper mapper = new ObjectMapper();
                        File notesFile = new File((String)notesFilePath);
                        ImportList notes = (ImportList)mapper.readValue(notesFile, (TypeReference)new TypeReference<ImportList>(){});
                        try {
                            exportTime = notes.getExportDate();
                        }
                        catch (Exception e) {
                            exportTime = 0L;
                        }
                    }
                    String string = settingsValueString = (settingsValue = settingService.get(NOTES_IMPORT_CONTEXT, NOTES_IMPORT_SCOPE, spaceName)) == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
                    if (exportTime == 0L || settingsValue == null || exportTime != Long.valueOf(settingsValueString)) {
                        log.info(" Start import notes for space {}", new Object[]{spaceName});
                        Wiki wiki = wikiService.getWikiByTypeAndOwner(WikiType.GROUP.toString().toLowerCase(), space.getGroupId());
                        if (wiki == null) {
                            wiki = wikiService.createWiki(WikiType.GROUP.toString().toLowerCase(), space.getGroupId());
                        }
                        if (wiki != null) {
                            noteService.importNotes(files, wiki.getWikiHome(), importConflictMode, superUserIdentity);
                            settingService.set(NOTES_IMPORT_CONTEXT, NOTES_IMPORT_SCOPE, spaceName, SettingValue.create((String)String.valueOf(exportTime)));
                        }
                        log.info(" End import notes for space {}", new Object[]{spaceName});
                    } else {
                        log.info("No notes to import for space {}", new Object[]{spaceName});
                    }
                }
                catch (Exception e) {
                    log.info(" Error when trying to import notes for space {}", new Object[]{spaceName, e});
                }
            }
        }
    }

    private static Space createSpace(String prettyName, String displayName, String description, Identity superUserIdentity) throws Exception {
        Space space = new Space();
        space.setDisplayName(displayName);
        space.setDescription(description);
        space.setPrettyName(prettyName);
        space.setVisibility("hidden");
        space.setRegistration("closed");
        Optional<SpaceTemplate> communitySpaceTemplate = spaceTemplateService.getSpaceTemplates().stream().filter(template -> template.getLayout().equals("community")).findFirst();
        if (!communitySpaceTemplate.isPresent()) {
            log.warn((Object)"KB Spaces not created since space templated not yet initialized");
            return null;
        }
        space.setTemplateId(communitySpaceTemplate.get().getId());
        space = spaceService.createSpace(space, superUserIdentity.getUserId());
        if (navigationService.loadNode(SiteKey.group((String)space.getGroupId())) == null) {
            spaceLayoutService.createSpaceSite(space);
        }
        return space;
    }

    static {
        enKnowledgeBaseSpaceName = "exo_knowledge_base_en";
        frKnowledgeBaseSpaceName = "exo_knowledge_base_fr";
        enKnowledgeBaseSpaceDispalyName = "eXo knowledge base";
        frKnowledgeBaseSpaceDispalyName = "Base de connaissance eXo";
        enKnowledgeBaseSpaceDescription = "eXo knowledge base space";
        frKnowledgeBaseSpaceDescription = "Espace pour la base de connaissance eXo";
        importEnabled = false;
        importConflictMode = "replaceAll";
    }
}

