/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;

public class TimestampExtension
implements BayeuxServer.Extension {
    private final DateTimeFormatter formatter;

    public TimestampExtension() {
        this("EEE MMM dd HH:mm:ss zzz yyyy");
    }

    public TimestampExtension(String format) {
        this(format, TimeZone.getDefault());
    }

    public TimestampExtension(String format, TimeZone tz) {
        this.formatter = DateTimeFormatter.ofPattern(format).withZone(tz.toZoneId());
    }

    public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        this.timestamp(message);
        return true;
    }

    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        this.timestamp(message);
        return true;
    }

    private void timestamp(ServerMessage.Mutable message) {
        message.put((Object)"timestamp", (Object)this.formatter.format(Instant.now()));
    }
}

