/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.hibernate.boot.archive.internal.StandardArchiveDescriptorFactory;
import org.hibernate.boot.archive.scan.spi.AbstractScannerImpl;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanParameters;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;

public class JPADatasourceEntityScanner
extends AbstractScannerImpl {
    public JPADatasourceEntityScanner() {
        this((ArchiveDescriptorFactory)StandardArchiveDescriptorFactory.INSTANCE);
    }

    public JPADatasourceEntityScanner(ArchiveDescriptorFactory value) {
        super(value);
    }

    public ScanResult scan(final ScanEnvironment environment, ScanOptions options, ScanParameters params) {
        ScanEnvironment environmentWrapper = new ScanEnvironment(){

            public URL getRootUrl() {
                return environment.getRootUrl();
            }

            public List<URL> getNonRootUrls() {
                ArrayList<URL> nonRootUrls = new ArrayList<URL>();
                String rootPath = environment.getRootUrl().getPath();
                JPADatasourceEntityScanner.this.addPaths(nonRootUrls, rootPath, "exo-jpa-entities/entities.idx");
                JPADatasourceEntityScanner.this.addPaths(nonRootUrls, rootPath, "jpa-entities.idx");
                return nonRootUrls;
            }

            public List<String> getExplicitlyListedMappingFiles() {
                return environment.getExplicitlyListedMappingFiles();
            }

            public List<String> getExplicitlyListedClassNames() {
                return environment.getExplicitlyListedClassNames();
            }
        };
        return super.scan(environmentWrapper, options, params);
    }

    private void addPaths(List<URL> nonRootUrls, String rootPath, String entitiesIdxPath) {
        try {
            Enumeration<URL> entityFiles = ((Object)((Object)this)).getClass().getClassLoader().getResources(entitiesIdxPath);
            while (entityFiles.hasMoreElements()) {
                URL url = entityFiles.nextElement();
                if ((url = new URL(url.toExternalForm().replace("!/" + entitiesIdxPath, "").replace("jar:", "").replace(entitiesIdxPath, ""))).getPath().startsWith(rootPath)) continue;
                nonRootUrls.add(url);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't access class path loader resources", e);
        }
    }
}

