/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.context.ContextManagerListener;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.servlet.ServletContainerRequest;

public class RestServlet
extends AbstractHttpServlet
implements Connector {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.RestServlet");
    private static final long serialVersionUID = 2152962763071591181L;
    private List<ComponentRequestLifecycle> transactionalServices = null;

    protected void afterInit(ServletConfig config) throws ServletException {
        ContextManagerListener.registerIfNeeded((ExoContainer)this.getContainer(), (ServletContext)config.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onService(ExoContainer container, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        RequestLifeCycle.begin((ExoContainer)this.getContainer());
        RequestHandler requestHandler = (RequestHandler)container.getComponentInstanceOfType(RequestHandler.class);
        EnvironmentContext env = new EnvironmentContext();
        env.put(HttpServletRequest.class, httpRequest);
        env.put(HttpServletResponse.class, httpResponse);
        env.put(ServletConfig.class, this.config);
        env.put(ServletContext.class, this.getServletContext());
        try {
            EnvironmentContext.setCurrent(env);
            ServletContainerRequest request = new ServletContainerRequest(httpRequest);
            ContainerResponse response = new ContainerResponse(new ServletContainerResponseWriter(this, httpResponse));
            requestHandler.handleRequest(request, response);
        }
        catch (Exception e) {
            block14: {
                try {
                    if (this.isBrokenPipeError(e)) {
                        LOG.debug((Object)"Write socket error!", (Throwable)e);
                        break block14;
                    }
                    LOG.warn("An error occurred while calling REST endpoint {}, method: {}", new Object[]{httpRequest.getRequestURI(), httpRequest.getMethod(), e});
                }
                catch (Throwable throwable) {
                    Map results = RequestLifeCycle.end();
                    for (Map.Entry entry : results.entrySet()) {
                        if (entry.getValue() == null) continue;
                        LOG.error((Object)("An error occurred while calling the method endRequest on " + String.valueOf(entry.getKey())), (Throwable)entry.getValue());
                    }
                    EnvironmentContext.setCurrent(null);
                    for (ComponentRequestLifecycle service : this.getTransactionalServices()) {
                        if (!service.isStarted(this.getContainer())) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("The service {} didn't called endRequest, uri = {}, http method = {}. Commit transaction anyway.", new Object[]{service.getClass().getName(), httpRequest.getRequestURI(), httpRequest.getMethod()});
                        }
                        service.endRequest(this.getContainer());
                        if (!service.isStarted(this.getContainer())) continue;
                        LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName(), httpRequest.getRequestURI(), httpRequest.getMethod()});
                    }
                    throw throwable;
                }
            }
            Map results = RequestLifeCycle.end();
            for (Map.Entry entry : results.entrySet()) {
                if (entry.getValue() == null) continue;
                LOG.error((Object)("An error occurred while calling the method endRequest on " + String.valueOf(entry.getKey())), (Throwable)entry.getValue());
            }
            EnvironmentContext.setCurrent(null);
            for (ComponentRequestLifecycle service : this.getTransactionalServices()) {
                if (!service.isStarted(this.getContainer())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The service {} didn't called endRequest, uri = {}, http method = {}. Commit transaction anyway.", new Object[]{service.getClass().getName(), httpRequest.getRequestURI(), httpRequest.getMethod()});
                }
                service.endRequest(this.getContainer());
                if (!service.isStarted(this.getContainer())) continue;
                LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName(), httpRequest.getRequestURI(), httpRequest.getMethod()});
            }
        }
        Map results = RequestLifeCycle.end();
        for (Map.Entry entry : results.entrySet()) {
            if (entry.getValue() == null) continue;
            LOG.error((Object)("An error occurred while calling the method endRequest on " + String.valueOf(entry.getKey())), (Throwable)entry.getValue());
        }
        EnvironmentContext.setCurrent(null);
        for (ComponentRequestLifecycle service : this.getTransactionalServices()) {
            if (!service.isStarted(this.getContainer())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("The service {} didn't called endRequest, uri = {}, http method = {}. Commit transaction anyway.", new Object[]{service.getClass().getName(), httpRequest.getRequestURI(), httpRequest.getMethod()});
            }
            service.endRequest(this.getContainer());
            if (!service.isStarted(this.getContainer())) continue;
            LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName(), httpRequest.getRequestURI(), httpRequest.getMethod()});
        }
    }

    public List<ComponentRequestLifecycle> getTransactionalServices() {
        if (this.transactionalServices == null) {
            this.transactionalServices = this.getContainer().getComponentInstancesOfType(ComponentRequestLifecycle.class);
        }
        return this.transactionalServices;
    }

    private boolean isBrokenPipeError(Throwable e) {
        if ("org.apache.catalina.connector.ClientAbortException".equals(e.getClass().getName())) {
            return true;
        }
        if (e.getCause() != null && e.getCause() != e) {
            return this.isBrokenPipeError(e.getCause());
        }
        return false;
    }

    class ServletContainerResponseWriter
    implements ContainerResponseWriter {
        private HttpServletResponse servletResponse;

        ServletContainerResponseWriter(RestServlet this$0, HttpServletResponse response) {
            this.servletResponse = response;
        }

        @Override
        public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
            Object entity = response.getEntity();
            if (entity != null) {
                ServletOutputStream out = this.servletResponse.getOutputStream();
                entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
                out.flush();
            }
        }

        @Override
        public void writeHeaders(GenericContainerResponse response) throws IOException {
            if (this.servletResponse.isCommitted()) {
                return;
            }
            this.servletResponse.setStatus(response.getStatus());
            if (response.getHttpHeaders() != null) {
                for (Map.Entry e : response.getHttpHeaders().entrySet()) {
                    String name = (String)e.getKey();
                    for (Object o : (List)e.getValue()) {
                        String value = null;
                        if (o == null || (value = HeaderHelper.getHeaderAsString(o)) == null) continue;
                        this.servletResponse.addHeader(name, value);
                    }
                }
            }
        }
    }
}

