/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.config.tasks;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.tasks.SkinConfigTask;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ThemeTask
implements SkinConfigTask {
    private String styleName;
    private List<String> themeNames = new ArrayList<String>();

    private void bindingStyleName(Element element) {
        NodeList nodes = element.getElementsByTagName("style-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        String styleName = nodes.item(0).getFirstChild().getNodeValue();
        this.setStyleName(styleName);
    }

    private void bindingThemeNames(Element element) {
        NodeList nodes = element.getElementsByTagName("theme-name");
        if (nodes == null) {
            return;
        }
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            this.addThemeName(nodes.item(i).getFirstChild().getNodeValue());
        }
    }

    public void addThemeName(String _themeName) {
        this.themeNames.add(_themeName);
    }

    public void setStyleName(String _styleName) {
        this.styleName = _styleName;
    }

    @Override
    public void binding(Element elemt) {
        this.bindingStyleName(elemt);
        this.bindingThemeNames(elemt);
    }

    @Override
    public void execute(SkinService skinService, ServletContext scontext) {
        if (this.styleName == null || this.themeNames.size() < 1) {
            return;
        }
        skinService.addTheme(this.styleName, this.themeNames);
    }
}

