/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.attachment;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletInstanceService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class PortletInstanceAttachmentPlugin
extends AttachmentPlugin {
    public static final String OBJECT_TYPE = "portletInstance";
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private AttachmentService attachmentService;

    @PostConstruct
    public void init() {
        this.attachmentService.addPlugin((AttachmentPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        return userIdentity != null && this.layoutAclService.isAdministrator(userIdentity.getUserId());
    }

    public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        PortletInstance portletInstance = this.portletInstanceService.getPortletInstance(Long.parseLong(entityId));
        if (portletInstance == null) {
            throw new ObjectNotFoundException("Portlet instance not found");
        }
        List<String> permissions = portletInstance.getPermissions();
        return CollectionUtils.isEmpty(permissions) || userIdentity != null && permissions.stream().anyMatch(p -> this.layoutAclService.hasPermission(userIdentity.getUserId(), (String)p));
    }

    public long getAudienceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }
}

