/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.gamification.analytics.AnalyticsRealizationListener$AjcClosure1;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class AnalyticsRealizationListener
extends Listener<Object, Object> {
    private RuleService ruleService;
    private RealizationService realizationService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AnalyticsRealizationListener(RuleService ruleService, RealizationService realizationService, IdentityManager identityManager, SpaceService spaceService) {
        this.ruleService = ruleService;
        this.realizationService = realizationService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    @ExoTransactional
    public void onEvent(Event<Object, Object> event) throws Exception {
        Event<Object, Object> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        AnalyticsRealizationListener$AjcClosure1 analyticsRealizationListener$AjcClosure1 = new AnalyticsRealizationListener$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(analyticsRealizationListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private RealizationDTO getRealization(Object object) {
        if (object instanceof RealizationDTO) {
            RealizationDTO realization = (RealizationDTO)object;
            return realization;
        }
        if (object instanceof Announcement) {
            Announcement announcement = (Announcement)object;
            return this.realizationService.getRealizationById(announcement.getId());
        }
        return null;
    }

    static {
        AnalyticsRealizationListener.ajc$preClinit();
    }

    static final /* synthetic */ void onEvent_aroundBody0(AnalyticsRealizationListener ajc$this, Event event, JoinPoint joinPoint) {
        RealizationDTO realization = ajc$this.getRealization(event.getSource());
        if (realization == null) {
            return;
        }
        RuleDTO rule = ajc$this.ruleService.findRuleById(realization.getRuleId());
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("gamification");
        statisticData.setSubModule("realization");
        switch (event.getEventName()) {
            case "realization.created": 
            case "announcement.created": {
                statisticData.setOperation("createRealization");
                break;
            }
            case "realization.canceled": 
            case "announcement.canceled": {
                statisticData.setOperation("cancelRealization");
                break;
            }
            case "realization.updated": 
            case "announcement.updated": {
                statisticData.setOperation("updateRealization");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected listener event name: " + event.getEventName());
            }
        }
        Utils.addRealizationStatisticParameters(ajc$this.identityManager, ajc$this.spaceService, rule, rule.getEvent(), realization, statisticData);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AnalyticsRealizationListener.java", AnalyticsRealizationListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.gamification.analytics.AnalyticsRealizationListener", "org.exoplatform.services.listener.Event", "event", "java.lang.Exception", "void"), 73);
    }
}

