/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.rest.model.RealizationValidityContext;
import io.meeds.gamification.service.RealizationComputingService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.stereotype.Service;

@Service
public class RealizationComputingServiceImpl
implements RealizationComputingService {
    private RuleService ruleService;
    private RealizationService realizationService;
    private IdentityManager identityManager;

    public RealizationComputingServiceImpl(RuleService ruleService, RealizationService realizationService, IdentityManager identityManager) {
        this.ruleService = ruleService;
        this.realizationService = realizationService;
        this.identityManager = identityManager;
    }

    @Override
    public List<RuleDTO> getLockingRules(RuleFilter ruleFilter, String username, int offset, int limit) {
        LinkedHashMap filteredRules = new LinkedHashMap();
        ArrayList matchingParentRules = new ArrayList();
        int pageSize = 10;
        int rulesSize = this.ruleService.countRules(ruleFilter, username);
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        long identityId = identity.getIdentityId();
        for (int pageOffset = 0; pageOffset < rulesSize; pageOffset += pageSize) {
            List<RuleDTO> rules = this.ruleService.getRules(ruleFilter, username, pageOffset, pageSize);
            rules.forEach(r -> {
                filteredRules.put(r.getId(), r);
                RealizationValidityContext realizationValidityContext = this.realizationService.getRealizationValidityContext((RuleDTO)r, identityId);
                if (realizationValidityContext.isValidButLocked() && CollectionUtils.isNotEmpty(r.getPrerequisiteRuleIds())) {
                    matchingParentRules.add(r);
                }
            });
        }
        ArrayList lockingRuleIds = new ArrayList();
        matchingParentRules.forEach(r -> {
            Set<Long> prerequisiteRuleIds = r.getPrerequisiteRuleIds();
            if (CollectionUtils.isNotEmpty(prerequisiteRuleIds)) {
                this.realizationService.getRealizationValidityContext((RuleDTO)r, identityId).getValidPrerequisites().entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).map(Long::parseLong).filter(filteredRules::containsKey).map(filteredRules::get).filter(prerequesiteRule -> this.realizationService.getRealizationValidityContext((RuleDTO)prerequesiteRule, identityId).isValid()).map(RuleDTO::getId).forEach(lockingRuleIds::add);
            }
        });
        return filteredRules.values().stream().filter(r -> lockingRuleIds.contains(r.getId())).skip(offset).limit(limit).toList();
    }
}

