/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.text.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nl.captcha.text.renderer.WordRenderer;

public class DefaultWordRenderer
implements WordRenderer {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final List<Font> DEFAULT_FONTS = new ArrayList<Font>();
    private final Color _color;
    private final List<Font> _fonts;

    public DefaultWordRenderer() {
        this(DEFAULT_COLOR, DEFAULT_FONTS);
    }

    public DefaultWordRenderer(Color color, List<Font> fonts) {
        this._color = color != null ? color : DEFAULT_COLOR;
        this._fonts = fonts != null ? fonts : DEFAULT_FONTS;
    }

    @Override
    public void render(String word, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g.setRenderingHints(hints);
        g.setColor(this._color);
        FontRenderContext frc = g.getFontRenderContext();
        int startPosX = 25;
        char[] wc = word.toCharArray();
        Random generator = new Random();
        for (char element : wc) {
            char[] itchar = new char[]{element};
            int choiceFont = generator.nextInt(this._fonts.size());
            Font itFont = this._fonts.get(choiceFont);
            g.setFont(itFont);
            GlyphVector gv = itFont.createGlyphVector(frc, itchar);
            double charWitdth = gv.getVisualBounds().getWidth();
            g.drawChars(itchar, 0, itchar.length, startPosX, 35);
            startPosX += (int)charWitdth;
        }
    }

    static {
        DEFAULT_FONTS.add(new Font("Arial", 1, 40));
        DEFAULT_FONTS.add(new Font("Courier", 1, 40));
    }
}

