/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import java.util.List;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ProgramDeletedRuleListener
extends Listener<ProgramDTO, String> {
    private static final Log LOG = ExoLogger.getLogger(ProgramDeletedRuleListener.class);
    protected ProgramService programService;
    protected RuleService ruleService;

    public ProgramDeletedRuleListener(ProgramService programService, RuleService ruleService) {
        this.programService = programService;
        this.ruleService = ruleService;
    }

    public void onEvent(Event<ProgramDTO, String> event) throws Exception {
        ProgramDTO program = (ProgramDTO)event.getSource();
        if (!program.isDeleted()) {
            LOG.warn("Program {} seems not deleted. Ignore marking Program rules as deleted as well.", new Object[]{program.getId()});
            return;
        }
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setProgramId(program.getId());
        ruleFilter.setIncludeDeleted(true);
        List<RuleDTO> rules = this.ruleService.getRules(ruleFilter, 0, -1);
        rules.stream().filter(r -> !r.isDeleted()).map(RuleDTO::getId).forEach(this.ruleService::deleteRuleById);
    }
}

