/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.Ordered;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class KotlinBeanInfoFactory
implements BeanInfoFactory,
Ordered {
    public BeanInfo getBeanInfo(final Class<?> beanClass) throws IntrospectionException {
        if (beanClass.isInterface() || beanClass.isEnum()) {
            return null;
        }
        if (!KotlinDetector.isKotlinReflectPresent() || !KotlinDetector.isKotlinType(beanClass)) {
            return null;
        }
        KClass kotlinClass = JvmClassMappingKt.getKotlinClass(beanClass);
        Collection members = kotlinClass.getMembers();
        LinkedHashMap<String, PropertyDescriptor> descriptors = new LinkedHashMap<String, PropertyDescriptor>(members.size(), 1.0f);
        for (KCallable member : kotlinClass.getMembers()) {
            Method setter;
            if (!(member instanceof KProperty)) continue;
            KProperty property = (KProperty)member;
            Method getter = ReflectJvmMapping.getJavaGetter((KProperty)property);
            if (property instanceof KMutableProperty) {
                KMutableProperty kmp = (KMutableProperty)property;
                v0 = ReflectJvmMapping.getJavaSetter((KMutableProperty)kmp);
            } else {
                v0 = setter = null;
            }
            if (getter == null) {
                Type javaType = ReflectJvmMapping.getJavaType((KType)property.getReturnType());
                getter = ReflectionUtils.findMethod(beanClass, (String)(javaType == Boolean.TYPE ? "is" : "get" + StringUtils.capitalize((String)property.getName())));
            }
            if (getter != null) {
                getter = ClassUtils.getMostSpecificMethod((Method)getter, beanClass);
            }
            if (getter != null && (Modifier.isStatic(getter.getModifiers()) || getter.getParameterCount() != 0) || getter != null && setter != null && setter.getParameterCount() == 1 && !getter.getReturnType().equals(setter.getParameters()[0].getType())) continue;
            descriptors.put(property.getName(), new PropertyDescriptor(property.getName(), getter, setter));
        }
        Class<?> javaClass = beanClass;
        while (KotlinDetector.isKotlinType(javaClass = javaClass.getSuperclass())) {
        }
        if (javaClass != Object.class) {
            PropertyDescriptor[] javaPropertyDescriptors;
            for (PropertyDescriptor descriptor : javaPropertyDescriptors = BeanUtils.getPropertyDescriptors(javaClass)) {
                descriptor = new PropertyDescriptor(descriptor.getName(), KotlinBeanInfoFactory.specialize(beanClass, descriptor.getReadMethod()), KotlinBeanInfoFactory.specialize(beanClass, descriptor.getWriteMethod()));
                descriptors.put(descriptor.getName(), descriptor);
            }
        }
        final PropertyDescriptor[] propertyDescriptors = descriptors.values().toArray(new PropertyDescriptor[0]);
        return new SimpleBeanInfo(){

            @Override
            public BeanDescriptor getBeanDescriptor() {
                return new BeanDescriptor(beanClass);
            }

            @Override
            public PropertyDescriptor[] getPropertyDescriptors() {
                return propertyDescriptors;
            }
        };
    }

    @Nullable
    private static Method specialize(Class<?> beanClass, @Nullable Method method) {
        if (method == null) {
            return method;
        }
        return ClassUtils.getMostSpecificMethod((Method)method, beanClass);
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }
}

