/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;

public class FetchOverrideSecondPass
implements SecondPass {
    private final String fetchProfileName;
    private final FetchProfile.FetchOverride fetch;
    private final MetadataBuildingContext buildingContext;

    public FetchOverrideSecondPass(String fetchProfileName, FetchProfile.FetchOverride fetch, MetadataBuildingContext buildingContext) {
        this.fetchProfileName = fetchProfileName;
        this.fetch = fetch;
        this.buildingContext = buildingContext;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        this.buildingContext.getMetadataCollector().getEntityBinding(this.fetch.entity().getName()).getProperty(this.fetch.association());
        FetchProfile profile = this.buildingContext.getMetadataCollector().getFetchProfile(this.fetchProfileName);
        profile.addFetch(new FetchProfile.Fetch(this.fetch.entity().getName(), this.fetch.association(), this.fetch.mode(), this.fetch.fetch()));
    }
}

