/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.notes.model.NoteFeaturedImage;
import io.meeds.notes.model.NoteMetadataObject;
import io.meeds.notes.model.NotePageProperties;
import io.meeds.social.cms.service.CMSService;
import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.utils.HtmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.ImportList;
import org.exoplatform.wiki.model.NoteToExport;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.storage.NoteDataStorage;
import org.gatein.api.EntityNotFoundException;

public class NoteServiceImpl
implements NoteService {
    private static final String DRAFT_PAGE_ID_PROP_NAME = "draftPageId";
    private static final String PAGE_VERSION_ID_PROP_NAME = "pageVersionId";
    private static final String UNTITLED_PREFIX = "Untitled_";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private static final String FEATURED_IMAGE_FOLDER = "featuredImages";
    private static final String FILE_NAME_SPACE = "wiki";
    private static final String IMAGE_URL_REPLACEMENT_PREFIX = "//-";
    private static final String IMAGE_URL_REPLACEMENT_SUFFIX = "-//";
    private static final Pattern IMAGES_IMPORT_PATTERN = Pattern.compile("src=\"//-(.*?)-//\"");
    private static final Log log = ExoLogger.getLogger(NoteServiceImpl.class);
    private static final MetadataType NOTES_METADATA_TYPE = new MetadataType(1001L, "notes");
    private static final MetadataKey NOTES_METADATA_KEY = new MetadataKey(NOTES_METADATA_TYPE.getName(), "notes", 0L);
    public static final String NOTE_METADATA_PAGE_OBJECT_TYPE = "notePage";
    public static final String NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE = "noteDraftPage";
    public static final String NOTE_METADATA_VERSION_PAGE_OBJECT_TYPE = "noteVersionPage";
    public static final String SUMMARY_PROP = "summary";
    public static final String HIDE_AUTHOR_PROP = "hideAuthor";
    public static final String HIDE_REACTION_PROP = "hideReaction";
    public static final String FEATURED_IMAGE_ID = "featuredImageId";
    public static final String FEATURED_IMAGE_UPDATED_DATE = "featuredImageUpdatedDate";
    public static final String FEATURED_IMAGE_ALT_TEXT = "featuredImageAltText";
    public static final String NOTE_DELETED = "note.deleted";
    private final WikiService wikiService;
    private final NoteDataStorage dataStorage;
    private final IdentityManager identityManager;
    private final SpaceService spaceService;
    private final CMSService cmsService;
    private final ListenerService listenerService;
    private final FileService fileService;
    private final UploadService uploadService;
    private final MetadataService metadataService;
    private final ImageThumbnailService imageThumbnailService;
    private final AttachmentService attachmentService;
    private final LocaleConfigService localeConfigService;
    private final LayoutService layoutService;
    private final UserACL userAcl;

    public NoteServiceImpl(NoteDataStorage dataStorage, WikiService wikiService, IdentityManager identityManager, SpaceService spaceService, CMSService cmsService, ListenerService listenerService, LocaleConfigService localeConfigService, FileService fileService, UploadService uploadService, MetadataService metadataService, ImageThumbnailService imageThumbnailService, AttachmentService attachmentService, LayoutService layoutService, UserACL userAcl) {
        this.userAcl = userAcl;
        this.layoutService = layoutService;
        this.dataStorage = dataStorage;
        this.wikiService = wikiService;
        this.identityManager = identityManager;
        this.localeConfigService = localeConfigService;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
        this.cmsService = cmsService;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.metadataService = metadataService;
        this.imageThumbnailService = imageThumbnailService;
        this.attachmentService = attachmentService;
    }

    @Override
    public Page createNote(Wiki noteBook, String parentNoteName, Page note, Identity userIdentity, boolean importMode, boolean broadcast) throws WikiException, IllegalAccessException {
        if (userIdentity == null || !this.wikiService.canManageWiki(noteBook.getType(), noteBook.getOwner(), userIdentity.getUserId())) {
            throw new IllegalAccessException(String.format("Authorization error while addin new note in wiki %s:%s", noteBook.getType(), noteBook.getOwner()));
        }
        if (importMode) {
            String pageName = TitleResolver.getId(note.getName(), false);
            if (pageName == null) {
                pageName = TitleResolver.getId(note.getTitle(), false);
            }
            note.setName(pageName);
        }
        if (this.isExisting(noteBook.getType(), noteBook.getOwner(), note.getName())) {
            throw new WikiException("Page " + noteBook.getType() + ":" + noteBook.getOwner() + ":" + note.getName() + " already exists, cannot create it.");
        }
        Page parentPage = this.getNoteOfNoteBookByName(noteBook.getType(), noteBook.getOwner(), parentNoteName);
        if (parentPage != null) {
            note.setOwner(userIdentity.getUserId());
            note.setAuthor(userIdentity.getUserId());
            note.setContent(note.getContent());
            Page createdPage = this.createNote(noteBook, parentPage, note, broadcast);
            NotePageProperties properties = note.getProperties();
            String draftPageId = properties != null && properties.isDraft() ? String.valueOf(properties.getNoteId()) : null;
            try {
                if (properties != null) {
                    properties.setNoteId(Long.parseLong(createdPage.getId()));
                    properties.setDraft(false);
                    properties = this.saveNoteMetadata(properties, note.getLang(), Long.valueOf(this.identityManager.getOrCreateUserIdentity(userIdentity.getUserId()).getId()));
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to save note metadata", (Throwable)e);
            }
            createdPage.setProperties(properties);
            if (StringUtils.isNotEmpty((CharSequence)createdPage.getContent())) {
                createdPage.setAttachmentObjectType(note.getAttachmentObjectType());
                createdPage = this.processImagesOnNoteCreation(createdPage, draftPageId, Long.valueOf(this.identityManager.getOrCreateUserIdentity(userIdentity.getUserId()).getId()));
            }
            createdPage.setCanManage(this.canEditNote(note, note.getAuthor()));
            createdPage.setCanImport(this.canEditNote(note, note.getAuthor()));
            createdPage.setCanView(this.canViewNote(note, note.getAuthor()));
            this.dataStorage.addPageVersion(createdPage, userIdentity.getUserId());
            PageVersion pageVersion = this.dataStorage.getPublishedVersionByPageIdAndLang(Long.valueOf(createdPage.getId()), createdPage.getLang());
            createdPage.setLatestVersionId(pageVersion != null ? pageVersion.getId() : null);
            if (pageVersion != null && draftPageId != null) {
                HashMap<String, String> eventData = new HashMap<String, String>();
                eventData.put(DRAFT_PAGE_ID_PROP_NAME, draftPageId);
                eventData.put(PAGE_VERSION_ID_PROP_NAME, pageVersion.getId());
                org.exoplatform.wiki.utils.Utils.broadcast(this.listenerService, "note.page.version.created", this, eventData);
            }
            return createdPage;
        }
        throw new EntityNotFoundException("Parent note not found");
    }

    @Override
    public Page createNote(Wiki noteBook, String parentNoteName, Page note, Identity userIdentity) throws WikiException, IllegalAccessException {
        return this.createNote(noteBook, parentNoteName, note, userIdentity, true);
    }

    @Override
    public Page createNote(Wiki noteBook, String parentNoteName, Page note, Identity userIdentity, boolean broadcast) throws WikiException, IllegalAccessException {
        return this.createNote(noteBook, parentNoteName, note, userIdentity, true, broadcast);
    }

    @Override
    public Page createNote(Wiki noteBook, Page parentPage, Page note) throws WikiException {
        return this.createNote(noteBook, parentPage, note, true);
    }

    @Override
    public Page createNote(Wiki noteBook, Page parentPage, Page note, boolean broadcast) throws WikiException {
        Page createdPage = this.dataStorage.createPage(noteBook, parentPage, note);
        createdPage.setToBePublished(note.isToBePublished());
        createdPage.setToBePublished(note.isToBePublished());
        createdPage.setAppName(note.getAppName());
        createdPage.setUrl(org.exoplatform.wiki.utils.Utils.getPageUrl(createdPage));
        createdPage.setLang(note.getLang());
        org.exoplatform.wiki.utils.Utils.broadcast(this.listenerService, "note.posted", note.getAuthor(), createdPage);
        this.processPageContent(createdPage, note.getLang());
        if (broadcast) {
            this.postAddPage(noteBook.getType(), noteBook.getOwner(), note.getName(), createdPage);
            Matcher mentionMatcher = org.exoplatform.wiki.utils.Utils.MENTION_PATTERN.matcher(createdPage.getContent());
            if (mentionMatcher.find()) {
                org.exoplatform.wiki.utils.Utils.sendMentionInNoteNotification(createdPage, null, createdPage.getAuthor());
            }
        }
        return createdPage;
    }

    @Override
    public Page updateNote(Page note, PageUpdateType type) throws WikiException {
        return this.saveNote(note, type, null, true);
    }

    @Override
    public Page updateNote(Page note, PageUpdateType type, Identity userIdentity) throws Exception {
        return this.updateNote(note, type, userIdentity, true);
    }

    @Override
    public Page updateNote(Page note, PageUpdateType type, Identity userIdentity, boolean broadcast) throws Exception {
        Page existingNote = this.getNoteById(note.getId());
        if (existingNote == null) {
            throw new EntityNotFoundException("Note to update not found");
        }
        if (userIdentity == null || !this.canEditNote(existingNote, userIdentity.getUserId())) {
            throw new IllegalAccessException("User does not have edit the note.");
        }
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)type) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)type) || PageUpdateType.EDIT_PAGE_PROPERTIES.equals((Object)type)) {
            note.setUpdatedDate(Calendar.getInstance().getTime());
        }
        return this.saveNote(note, type, userIdentity, broadcast);
    }

    @Override
    public Page updateNote(Page note) {
        return this.saveNote(note, null, null, false);
    }

    @Override
    public void deleteNote(String noteId) {
        this.dataStorage.deletePage(noteId);
    }

    @Override
    public boolean deleteNote(String wikiType, String wikiOwner, String noteName) {
        if ("Home".equals(noteName) || noteName == null) {
            return false;
        }
        this.dataStorage.deletePage(wikiType, wikiOwner, noteName);
        return true;
    }

    @Override
    public boolean deleteNote(String wikiType, String wikiOwner, String noteName, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        if ("Home".equals(noteName) || noteName == null) {
            return false;
        }
        Page note = this.getNoteOfNoteBookByName(wikiType, wikiOwner, noteName);
        if (note == null) {
            log.error((Object)("Can't delete note '" + noteName + "'. This note does not exist."));
            throw new EntityNotFoundException("Note to delete not found");
        }
        if (userIdentity == null || !this.canEditNote(note, userIdentity.getUserId())) {
            throw new IllegalAccessException("User does not have edit permissions on the note.");
        }
        ArrayList<Page> allChrildrenPages = new ArrayList<Page>();
        LinkedList<Page> queue = new LinkedList<Page>();
        queue.add(note);
        while (!queue.isEmpty()) {
            Page tempPage = (Page)queue.poll();
            List<Page> childrenPages = this.getChildrenNoteOf(tempPage, false, false);
            for (Page childPage : childrenPages) {
                queue.add(childPage);
                allChrildrenPages.add(childPage);
            }
        }
        this.deleteNote(wikiType, wikiOwner, noteName);
        this.postDeletePage(wikiType, wikiOwner, noteName, note);
        org.exoplatform.wiki.utils.Utils.broadcast(this.listenerService, NOTE_DELETED, userIdentity, note);
        this.processPageContent(note.getId(), "", null);
        for (Page childNote : allChrildrenPages) {
            this.postDeletePage(childNote.getWikiType(), childNote.getWikiOwner(), childNote.getName(), childNote);
        }
        return true;
    }

    @Override
    public boolean renameNote(String noteType, String noteOwner, String noteName, String newName, String newTitle) throws WikiException {
        if ("Home".equals(noteName) || noteName == null) {
            return false;
        }
        if (!noteName.equals(newName) && this.isExisting(noteType, noteOwner, newName)) {
            throw new WikiException("Note " + noteType + ":" + noteOwner + ":" + newName + " already exists, cannot rename it.");
        }
        this.dataStorage.renamePage(noteType, noteOwner, noteName, newName, newTitle);
        Page page = new Page(noteName);
        page.setWikiType(noteType);
        page.setWikiOwner(noteOwner);
        return true;
    }

    @Override
    public void moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        this.dataStorage.movePage(currentLocationParams, newLocationParams);
    }

    @Override
    public boolean moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        try {
            Page moveNote = this.getNoteOfNoteBookByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
            if (moveNote == null) {
                throw new EntityNotFoundException("Note to move not found");
            }
            if (userIdentity == null || !this.canEditNote(moveNote, userIdentity.getUserId())) {
                throw new IllegalAccessException("User does not have edit the note.");
            }
            this.moveNote(currentLocationParams, newLocationParams);
            Page note = new Page(currentLocationParams.getPageName());
            note.setWikiType(currentLocationParams.getType());
            note.setWikiOwner(currentLocationParams.getOwner());
            this.postUpdatePage(newLocationParams.getType(), newLocationParams.getOwner(), moveNote.getName(), moveNote, PageUpdateType.MOVE_PAGE);
        }
        catch (WikiException e) {
            log.error((Object)("Can't move note '" + currentLocationParams.getPageName() + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName) throws WikiException {
        Page page = null;
        page = this.dataStorage.getPageOfWikiByName(noteType, noteOwner, noteName);
        this.checkToRemoveDomainInUrl(page);
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        Page page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName, userIdentity);
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            if (source.equals("tree")) {
                this.postOpenByTree(noteType, noteOwner, noteName, page);
            }
            if (source.equals("breadCrumb")) {
                this.postOpenByBreadCrumb(noteType, noteOwner, noteName, page);
            }
        }
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, String lang, Identity userIdentity) throws WikiException, IllegalAccessException {
        Page page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName, userIdentity);
        if (lang != null) {
            page.setMetadatas(this.retrieveMetadataItems(page.getId() + "-" + lang, userIdentity.getUserId()));
        }
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity) throws IllegalAccessException, WikiException {
        Page page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (page == null) {
            throw new EntityNotFoundException("page not found");
        }
        if (!this.canViewNote(page, userIdentity.getUserId())) {
            throw new IllegalAccessException("User does not have view the note.");
        }
        page.setCanView(true);
        page.setCanManage(this.canEditNote(page, userIdentity.getUserId()));
        page.setCanImport(this.wikiService.canManageWiki(page.getWikiType(), page.getWikiOwner(), userIdentity.getUserId()));
        Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(page.getId(), userIdentity.getUserId());
        page.setMetadatas(metadata);
        return page;
    }

    @Override
    public Page getNoteById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataStorage.getPageById(id);
    }

    @Override
    public DraftPage getDraftNoteById(String id, String userId) throws IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DraftPage draftPage = this.getDraftNoteById(id);
        this.computeDraftProps(draftPage, userId);
        return draftPage;
    }

    @Override
    public DraftPage getDraftNoteById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataStorage.getDraftPageById(id);
    }

    @Override
    public DraftPage getLatestDraftOfPage(Page targetPage) throws WikiException {
        if (targetPage == null) {
            return null;
        }
        return this.dataStorage.getLatestDraftOfPage(targetPage);
    }

    @Override
    public DraftPage getLatestDraftOfPage(Page targetPage, String username) throws WikiException {
        return this.getLatestDraftOfPage(targetPage);
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity) throws IllegalAccessException, WikiException {
        Page page = this.getNoteById(id);
        if (page == null) {
            return null;
        }
        if (!this.canViewNote(page, userIdentity.getUserId())) {
            throw new IllegalAccessException("User does not have view the note.");
        }
        page.setCanView(true);
        page.setCanManage(this.canEditNote(page, userIdentity.getUserId()));
        page.setCanImport(this.canEditNote(page, userIdentity.getUserId()));
        return page;
    }

    @Override
    public boolean canViewNote(Page page, String username) {
        if (page == null) {
            return false;
        }
        String wikiOwner = page.getWikiOwner();
        String wikiType = page.getWikiType();
        String pageOwner = page.getOwner();
        if (page.isDraftPage()) {
            return this.canEditNote(page, username);
        }
        if ("terms".equals(wikiType) && "termsAndConditions".equals(page.getName())) {
            return true;
        }
        if ((StringUtils.equals((CharSequence)pageOwner, (CharSequence)IdentityConstants.SYSTEM) || StringUtils.isBlank((CharSequence)pageOwner)) && this.cmsService.hasAccessPermission(org.exoplatform.wiki.utils.Utils.getIdentity(username), NOTE_METADATA_PAGE_OBJECT_TYPE, page.getName())) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)WikiType.PORTAL.name(), (CharSequence)wikiType)) {
            PortalConfig portalConfig = this.layoutService.getPortalConfig(wikiOwner);
            return this.userAcl.hasAccessPermission(portalConfig, this.userAcl.getUserIdentity(username));
        }
        if (StringUtils.isBlank((CharSequence)wikiType) || StringUtils.equalsIgnoreCase((CharSequence)WikiType.GROUP.name(), (CharSequence)wikiType)) {
            Space space = this.getSpaceByWiki(wikiType, wikiOwner);
            return space == null ? this.userAcl.hasPermission(this.userAcl.getUserIdentity(username), String.format("%s:%s", this.userAcl.getAdminMSType(), wikiOwner)) : this.spaceService.canViewSpace(space, username);
        }
        return this.spaceService.isSuperManager(username) || StringUtils.equals((CharSequence)pageOwner, (CharSequence)username);
    }

    @Override
    public boolean canEditNote(Page page, String username) {
        if (page == null) {
            return false;
        }
        if (this.wikiService.canManageWiki(page.getWikiType(), page.getWikiOwner(), username)) {
            return true;
        }
        if (page.isDraftPage()) {
            return page.getParent() == null && StringUtils.equals((CharSequence)username, (CharSequence)page.getAuthor());
        }
        if ((StringUtils.equals((CharSequence)page.getOwner(), (CharSequence)IdentityConstants.SYSTEM) || StringUtils.isBlank((CharSequence)page.getOwner())) && this.cmsService.hasEditPermission(org.exoplatform.wiki.utils.Utils.getIdentity(username), NOTE_METADATA_PAGE_OBJECT_TYPE, page.getName())) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)WikiType.PORTAL.name(), (CharSequence)page.getWikiType())) {
            PortalConfig portalConfig = this.layoutService.getPortalConfig(page.getWikiOwner());
            return this.userAcl.hasEditPermission(portalConfig, this.userAcl.getUserIdentity(username));
        }
        return false;
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        String username;
        Page page = this.getNoteById(id);
        String string = username = userIdentity == null ? null : userIdentity.getUserId();
        if (page == null) {
            return null;
        }
        if (!this.canViewNote(page, username)) {
            throw new IllegalAccessException("User does not have view the note.");
        }
        page.setCanView(true);
        page.setUrl(org.exoplatform.wiki.utils.Utils.getPageUrl(page));
        boolean canManageNotes = this.wikiService.canManageWiki(page.getWikiType(), page.getWikiOwner(), username);
        page.setCanManage(canManageNotes || this.canEditNote(page, username));
        page.setCanImport(canManageNotes);
        if (username != null) {
            Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(id, username);
            page.setMetadatas(metadata);
        }
        if (StringUtils.isNotBlank((CharSequence)source)) {
            if (source.equals("tree")) {
                this.postOpenByTree(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
            }
            if (source.equals("breadCrumb")) {
                this.postOpenByBreadCrumb(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
            }
        }
        return page;
    }

    @Override
    public Page getParentNoteOf(Page note) throws WikiException {
        return this.dataStorage.getParentPageOf(note);
    }

    @Override
    public NoteToExport getParentNoteOf(NoteToExport note) throws WikiException {
        Page page = new Page();
        page.setId(note.getId());
        page.setName(note.getName());
        page.setWikiId(note.getWikiId());
        page.setWikiOwner(note.getWikiOwner());
        page.setWikiType(note.getWikiType());
        Page parent = this.getParentNoteOf(page);
        if (parent == null) {
            return null;
        }
        return new NoteToExport(parent.getId(), parent.getName(), parent.getOwner(), parent.getAuthor(), parent.getContent(), parent.getSyntax(), parent.getTitle(), parent.getComment(), parent.getWikiId(), parent.getWikiType(), parent.getWikiOwner());
    }

    @Override
    public List<Page> getChildrenNoteOf(Page note, boolean withDrafts, boolean withChild) throws WikiException {
        return this.dataStorage.getChildrenPageOf(note, withDrafts, withChild);
    }

    @Override
    public boolean hasChildren(long pageId) {
        return this.dataStorage.hasChildren(pageId);
    }

    @Override
    public boolean hasDrafts(long pageId) {
        return this.dataStorage.hasDrafts(pageId);
    }

    @Override
    public List<Page> getChildrenNoteOf(Page note, String userId, boolean withDrafts, boolean withChild) throws WikiException {
        return this.getChildrenNoteOf(note, withDrafts, withChild);
    }

    @Override
    public List<NoteToExport> getChildrenNoteOf(NoteToExport note) throws WikiException {
        Page page = new Page();
        page.setId(note.getId());
        page.setName(note.getName());
        page.setWikiId(note.getWikiId());
        page.setWikiOwner(note.getWikiOwner());
        page.setWikiType(note.getWikiType());
        List<Page> pages = this.getChildrenNoteOf(page, false, false);
        ArrayList<NoteToExport> children = new ArrayList<NoteToExport>();
        for (Page child : pages) {
            if (child == null) continue;
            children.add(new NoteToExport(child.getId(), child.getName(), child.getOwner(), child.getAuthor(), child.getContent(), child.getSyntax(), child.getTitle(), child.getComment(), child.getWikiId(), child.getWikiType(), child.getWikiOwner()));
        }
        return children;
    }

    @Override
    public List<NoteToExport> getChildrenNoteOf(NoteToExport note, String userId) throws WikiException {
        return this.getChildrenNoteOf(note);
    }

    @Override
    public List<BreadcrumbData> getBreadCrumb(String noteType, String noteOwner, String noteName, boolean isDraftNote) throws WikiException, IllegalAccessException {
        return this.getBreadCrumb(null, noteType, noteOwner, noteName, null, null, isDraftNote);
    }

    @Override
    public List<BreadcrumbData> getBreadCrumb(String noteType, String noteOwner, String noteName, String lang, Identity userIdentity, boolean isDraftNote) throws WikiException, IllegalAccessException {
        return this.getBreadCrumb(null, noteType, noteOwner, noteName, lang, userIdentity, isDraftNote);
    }

    @Override
    public List<Page> getDuplicateNotes(Page parentNote, Wiki targetNoteBook, List<Page> resultList) throws WikiException {
        if (resultList == null) {
            resultList = new ArrayList<Page>();
        }
        if (resultList.size() > 6) {
            return resultList;
        }
        if (this.isExisting(targetNoteBook.getType(), targetNoteBook.getOwner(), parentNote.getName())) {
            resultList.add(parentNote);
        }
        List<Page> childrenNotes = this.getChildrenNoteOf(parentNote, false, false);
        for (Page note : childrenNotes) {
            this.getDuplicateNotes(note, targetNoteBook, resultList);
        }
        return resultList;
    }

    @Override
    public List<Page> getDuplicateNotes(Page parentNote, Wiki targetNoteBook, List<Page> resultList, String userId) throws WikiException {
        return this.getDuplicateNotes(parentNote, targetNoteBook, resultList);
    }

    @Override
    public void removeDraftOfNote(WikiPageParams param) throws WikiException {
        Page page = this.getNoteOfNoteBookByName(param.getType(), param.getOwner(), param.getPageName());
        this.removeDraftOfNote(page);
    }

    @Override
    public void removeDraftOfNote(Page page, String username) throws WikiException {
        this.removeDraftOfNote(page);
    }

    @Override
    public void removeDraftOfNote(Page page) throws WikiException {
        List<DraftPage> draftPages = this.dataStorage.getDraftsOfPage(Long.valueOf(page.getId()));
        for (DraftPage draftPage : draftPages) {
            if (draftPage == null) continue;
            try {
                this.deleteNoteMetadataProperties(draftPage, draftPage.getLang(), NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE);
            }
            catch (Exception e) {
                log.error((Object)"Error while deleting draft properties");
            }
        }
        this.dataStorage.deleteDraftOfPage(page);
    }

    @Override
    public DraftPage getDraftOfPageByLang(WikiPageParams param, String lang) throws WikiException {
        Page page = this.getNoteOfNoteBookByName(param.getType(), param.getOwner(), param.getPageName());
        return this.dataStorage.getDraftOfPageByLang(page, lang);
    }

    @Override
    public void removeDraftOfNote(WikiPageParams param, String lang) throws Exception {
        DraftPage draftPage = this.getDraftOfPageByLang(param, lang);
        if (draftPage != null) {
            this.removeDraftById(draftPage.getId());
        }
    }

    @Override
    public void removeDraft(String draftName) throws WikiException {
        this.dataStorage.deleteDraftByName(draftName);
    }

    @Override
    public void removeDraftById(String draftId) throws Exception {
        DraftPage draftNote = this.dataStorage.getDraftPageById(draftId);
        this.deleteNoteMetadataProperties(draftNote, draftNote.getLang(), NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE);
        this.dataStorage.deleteDraftById(draftId);
    }

    @Override
    public List<PageHistory> getVersionsHistoryOfNote(Page note) {
        return this.dataStorage.getHistoryOfPage(note);
    }

    @Override
    public void createVersionOfNote(Page note, String userName, boolean broadcast) throws WikiException {
        DraftPage draftPage = this.dataStorage.getLatestDraftPageByTargetPageAndLang(Long.valueOf(note.getId()), note.getLang());
        PageVersion previousPageVersion = this.getPublishedVersionByPageIdAndLang(Long.parseLong(note.getId()), note.getLang());
        PageVersion pageVersion = this.dataStorage.addPageVersion(note, userName);
        pageVersion.setAttachmentObjectType(note.getAttachmentObjectType());
        this.updateVersionContentImages(pageVersion);
        String pageVersionId = pageVersion.getId();
        note.setLatestVersionId(pageVersionId);
        if (note.getLang() != null) {
            try {
                NotePageProperties properties = note.getProperties();
                if (properties != null) {
                    properties.setNoteId(Long.parseLong(note.getId()));
                    properties.setDraft(false);
                    this.saveNoteMetadata(properties, note.getLang(), Long.valueOf(this.identityManager.getOrCreateUserIdentity(userName).getId()));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while saving note version language metadata", (Throwable)e);
            }
            if (broadcast) {
                String versionLangId = note.getId() + "-" + note.getLang();
                this.postUpdatePageVersionLanguage(versionLangId);
            }
        } else {
            pageVersion.setId(note.getId() + "-" + pageVersion.getName());
            this.copyNotePageProperties(note, pageVersion, note.getLang(), null, NOTE_METADATA_PAGE_OBJECT_TYPE, NOTE_METADATA_VERSION_PAGE_OBJECT_TYPE, userName);
        }
        this.broadcastPageVersionCreationEvent(pageVersionId, draftPage != null ? draftPage.getId() : null, previousPageVersion != null ? previousPageVersion.getId() : null);
        this.processPageContent(note, note.getLang());
    }

    @Override
    public void createVersionOfNote(Page note, String userName) throws WikiException {
        this.createVersionOfNote(note, userName, false);
    }

    @Override
    public void restoreVersionOfNote(String versionName, Page note, String userName) throws WikiException {
        PageVersion pageVersion = this.dataStorage.restoreVersionOfPage(versionName, note);
        pageVersion.setId(note.getId() + "-" + pageVersion.getName());
        this.copyNotePageProperties(pageVersion, note, null, null, NOTE_METADATA_VERSION_PAGE_OBJECT_TYPE, NOTE_METADATA_PAGE_OBJECT_TYPE, userName);
        this.createVersionOfNote(note, userName, true);
    }

    @Override
    public List<String> getPreviousNamesOfNote(Page note) throws WikiException {
        return this.dataStorage.getPreviousNamesOfPage(note);
    }

    @Override
    public List<Page> getNotesOfWiki(String noteType, String noteOwner) {
        return this.dataStorage.getPagesOfWiki(noteType, noteOwner);
    }

    @Override
    public boolean isExisting(String noteBookType, String noteBookOwner, String noteId) throws WikiException {
        return this.getNoteByRootPermission(noteBookType, noteBookOwner, noteId) != null;
    }

    @Override
    public DraftPage updateDraftForExistPage(DraftPage draftNoteToUpdate, Page targetPage, String revision, long clientTime, String username) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        Long userIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setId(draftNoteToUpdate.getId());
        newDraftPage.setName(targetPage.getName() + "_" + draftSuffix);
        newDraftPage.setNewPage(false);
        newDraftPage.setTitle(draftNoteToUpdate.getTitle());
        newDraftPage.setTargetPageId(draftNoteToUpdate.getTargetPageId());
        newDraftPage.setParentPageId(draftNoteToUpdate.getParentPageId());
        newDraftPage.setContent(this.processImagesOnDraftUpdate(draftNoteToUpdate, userIdentityId));
        newDraftPage.setLang(draftNoteToUpdate.getLang());
        newDraftPage.setSyntax(draftNoteToUpdate.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        if (StringUtils.isEmpty((CharSequence)revision)) {
            List<PageHistory> versions = this.getVersionsHistoryOfNote(targetPage);
            if (versions != null && !versions.isEmpty()) {
                newDraftPage.setTargetPageRevision(String.valueOf(versions.get(0).getVersionNumber()));
            } else {
                newDraftPage.setTargetPageRevision("1");
            }
        } else {
            newDraftPage.setTargetPageRevision(revision);
        }
        newDraftPage = this.dataStorage.updateDraftPageForUser(newDraftPage, username);
        NotePageProperties properties = draftNoteToUpdate.getProperties();
        try {
            if (properties != null) {
                NoteFeaturedImage featuredImage = properties.getFeaturedImage();
                if (featuredImage != null && featuredImage.getUploadId() != null && this.isOriginalFeaturedImage(draftNoteToUpdate, targetPage)) {
                    featuredImage.setId(0L);
                }
                properties = this.saveNoteMetadata(properties, newDraftPage.getLang(), Long.valueOf(this.identityManager.getOrCreateUserIdentity(username).getId()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save draft note metadata", (Throwable)e);
        }
        newDraftPage.setProperties(properties);
        return newDraftPage;
    }

    @Override
    public DraftPage updateDraftForNewPage(DraftPage draftNoteToUpdate, long clientTime, long userIdentityId) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setId(draftNoteToUpdate.getId());
        newDraftPage.setName(UNTITLED_PREFIX + draftSuffix);
        newDraftPage.setNewPage(true);
        newDraftPage.setTitle(draftNoteToUpdate.getTitle());
        newDraftPage.setTargetPageId(draftNoteToUpdate.getTargetPageId());
        newDraftPage.setParentPageId(draftNoteToUpdate.getParentPageId());
        newDraftPage.setTargetPageRevision("1");
        newDraftPage.setContent(this.processImagesOnDraftUpdate(draftNoteToUpdate, userIdentityId));
        newDraftPage.setLang(draftNoteToUpdate.getLang());
        newDraftPage.setSyntax(draftNoteToUpdate.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(userIdentityId);
        newDraftPage = this.dataStorage.updateDraftPageForUser(newDraftPage, userIdentity.getRemoteId());
        NotePageProperties properties = draftNoteToUpdate.getProperties();
        try {
            properties = this.saveNoteMetadata(properties, newDraftPage.getLang(), userIdentityId);
        }
        catch (Exception e) {
            log.error((Object)"Failed to save draft note metadata", (Throwable)e);
        }
        newDraftPage.setProperties(properties);
        return newDraftPage;
    }

    @Override
    public DraftPage createDraftForExistPage(DraftPage draftPage, Page targetPage, String revision, long clientTime, String username) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(targetPage.getName() + "_" + draftSuffix);
        newDraftPage.setNewPage(false);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setTargetPageId(targetPage.getId());
        newDraftPage.setParentPageId(draftPage.getParentPageId());
        newDraftPage.setLang(draftPage.getLang());
        newDraftPage.setSyntax(draftPage.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        if (StringUtils.isEmpty((CharSequence)revision)) {
            List<PageHistory> versions = this.getVersionsHistoryOfNote(targetPage);
            if (versions != null && !versions.isEmpty()) {
                newDraftPage.setTargetPageRevision(String.valueOf(versions.get(0).getVersionNumber()));
            } else {
                newDraftPage.setTargetPageRevision("1");
            }
        } else {
            newDraftPage.setTargetPageRevision(revision);
        }
        newDraftPage = this.dataStorage.createDraftPageForUser(newDraftPage, username);
        NotePageProperties properties = draftPage.getProperties();
        try {
            if (properties != null) {
                NoteFeaturedImage featuredImage = properties.getFeaturedImage();
                if (featuredImage != null && featuredImage.getUploadId() != null) {
                    featuredImage.setId(0L);
                }
                properties.setNoteId(Long.parseLong(newDraftPage.getId()));
                properties = this.saveNoteMetadata(properties, draftPage.getLang(), Long.valueOf(userIdentity.getId()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save draft note metadata", (Throwable)e);
        }
        newDraftPage.setProperties(properties);
        newDraftPage.setAttachmentObjectType(draftPage.getAttachmentObjectType());
        newDraftPage = this.processImagesOnDraftCreation(newDraftPage, Long.parseLong(userIdentity.getId()));
        PageVersion pageVersion = this.getPublishedVersionByPageIdAndLang(Long.valueOf(newDraftPage.getTargetPageId()), newDraftPage.getLang());
        if (pageVersion != null) {
            HashMap<String, String> eventData = new HashMap<String, String>();
            eventData.put(PAGE_VERSION_ID_PROP_NAME, pageVersion.getId());
            eventData.put("draftForExistingPageId", newDraftPage.getId());
            org.exoplatform.wiki.utils.Utils.broadcast(this.listenerService, "note.draft.for.exist.page.created", this, eventData);
        }
        return newDraftPage;
    }

    @Override
    public DraftPage createDraftForNewPage(DraftPage draftPage, long clientTime, long userIdentityId) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(UNTITLED_PREFIX + draftSuffix);
        newDraftPage.setNewPage(true);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setTargetPageId(draftPage.getTargetPageId());
        newDraftPage.setTargetPageRevision("1");
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setParentPageId(draftPage.getParentPageId());
        newDraftPage.setAuthor(draftPage.getAuthor());
        newDraftPage.setLang(draftPage.getLang());
        newDraftPage.setSyntax(draftPage.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(userIdentityId);
        newDraftPage = this.dataStorage.createDraftPageForUser(newDraftPage, identity.getRemoteId());
        NotePageProperties properties = draftPage.getProperties();
        try {
            if (properties != null) {
                properties.setNoteId(Long.parseLong(newDraftPage.getId()));
                properties = this.saveNoteMetadata(properties, draftPage.getLang(), userIdentityId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save draft note metadata", (Throwable)e);
        }
        newDraftPage.setProperties(properties);
        newDraftPage.setAttachmentObjectType(draftPage.getAttachmentObjectType());
        newDraftPage = this.processImagesOnDraftCreation(newDraftPage, userIdentityId);
        return newDraftPage;
    }

    @Override
    public boolean hasPermissionOnPage(Page page, PermissionType permissionType, String username) {
        if (StringUtils.equals((CharSequence)IdentityConstants.SYSTEM, (CharSequence)page.getOwner())) {
            return false;
        }
        return switch (permissionType) {
            case PermissionType.VIEWPAGE -> this.canViewNote(page, username);
            case PermissionType.EDITPAGE, PermissionType.ADMINPAGE -> this.canEditNote(page, username);
            default -> this.wikiService.canManageWiki(page.getWikiType(), page.getWikiOwner(), username);
        };
    }

    @Override
    public Page getNoteByRootPermission(String wikiType, String wikiOwner, String pageId) throws WikiException {
        return this.dataStorage.getPageOfWikiByName(wikiType, wikiOwner, pageId);
    }

    @Override
    public void importNotes(String zipLocation, Page parent, String conflict, Identity userIdentity) throws Exception {
        List<String> files = org.exoplatform.wiki.utils.Utils.unzip(zipLocation, System.getProperty(TEMP_DIRECTORY_PATH));
        this.importNotes(files, parent, conflict, userIdentity);
    }

    @Override
    public void importNotes(List<String> files, Page parent, String conflict, Identity userIdentity) throws Exception {
        HashMap<String, String> featuredImages = new HashMap<String, String>();
        String notesFilePath = "";
        for (String file : files) {
            if (file.contains("notesExport_")) {
                notesFilePath = file;
            }
            if (!file.contains("/featuredImages/")) continue;
            String fileName = file.substring(file.lastIndexOf("/") + 1);
            String imageId = fileName.substring(0, fileName.lastIndexOf("."));
            featuredImages.put(imageId, file);
        }
        if (!notesFilePath.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            File notesFile = new File(notesFilePath);
            ImportList notes = (ImportList)mapper.readValue(notesFile, (TypeReference)new TypeReference<ImportList>(this){});
            Wiki wiki = this.wikiService.getWikiByTypeAndOwner(parent.getWikiType(), parent.getWikiOwner());
            if (StringUtils.isNotEmpty((CharSequence)conflict) && conflict.equals("replaceAll")) {
                List<Page> notesTodelete = this.getAllNotes(parent);
                for (Page noteTodelete : notesTodelete) {
                    if ("Home".equals(noteTodelete.getName()) || noteTodelete.getId().equals(parent.getId())) continue;
                    try {
                        this.deleteNote(wiki.getType(), wiki.getOwner(), noteTodelete.getName(), userIdentity);
                    }
                    catch (Exception e) {
                        log.warn("Note {} connot be deleted for import", new Object[]{noteTodelete.getName(), e});
                    }
                }
            }
            for (Page note : notes.getNotes()) {
                this.importNote(note, parent, featuredImages, this.wikiService.getWikiByTypeAndOwner(parent.getWikiType(), parent.getWikiOwner()), conflict, userIdentity);
            }
            for (Page note : notes.getNotes()) {
                this.replaceIncludedPages(note, wiki, userIdentity);
            }
            this.cleanUp(notesFile);
        }
    }

    @Override
    public PageList<SearchResult> search(WikiSearchData data) throws WikiException {
        try {
            ObjectPageList result = this.dataStorage.search(data);
            if (data.getTitle() != null && data.getWikiType() != null && data.getWikiOwner() != null && result.getPageSize() > 0) {
                Page homePage = this.wikiService.getWikiByTypeAndOwner(data.getWikiType(), data.getWikiOwner()).getWikiHome();
                if (data.getTitle().equals("") || homePage != null && homePage.getTitle().contains(data.getTitle())) {
                    Calendar wikiHomeCreateDate = Calendar.getInstance();
                    wikiHomeCreateDate.setTime(homePage.getCreatedDate());
                    Calendar wikiHomeUpdateDate = Calendar.getInstance();
                    wikiHomeUpdateDate.setTime(homePage.getUpdatedDate());
                    SearchResult wikiHomeResult = new SearchResult(data.getWikiType(), data.getWikiOwner(), homePage.getName(), null, homePage.getTitle(), SearchResultType.PAGE, wikiHomeUpdateDate, wikiHomeCreateDate);
                    List tempSearchResult = result.getAll();
                    tempSearchResult.add(wikiHomeResult);
                    result = new ObjectPageList(tempSearchResult, result.getPageSize());
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)("Cannot search on wiki " + data.getWikiType() + ":" + data.getWikiOwner() + " - Cause : " + e.getMessage()), (Throwable)e);
            return new ObjectPageList(new ArrayList(), 0);
        }
    }

    @Override
    public Page getNoteByIdAndLang(Long pageId, Identity userIdentity, String source, String lang) throws WikiException, IllegalAccessException {
        Page page = this.getNoteById(String.valueOf(pageId), userIdentity, source);
        PageVersion publishedVersion = this.dataStorage.getPublishedVersionByPageIdAndLang(pageId, lang);
        if (page != null && publishedVersion != null) {
            page.setTitle(publishedVersion.getTitle());
            page.setContent(publishedVersion.getContent());
            page.setLang(publishedVersion.getLang());
            page.setProperties(publishedVersion.getProperties());
            page.setLatestVersionId(publishedVersion.getId());
            page.setLastUpdater(publishedVersion.getAuthor());
            if (lang != null) {
                page.setMetadatas(this.retrieveMetadataItems(pageId + "-" + lang, userIdentity.getUserId()));
            }
        }
        if (page != null && publishedVersion == null && lang != null) {
            publishedVersion = this.dataStorage.getPublishedVersionByPageIdAndLang(pageId, null);
            page.setLatestVersionId(publishedVersion == null ? null : publishedVersion.getId());
        }
        return page;
    }

    @Override
    public Page getNoteByIdAndLang(Long pageId, String lang) {
        Page page = this.getNoteById(String.valueOf(pageId));
        PageVersion publishedVersion = this.dataStorage.getPublishedVersionByPageIdAndLang(pageId, lang);
        if (page != null && publishedVersion != null) {
            page.setTitle(publishedVersion.getTitle());
            page.setContent(publishedVersion.getContent());
            page.setLang(publishedVersion.getLang());
            page.setProperties(publishedVersion.getProperties());
        }
        return page;
    }

    @Override
    public PageVersion getPublishedVersionByPageIdAndLang(Long pageId, String lang) {
        return this.dataStorage.getPublishedVersionByPageIdAndLang(pageId, lang);
    }

    @Override
    public List<String> getPageAvailableTranslationLanguages(Long pageId, boolean withDrafts) throws WikiException {
        HashSet<String> langs = new HashSet<String>(this.dataStorage.getPageAvailableTranslationLanguages(pageId));
        if (withDrafts) {
            List<DraftPage> drafts = this.dataStorage.getDraftsOfPage(pageId);
            drafts = drafts.stream().filter(jsonNodeData -> StringUtils.isNotBlank((CharSequence)jsonNodeData.getLang())).toList();
            langs.addAll(drafts.stream().map(Page::getLang).toList());
        }
        return langs.stream().toList();
    }

    @Override
    public List<String> getPageAvailableTranslationLanguages(Long pageId, String userId, boolean withDrafts) throws WikiException {
        return this.getPageAvailableTranslationLanguages(pageId, withDrafts);
    }

    @Override
    public List<PageHistory> getVersionsHistoryOfNoteByLang(Page note, String userName, String lang) throws WikiException {
        List<PageHistory> pageHistories = this.dataStorage.getPageHistoryVersionsByPageIdAndLang(Long.valueOf(note.getId()), lang);
        if (lang == null && pageHistories.isEmpty()) {
            PageVersion pageVersion = this.dataStorage.addPageVersion(note, userName);
            pageVersion.setId(note.getId() + "-" + pageVersion.getName());
            this.copyNotePageProperties(note, pageVersion, note.getLang(), null, NOTE_METADATA_PAGE_OBJECT_TYPE, NOTE_METADATA_VERSION_PAGE_OBJECT_TYPE, userName);
            pageHistories = this.dataStorage.getPageHistoryVersionsByPageIdAndLang(Long.valueOf(note.getId()), null);
        }
        return pageHistories;
    }

    @Override
    public DraftPage getLatestDraftPageByTargetPageAndLang(Long targetPageId, String lang) {
        return this.dataStorage.getLatestDraftPageByTargetPageAndLang(targetPageId, lang);
    }

    @Override
    public DraftPage getLatestDraftPageByUserAndTargetPageAndLang(Long targetPageId, String username, String lang) {
        return this.getLatestDraftPageByTargetPageAndLang(targetPageId, lang);
    }

    @Override
    public void deleteVersionsByNoteIdAndLang(Long noteId, String lang, boolean broadcast) throws Exception {
        Page note = this.getNoteById(String.valueOf(noteId));
        if (note != null) {
            this.deleteNoteMetadataProperties(note, lang, NOTE_METADATA_PAGE_OBJECT_TYPE);
        }
        this.dataStorage.deleteVersionsByNoteIdAndLang(noteId, lang);
        List<DraftPage> drafts = this.dataStorage.getDraftsOfPage(noteId);
        for (DraftPage draftPage : drafts) {
            if (!StringUtils.equals((CharSequence)draftPage.getLang(), (CharSequence)lang)) continue;
            this.removeDraftById(draftPage.getId());
        }
        this.processPageContent(String.valueOf(noteId), "", lang);
    }

    @Override
    public void deleteVersionsByNoteIdAndLang(Long noteId, String lang) throws Exception {
        this.deleteVersionsByNoteIdAndLang(noteId, lang, false);
    }

    @Override
    public void deleteVersionsByNoteIdAndLang(Long noteId, String userName, String lang) throws Exception {
        this.deleteVersionsByNoteIdAndLang(noteId, lang);
    }

    @Override
    public List<DraftPage> getDraftsOfWiki(String wikiOwner, String wikiType, String wikiHome) {
        return this.dataStorage.getDraftsOfWiki(wikiOwner, wikiType, wikiHome);
    }

    @Override
    public void removeOrphanDraftPagesByParentPage(long parentPageId) {
        this.dataStorage.deleteOrphanDraftPagesByParentPage(parentPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long saveNoteFeaturedImage(Page note, NoteFeaturedImage featuredImage) throws Exception {
        UploadResource uploadResource;
        if (featuredImage == null) {
            return null;
        }
        long featuredImageId = featuredImage.getId() != null ? featuredImage.getId() : 0L;
        String uploadId = featuredImage.getUploadId();
        if (uploadId != null && (uploadResource = this.uploadService.getUploadResource(uploadId)) != null) {
            String fileDiskLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                FileItem fileItem = new FileItem(Long.valueOf(featuredImageId), note.getName(), featuredImage.getMimeType(), FILE_NAME_SPACE, (long)((InputStream)inputStream).available(), new Date(), null, false, (InputStream)inputStream);
                fileItem = featuredImageId == 0L ? this.fileService.writeFile(fileItem) : this.fileService.updateFile(fileItem);
                if (fileItem != null && fileItem.getFileInfo() != null) {
                    Long l = fileItem.getFileInfo().getId();
                    return l;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while saving note featured image", (Throwable)e);
            }
            finally {
                this.uploadService.removeUploadResource(uploadId);
            }
        }
        return featuredImageId;
    }

    @Override
    public NoteFeaturedImage getNoteFeaturedImageInfo(Long noteId, String lang, boolean isDraft, String thumbnailSize, long userIdentityId) throws Exception {
        if (noteId == null) {
            throw new IllegalArgumentException("note id is mandatory");
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(userIdentityId);
        Page note = isDraft ? this.getDraftNoteById(String.valueOf(noteId), identity.getRemoteId()) : this.getNoteByIdAndLang(noteId, lang);
        if (note == null) {
            throw new ObjectNotFoundException("Note with id: " + noteId + " and lang: " + lang + " not found");
        }
        MetadataItem metadataItem = this.getNoteMetadataItem(note, lang, isDraft ? NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE : NOTE_METADATA_PAGE_OBJECT_TYPE);
        if (metadataItem != null && !MapUtils.isEmpty((Map)metadataItem.getProperties())) {
            String featuredImageIdProp = (String)metadataItem.getProperties().get(FEATURED_IMAGE_ID);
            String featuredImageAltText = (String)metadataItem.getProperties().get(FEATURED_IMAGE_ALT_TEXT);
            long noteFeaturedImageId = featuredImageIdProp != null && !featuredImageIdProp.equals("null") ? Long.parseLong(featuredImageIdProp) : 0L;
            FileItem fileItem = this.fileService.getFile(noteFeaturedImageId);
            if (fileItem != null && fileItem.getFileInfo() != null) {
                FileInfo fileInfo = fileItem.getFileInfo();
                if (thumbnailSize != null) {
                    int[] dimension = Utils.parseDimension((String)thumbnailSize);
                    fileItem = this.imageThumbnailService.getOrCreateThumbnail(fileItem, dimension[0], dimension[1]);
                }
                return new NoteFeaturedImage(fileInfo.getId(), fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getSize(), fileInfo.getUpdatedDate().getTime(), fileItem.getAsStream(), featuredImageAltText);
            }
        }
        return null;
    }

    @Override
    public void removeNoteFeaturedImage(Long noteId, Long featuredImageId, String lang, boolean isDraft, Long userIdentityId) throws Exception {
        MetadataItem metadataItem;
        Page note;
        boolean removeFeaturedImageFile = true;
        if (isDraft) {
            DraftPage draftPage = this.getDraftNoteById(String.valueOf(noteId), this.identityManager.getIdentity(userIdentityId.longValue()).getRemoteId());
            if (draftPage != null && (draftPage.getTargetPageId() == null || this.isOriginalFeaturedImage(draftPage, this.getNoteByIdAndLang(Long.valueOf(draftPage.getTargetPageId()), lang)))) {
                removeFeaturedImageFile = false;
            }
            note = draftPage;
        } else {
            note = this.getNoteByIdAndLang(noteId, lang);
        }
        if (note == null) {
            throw new ObjectNotFoundException("note not found");
        }
        if (removeFeaturedImageFile && featuredImageId != null && featuredImageId > 0L) {
            this.fileService.deleteFile(featuredImageId.longValue());
        }
        if ((metadataItem = this.getNoteMetadataItem(note, lang, isDraft ? NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE : NOTE_METADATA_PAGE_OBJECT_TYPE)) != null) {
            Map properties = metadataItem.getProperties();
            properties.remove(FEATURED_IMAGE_ID);
            properties.remove(FEATURED_IMAGE_UPDATED_DATE);
            properties.remove(FEATURED_IMAGE_ALT_TEXT);
            metadataItem.setProperties(properties);
            this.metadataService.updateMetadataItem(metadataItem, userIdentityId.longValue(), false);
        }
    }

    @Override
    public NotePageProperties saveNoteMetadata(NotePageProperties notePageProperties, String lang, Long userIdentityId) throws Exception {
        if (notePageProperties == null) {
            return null;
        }
        Long featuredImageId = null;
        NoteFeaturedImage featuredImage = notePageProperties.getFeaturedImage();
        Page note = notePageProperties.isDraft() ? this.getDraftNoteById(String.valueOf(notePageProperties.getNoteId()), this.identityManager.getIdentity(userIdentityId.longValue()).getRemoteId()) : this.getNoteByIdAndLang(notePageProperties.getNoteId(), lang);
        if (note == null) {
            throw new ObjectNotFoundException("note not found");
        }
        if (featuredImage != null && featuredImage.isToDelete()) {
            this.removeNoteFeaturedImage(Long.valueOf(note.getId()), featuredImage.getId(), lang, notePageProperties.isDraft(), userIdentityId);
        } else {
            featuredImageId = this.saveNoteFeaturedImage(note, featuredImage);
        }
        NoteMetadataObject noteMetadataObject = this.buildNoteMetadataObject(note, lang, notePageProperties.isDraft() ? NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE : NOTE_METADATA_PAGE_OBJECT_TYPE);
        MetadataItem metadataItem = this.getNoteMetadataItem(note, lang, notePageProperties.isDraft() ? NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE : NOTE_METADATA_PAGE_OBJECT_TYPE);
        Map<String, String> properties = new HashMap<String, String>();
        if (metadataItem != null && metadataItem.getProperties() != null) {
            properties = metadataItem.getProperties();
        }
        properties.put(SUMMARY_PROP, notePageProperties.getSummary() != null ? notePageProperties.getSummary() : "");
        properties.put(HIDE_AUTHOR_PROP, String.valueOf(notePageProperties.isHideAuthor()));
        properties.put(HIDE_REACTION_PROP, String.valueOf(notePageProperties.isHideReaction()));
        if (featuredImageId != null) {
            properties.put(FEATURED_IMAGE_ID, String.valueOf(featuredImageId));
            properties.put(FEATURED_IMAGE_UPDATED_DATE, String.valueOf(new Date().getTime()));
            properties.put(FEATURED_IMAGE_ALT_TEXT, notePageProperties.getFeaturedImage().getAltText());
        }
        if (metadataItem == null) {
            this.metadataService.createMetadataItem((MetadataObject)noteMetadataObject, NOTES_METADATA_KEY, properties, userIdentityId.longValue(), false);
        } else {
            metadataItem.setProperties(properties);
            this.metadataService.updateMetadataItem(metadataItem, userIdentityId.longValue(), false);
        }
        if (featuredImage != null) {
            featuredImage.setId(featuredImageId);
            featuredImage.setLastUpdated(Long.valueOf(properties.getOrDefault(FEATURED_IMAGE_UPDATED_DATE, "0")));
            featuredImage.setUploadId(null);
            notePageProperties.setFeaturedImage(featuredImage);
        }
        return notePageProperties;
    }

    @Override
    public PageVersion getPageVersionById(Long versionId) {
        if (versionId == null) {
            throw new IllegalArgumentException("version id is mandatory");
        }
        return this.dataStorage.getPageVersionById(versionId);
    }

    public void postUpdatePageVersionLanguage(String versionPageId) {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            l.postUpdatePageVersion(versionPageId);
        }
    }

    public void postDeletePageVersionLanguage(PageVersion pageVersion) {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            l.postDeletePageVersion(pageVersion);
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postUpdatePage(wikiType, wikiOwner, pageId, page, wikiUpdateType);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postAddPage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postDeletePage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromTree(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromBreadCrumb(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    @Override
    public void markNoteAsViewed(Page note, Identity userIdentity) {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.markNoteAsViewed(note, userIdentity.getUserId());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, note.getName()}), (Throwable)e);
            }
        }
    }

    private void deleteNoteMetadataProperties(Page note, String lang, String objectType) throws Exception {
        MetadataItem draftNoteMetadataItem = this.getNoteMetadataItem(note, lang, objectType);
        if (draftNoteMetadataItem != null) {
            Map properties = draftNoteMetadataItem.getProperties();
            if (properties != null && properties.getOrDefault(FEATURED_IMAGE_ID, null) != null) {
                String featuredImageId = (String)properties.get(FEATURED_IMAGE_ID);
                if (note.isDraftPage() && ((DraftPage)note).getTargetPageId() != null) {
                    this.removeNoteFeaturedImage(Long.parseLong(note.getId()), Long.parseLong(featuredImageId), lang, true, Long.parseLong(this.identityManager.getOrCreateUserIdentity(note.getOwner()).getId()));
                } else if (note.isDraftPage()) {
                    List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(NOTES_METADATA_TYPE.getName(), NOTES_METADATA_TYPE.getName(), NOTE_METADATA_PAGE_OBJECT_TYPE, FEATURED_IMAGE_ID, featuredImageId, 0L, 0L);
                    if (metadataItems == null || metadataItems.isEmpty()) {
                        this.fileService.deleteFile(Long.parseLong(featuredImageId));
                    }
                } else {
                    this.fileService.deleteFile(Long.parseLong(featuredImageId));
                }
            }
            this.metadataService.deleteMetadataItem(draftNoteMetadataItem.getId(), false);
        }
    }

    private void importNote(Page note, Page parent, Map<String, String> featuredImages, Wiki wiki, String conflict, Identity userIdentity) throws Exception {
        Page targetNote = null;
        File featuredImageFile = this.extractNoteFeaturedImageFileToImport(note, featuredImages);
        Page parent_ = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), parent.getName());
        if (parent_ == null) {
            parent_ = wiki.getWikiHome();
        }
        Page note_ = note;
        if (!"Home".equals(note.getName())) {
            note.setId(null);
            Page note_2 = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
            if (note_2 == null) {
                targetNote = note_ = this.createNote(wiki, parent_.getName(), note, userIdentity, false, true);
            } else if (StringUtils.isNotEmpty((CharSequence)conflict)) {
                if (conflict.equals("overwrite") || conflict.equals("replaceAll")) {
                    this.deleteNote(wiki.getType(), wiki.getOwner(), note.getName());
                    targetNote = note_ = this.createNote(wiki, parent_.getName(), note, userIdentity, false, true);
                }
                if (conflict.equals("duplicate")) {
                    targetNote = note_ = this.createNote(wiki, parent_.getName(), note, userIdentity, true, true);
                }
                if (!(!conflict.equals("update") || note_2.getTitle().equals(note.getTitle()) && note_2.getContent().equals(note.getContent()) && Objects.equals(note_2.getProperties(), note.getProperties()))) {
                    note_2.setTitle(note.getTitle());
                    note_2 = this.updateNote(note_2, PageUpdateType.EDIT_PAGE_CONTENT, userIdentity);
                    this.createVersionOfNote(note_2, userIdentity.getUserId(), true);
                    targetNote = note_2;
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)conflict) && (conflict.equals("update") || conflict.equals("overwrite") || conflict.equals("replaceAll"))) {
            Page note_1 = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
            if (!note.getContent().equals(note_1.getContent()) || !Objects.equals(note_1.getProperties(), note.getProperties())) {
                note_1.setContent(note.getContent());
                note_1 = this.updateNote(note_1, PageUpdateType.EDIT_PAGE_CONTENT, userIdentity);
                this.createVersionOfNote(note_1, userIdentity.getUserId(), true);
                targetNote = note_1;
            }
        }
        if (featuredImageFile != null) {
            this.saveImportedFeaturedImage(featuredImageFile, targetNote, Long.parseLong(this.identityManager.getOrCreateUserIdentity(userIdentity.getUserId()).getId()));
        }
        if (note.getChildren() != null) {
            for (Page child : note.getChildren()) {
                this.importNote(child, note_, featuredImages, wiki, conflict, userIdentity);
            }
        }
    }

    private List<Page> getAllNotes(Page note) throws WikiException {
        ArrayList<Page> listOfNotes = new ArrayList<Page>();
        this.addAllNodes(note, listOfNotes);
        return listOfNotes;
    }

    private void cleanUp(File file) throws IOException {
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            Files.delete(file.toPath());
        }
    }

    private void computeDraftProps(DraftPage draftPage, String username) throws WikiException, IllegalAccessException {
        if (draftPage == null) {
            return;
        }
        if (!this.canViewNote(draftPage, username)) {
            throw new IllegalAccessException("User does not have the right view the note.");
        }
        draftPage.setCanView(true);
        boolean canManageNotes = this.wikiService.canManageWiki(draftPage.getWikiType(), draftPage.getWikiOwner(), username);
        draftPage.setCanManage(canManageNotes || this.canEditNote(draftPage, username));
        draftPage.setCanImport(canManageNotes);
        String authorFullName = this.identityManager.getOrCreateIdentity("organization", draftPage.getAuthor()).getProfile().getFullName();
        draftPage.setAuthorFullName(authorFullName);
    }

    private void checkToRemoveDomainInUrl(Page note) {
        block4: {
            if (note == null) {
                return;
            }
            String url = note.getUrl();
            if (url != null && url.contains("://")) {
                try {
                    URL oldURL = new URL(url);
                    note.setUrl(oldURL.getPath());
                }
                catch (MalformedURLException ex) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Malformed url " + url), (Throwable)ex);
                }
            }
        }
    }

    private List<BreadcrumbData> getBreadCrumb(List<BreadcrumbData> list, String noteType, String noteOwner, String noteName, String lang, Identity userIdentity, boolean isDraftNote) throws WikiException, IllegalAccessException {
        Page parentNote;
        Page note;
        if (list == null) {
            list = new ArrayList<BreadcrumbData>(5);
        }
        if (noteName == null) {
            return list;
        }
        Page page = note = isDraftNote ? this.dataStorage.getDraftPageById(noteName) : this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (note == null) {
            return list;
        }
        list.add(0, new BreadcrumbData(note.getName(), note.getId(), this.getNoteTitleWithTraduction(note, userIdentity, "", lang), noteType, noteOwner));
        Page page2 = parentNote = isDraftNote ? this.getNoteById(note.getParentPageId()) : this.getParentNoteOf(note);
        if (parentNote != null) {
            this.getBreadCrumb(list, noteType, noteOwner, parentNote.getName(), lang, userIdentity, false);
        }
        return list;
    }

    private String getNoteTitleWithTraduction(Page note, Identity userIdentity, String source, String lang) throws WikiException, IllegalAccessException {
        if (userIdentity == null || StringUtils.isEmpty((CharSequence)lang)) {
            return note.getTitle();
        }
        Page page = this.getNoteByIdAndLang(Long.valueOf(note.getId()), userIdentity, source, lang);
        if (page != null) {
            return page.getTitle();
        }
        return note.getTitle();
    }

    private String getDraftNameSuffix(long clientTime) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
    }

    private void replaceIncludedPages(Page note, Wiki wiki, Identity userIdentity) throws WikiException {
        String content;
        Page note_ = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
        if (note_ != null && (content = note_.getContent()).contains("class=\"noteLink\" href=\"//-")) {
            while (content.contains("class=\"noteLink\" href=\"//-")) {
                String linkedParams = content.split("class=\"noteLink\" href=\"//-")[1].split("-//\"")[0];
                String NoteName = linkedParams.split("-////-")[2];
                Page linkedNote = null;
                linkedNote = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), NoteName);
                content = linkedNote != null ? content.replace("\"noteLink\" href=\"//-" + linkedParams + IMAGE_URL_REPLACEMENT_SUFFIX, "\"noteLink\" href=\"" + linkedNote.getUrl()) : content.replace("\"noteLink\" href=\"//-" + linkedParams + IMAGE_URL_REPLACEMENT_SUFFIX, "\"noteLink\" href=\"" + NoteName);
                if (!content.equals(note_.getContent())) continue;
                break;
            }
            if (!content.equals(note_.getContent())) {
                note_.setContent(content);
                this.updateNote(note_);
                this.createVersionOfNote(note_, userIdentity.getUserId(), true);
            }
        }
        if (note.getChildren() != null) {
            for (Page child : note.getChildren()) {
                this.replaceIncludedPages(child, wiki, userIdentity);
            }
        }
    }

    private void addAllNodes(Page note, List<Page> listOfNotes) throws WikiException {
        if (note != null) {
            listOfNotes.add(note);
            List<Page> children = this.getChildrenNoteOf(note, true, false);
            if (children != null) {
                for (Page child : children) {
                    this.addAllNodes(child, listOfNotes);
                }
            }
        }
    }

    private Map<String, List<MetadataItem>> retrieveMetadataItems(String noteId, String username) {
        org.exoplatform.social.core.identity.model.Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", username);
        long currentUserId = Long.parseLong(currentIdentity.getId());
        MetadataObject metadataObject = new MetadataObject("notes", noteId);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        HashMap<String, List<MetadataItem>> metadata = new HashMap<String, List<MetadataItem>>();
        metadataItems.stream().filter(metadataItem -> metadataItem.getMetadata().getAudienceId() == 0L || metadataItem.getMetadata().getAudienceId() == currentUserId).forEach(metadataItem -> {
            String type = metadataItem.getMetadata().getType().getName();
            metadata.computeIfAbsent(type, k -> new ArrayList());
            ((List)metadata.get(type)).add(metadataItem);
        });
        return metadata;
    }

    private NoteMetadataObject buildNoteMetadataObject(Page note, String lang, String objectType) {
        Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
        long spaceId = space != null ? Long.parseLong(space.getId()) : 0L;
        String noteId = String.valueOf(note.getId());
        noteId = lang != null ? noteId + "-" + lang : noteId;
        return new NoteMetadataObject(objectType, noteId, note.getParentPageId(), spaceId);
    }

    private MetadataItem getNoteMetadataItem(Page note, String lang, String objectType) {
        NoteMetadataObject noteMetadataObject = this.buildNoteMetadataObject(note, lang, objectType);
        return this.metadataService.getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)noteMetadataObject).stream().findFirst().orElse(null);
    }

    private Page saveNote(Page note, PageUpdateType type, Identity userIdentity, boolean broadcast) {
        String updater;
        Page existingNote = this.getNoteById(note.getId());
        note.setContent(this.updateNoteContentImages(note, userIdentity));
        Page updatedPage = this.dataStorage.updatePage(note);
        NotePageProperties properties = note.getProperties();
        String string = updater = userIdentity == null ? null : userIdentity.getUserId();
        if (properties != null && updater != null) {
            try {
                properties.setNoteId(Long.parseLong(updatedPage.getId()));
                properties.setDraft(false);
                properties = this.saveNoteMetadata(properties, note.getLang(), Long.valueOf(this.identityManager.getOrCreateUserIdentity(updater).getId()));
                updatedPage.setProperties(properties);
            }
            catch (Exception e) {
                log.error((Object)"Error while updating note metadata properties", (Throwable)e);
            }
        }
        updatedPage.setUrl(org.exoplatform.wiki.utils.Utils.getPageUrl(updatedPage));
        updatedPage.setToBePublished(note.isToBePublished());
        updatedPage.setCanManage(note.isCanManage());
        updatedPage.setCanImport(note.isCanImport());
        updatedPage.setCanView(note.isCanView());
        updatedPage.setAppName(note.getAppName());
        if (userIdentity != null) {
            Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(note.getId(), updater);
            updatedPage.setMetadatas(metadata);
            note.setAuthor(updater);
            updatedPage.setLastUpdater(updater);
        }
        org.exoplatform.wiki.utils.Utils.broadcast(this.listenerService, "note.updated", note.getAuthor(), updatedPage);
        this.processPageContent(updatedPage, note.getLang());
        if (broadcast) {
            this.postUpdatePage(updatedPage.getWikiType(), updatedPage.getWikiOwner(), updatedPage.getName(), new Page(updatedPage), type);
            Matcher mentionsMatcher = org.exoplatform.wiki.utils.Utils.MENTION_PATTERN.matcher(note.getContent());
            if (mentionsMatcher.find()) {
                org.exoplatform.wiki.utils.Utils.sendMentionInNoteNotification(note, existingNote, updater == null ? existingNote.getAuthor() : updater);
            }
        }
        updatedPage.setLang(note.getLang());
        return updatedPage;
    }

    private void copyNotePageProperties(Page oldNote, Page note, String oldLang, String lang, String oldObjectType, String newObjectType, String username) {
        if (note == null || oldNote == null) {
            return;
        }
        if (username != null) {
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", username);
            NoteMetadataObject newNoteMetadataObject = this.buildNoteMetadataObject(note, lang, newObjectType);
            MetadataItem oldNoteMetadataItem = this.getNoteMetadataItem(oldNote, oldLang, oldObjectType);
            MetadataItem newNoteMetadataItem = this.getNoteMetadataItem(note, lang, newObjectType);
            if (oldNoteMetadataItem != null && oldNoteMetadataItem.getProperties() != null) {
                if (newNoteMetadataItem != null) {
                    newNoteMetadataItem.setProperties(oldNoteMetadataItem.getProperties());
                    this.metadataService.updateMetadataItem(newNoteMetadataItem, Long.parseLong(identity.getId()), false);
                } else {
                    try {
                        this.metadataService.createMetadataItem((MetadataObject)newNoteMetadataObject, NOTES_METADATA_KEY, oldNoteMetadataItem.getProperties(), Long.parseLong(identity.getId()), false);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while creating note metadata item", (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean isOriginalFeaturedImage(Page draftPage, Page targetPage) {
        if (draftPage == null || targetPage == null) {
            return false;
        }
        if (draftPage.getProperties() == null || targetPage.getProperties() == null) {
            return false;
        }
        NoteFeaturedImage draftFeaturedImage = draftPage.getProperties().getFeaturedImage();
        NoteFeaturedImage targetFeaturedImage = targetPage.getProperties().getFeaturedImage();
        return draftFeaturedImage != null && targetFeaturedImage != null && targetFeaturedImage.getId().equals(draftFeaturedImage.getId());
    }

    private File extractNoteFeaturedImageFileToImport(Page note, Map<String, String> featuredImages) {
        NoteFeaturedImage featuredImage;
        String path;
        File featuredImageFile = null;
        NotePageProperties properties = note.getProperties();
        if (properties != null && properties.getFeaturedImage() != null && (path = (String)featuredImages.getOrDefault(String.valueOf((featuredImage = properties.getFeaturedImage()).getId()), null)) != null) {
            featuredImageFile = new File(path);
        }
        return featuredImageFile;
    }

    private void saveImportedFeaturedImage(File featuredImage, Page note, long userIdentityId) {
        try (FileInputStream inputStream = new FileInputStream(featuredImage);){
            String mimeType = Files.probeContentType(featuredImage.toPath());
            FileItem fileItem = new FileItem(Long.valueOf(0L), note.getName(), mimeType, FILE_NAME_SPACE, featuredImage.length(), new Date(), null, false, (InputStream)inputStream);
            fileItem = this.fileService.writeFile(fileItem);
            NoteMetadataObject noteMetadataObject = this.buildNoteMetadataObject(note, note.getLang(), NOTE_METADATA_PAGE_OBJECT_TYPE);
            MetadataItem metadataItem = this.getNoteMetadataItem(note, note.getLang(), NOTE_METADATA_PAGE_OBJECT_TYPE);
            Map<String, String> properties = new HashMap();
            if (metadataItem != null && metadataItem.getProperties() != null) {
                properties = metadataItem.getProperties();
            }
            if (fileItem != null && fileItem.getFileInfo() != null) {
                FileInfo fileInfo = fileItem.getFileInfo();
                properties.put(FEATURED_IMAGE_ID, String.valueOf(fileInfo.getId()));
                properties.put(FEATURED_IMAGE_UPDATED_DATE, String.valueOf(new Date().getTime()));
                properties.put(FEATURED_IMAGE_ALT_TEXT, note.getProperties().getFeaturedImage().getAltText());
            }
            if (metadataItem == null) {
                this.metadataService.createMetadataItem((MetadataObject)noteMetadataObject, NOTES_METADATA_KEY, properties, userIdentityId);
            } else {
                metadataItem.setProperties(properties);
                this.metadataService.updateMetadataItem(metadataItem, userIdentityId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while saving imported featured image");
        }
    }

    private DraftPage processImagesOnDraftCreation(DraftPage draftPage, long userIdentityId) throws WikiException {
        String newDraftContent = this.saveUploadedContentImages(draftPage.getContent(), draftPage.getAttachmentObjectType(), StringUtils.isNotEmpty((CharSequence)draftPage.getTargetPageId()) ? draftPage.getTargetPageId() : draftPage.getId(), userIdentityId);
        if (!newDraftContent.equals(draftPage.getContent())) {
            draftPage.setContent(newDraftContent);
            return this.updateDraftPageContent(Long.parseLong(draftPage.getId()), draftPage.getContent());
        }
        return draftPage;
    }

    private String processImagesOnDraftUpdate(DraftPage draftPage, long userIdentityId) {
        try {
            return this.saveUploadedContentImages(draftPage.getContent(), draftPage.getAttachmentObjectType(), StringUtils.isNotEmpty((CharSequence)draftPage.getTargetPageId()) ? draftPage.getTargetPageId() : draftPage.getId(), userIdentityId);
        }
        catch (Exception exception) {
            return draftPage.getContent();
        }
    }

    private Page processImagesOnNoteCreation(Page note, String draftId, long userIdentityId) throws WikiException {
        String newContent = note.getContent();
        if (StringUtils.isNotEmpty((CharSequence)draftId) && !draftId.equals("null")) {
            String sourceObjectType = "wikiDraft";
            this.attachmentService.moveAttachments(sourceObjectType, draftId, note.getAttachmentObjectType(), note.getId(), null, userIdentityId);
            newContent = note.getContent().replaceAll("/attachments/" + sourceObjectType + "/" + draftId, "/attachments/" + note.getAttachmentObjectType() + "/" + note.getId());
        }
        if (IMAGES_IMPORT_PATTERN.matcher(newContent).find()) {
            newContent = this.processImportedNoteImages(note, userIdentityId);
        }
        if (!newContent.equals(note.getContent())) {
            return this.updateNoteContent(note, newContent);
        }
        return note;
    }

    private String saveUploadedContentImages(String content, String objectType, String objectId, long userId) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return content;
        }
        try {
            String regex = "<img[^>]*cke_upload_id=\"([^\"]+)\"[^>]*(src=\"[^/][^>^\"]+\")?[^>]*>";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String imgElement = matcher.group(0);
                String uploadId = matcher.group(1);
                String imgSrc = matcher.group(2);
                UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
                if (uploadResource == null) continue;
                UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
                this.attachmentService.saveAttachment(uploadedAttachmentDetail, objectType, objectId, null, userId);
                String fileId = uploadedAttachmentDetail.getId();
                String newSrc = String.format("src=\"/portal/rest/v1/social/attachments/%s/%s/%s\"", objectType, objectId, fileId);
                String archivedUploadId = String.format("archived_cke_uploadId=\"%s\"", uploadId);
                String newImgTag = imgElement.replaceAll("cke_upload_id=\"[^\"]*\"", String.format("%s %s", archivedUploadId, newSrc));
                if (StringUtils.isNotBlank((CharSequence)imgSrc)) {
                    newImgTag = newImgTag.replace(imgSrc, "");
                }
                content = content.replace(imgElement, newImgTag);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while saving uploaded content images");
            return content;
        }
        return content;
    }

    private String updateNoteContentImages(Page note, Identity userIdentity) {
        String processedContent = note.getContent();
        if (userIdentity != null && note.getContent().contains("cke_upload_id=")) {
            processedContent = this.saveUploadedContentImages(note.getContent(), note.getAttachmentObjectType(), note.getId(), Long.parseLong(this.identityManager.getOrCreateUserIdentity(userIdentity.getUserId()).getId()));
        }
        if (userIdentity != null && IMAGES_IMPORT_PATTERN.matcher(processedContent).find()) {
            processedContent = this.processImportedNoteImages(note, Long.parseLong(this.identityManager.getOrCreateUserIdentity(userIdentity.getUserId()).getId()));
        }
        return processedContent;
    }

    private void updateVersionContentImages(PageVersion pageVersion) throws WikiException {
        List<String> fileIds = org.exoplatform.wiki.utils.Utils.getContentImagesIds(pageVersion.getContent(), pageVersion.getAttachmentObjectType(), pageVersion.getParentPageId());
        List existingFiles = this.attachmentService.getAttachmentFileIds(pageVersion.getAttachmentObjectType(), pageVersion.getParentPageId());
        List<String> removedFiles = existingFiles.stream().filter(item -> !fileIds.contains(item)).toList();
        List<String> versionsOfNoteContentList = this.dataStorage.getVersionsOfPage(pageVersion.getParent()).stream().map(Page::getContent).toList();
        removedFiles.stream().filter(fileId -> versionsOfNoteContentList.stream().noneMatch(content -> content.contains(pageVersion.getAttachmentObjectType().concat("/".concat(pageVersion.getParentPageId().concat("/".concat((String)fileId))))))).forEach(fileId -> this.attachmentService.deleteAttachment(pageVersion.getAttachmentObjectType(), pageVersion.getParentPageId(), fileId));
    }

    private DraftPage updateDraftPageContent(long draftId, String content) throws WikiException {
        return this.dataStorage.updateDraftContent(draftId, content);
    }

    private Page updateNoteContent(Page note, String content) throws WikiException {
        return this.dataStorage.updatePageContent(note, content);
    }

    private String processImportedNoteImages(Page note, long userIdentityId) {
        String processedContent = note.getContent();
        Matcher matcher = IMAGES_IMPORT_PATTERN.matcher(processedContent);
        while (matcher.find()) {
            String fileName = processedContent.split("src=\"//-")[1].split(IMAGE_URL_REPLACEMENT_SUFFIX)[0];
            File file = new File(System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + fileName);
            try (FileInputStream inputStream = new FileInputStream(file);){
                String mimeType = Files.probeContentType(file.toPath());
                FileItem fileItem = new FileItem(Long.valueOf(0L), fileName, mimeType, "attachment", (long)((InputStream)inputStream).available(), new Date(), null, false, (InputStream)inputStream);
                if ((fileItem = this.fileService.writeFile(fileItem)).getFileInfo().getId() == null) continue;
                this.attachmentService.createAttachment(String.valueOf(fileItem.getFileInfo().getId()), note.getAttachmentObjectType(), note.getId(), null, userIdentityId, new HashMap());
                String urlToReplace = IMAGE_URL_REPLACEMENT_PREFIX + fileName + IMAGE_URL_REPLACEMENT_SUFFIX;
                String newImageUrl = "/portal/rest/v1/social/attachments/" + note.getAttachmentObjectType() + "/" + note.getId() + "/" + fileItem.getFileInfo().getId();
                processedContent = processedContent.replace(urlToReplace, newImageUrl);
            }
            catch (Exception exception) {
                log.error((Object)"Error while processing note images");
            }
        }
        return processedContent;
    }

    private void broadcastPageVersionCreationEvent(String pageVersionId, String draftPageId, String previousPageVersionId) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        if (draftPageId != null) {
            eventData.put(DRAFT_PAGE_ID_PROP_NAME, draftPageId);
        } else if (previousPageVersionId != null) {
            eventData.put("previousPageVersionId", previousPageVersionId);
        }
        if (!eventData.isEmpty()) {
            eventData.put(PAGE_VERSION_ID_PROP_NAME, pageVersionId);
            org.exoplatform.wiki.utils.Utils.broadcast(this.listenerService, "note.page.version.created", this, eventData);
        }
    }

    private void processPageContent(Page page, String lang) {
        if (page != null) {
            String content = page.getContent();
            String id = page.getId();
            this.processPageContent(id, content, lang);
        }
    }

    private void processPageContent(String id, String content, String lang) {
        HtmlUtils.process((String)content, (HtmlProcessorContext)new HtmlProcessorContext("notes", id, null, this.getLocale(lang)));
    }

    private Space getSpaceByWiki(String wikiType, String wikiOwner) {
        if (StringUtils.isBlank((CharSequence)wikiType) || StringUtils.equalsIgnoreCase((CharSequence)WikiType.GROUP.name(), (CharSequence)wikiType)) {
            return this.spaceService.getSpaceByGroupId(wikiOwner);
        }
        return null;
    }

    private Locale getLocale(String lang) {
        return StringUtils.isBlank((CharSequence)lang) ? this.getDefaultLocale() : LocaleUtils.toLocale((String)lang);
    }

    private Locale getDefaultLocale() {
        return this.localeConfigService.getDefaultLocaleConfig().getLocale();
    }
}

