/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.binding;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingOperationReport;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportUser;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.GroupNodeEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingOperationReportEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;

@Path(value="v1/social/spaceGroupBindings")
@Tag(name="v1/social/groupSpaceBindings", description="API  to manage the binding between a space and an organization group")
public class GroupSpaceBindingRest
implements ResourceContainer {
    private GroupSpaceBindingService groupSpaceBindingService;
    private SpaceService spaceService;
    private SimpleDateFormat formater = new SimpleDateFormat("yy-MM-dd_HH-mm-ss");
    private static final Log LOG = ExoLogger.getLogger(GroupSpaceBindingRest.class);

    public GroupSpaceBindingRest(SpaceService spaceService, GroupSpaceBindingService groupSpaceBindingService) {
        this.groupSpaceBindingService = groupSpaceBindingService;
        this.spaceService = spaceService;
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Path(value="{spaceId}")
    @Operation(summary="Gets list of binding for a space.", method="GET", description="Returns a list of bindings in the following cases if the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getBindingsBySpaceId(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="spaceId") String spaceId, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="10") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of spaces found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        List<Long> removedSpaceBindingsIds = this.groupSpaceBindingService.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_REMOVE).stream().map(groupSpaceBinding -> groupSpaceBinding.getId()).toList();
        List spaceBindings = this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(spaceId);
        if (removedSpaceBindingsIds.size() > 0 && spaceBindings.size() > 0) {
            spaceBindings.removeIf(spaceBinding -> removedSpaceBindingsIds.contains(spaceBinding.getId()));
        }
        if (spaceBindings.size() == 0) {
            return EntityBuilder.getResponse(new CollectionEntity(new ArrayList(), "groupSpaceBindings", offset, limit), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        ArrayList<DataEntity> bindingEntities = new ArrayList<DataEntity>();
        for (GroupSpaceBinding binding : spaceBindings) {
            GroupSpaceBindingEntity bindingEntity = EntityBuilder.buildEntityFromGroupSpaceBinding(binding);
            bindingEntities.add(bindingEntity.getDataEntity());
        }
        CollectionEntity collectionBinding = new CollectionEntity(bindingEntities, "groupSpaceBindings", offset, limit);
        if (returnSize) {
            collectionBinding.setSize(bindingEntities.size());
        }
        return EntityBuilder.getResponse(collectionBinding, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="saveGroupsSpaceBindings/{spaceId}")
    @Operation(summary="Save space group bindings", method="POST", description="This method set bindings for a specific space with a list of groups if the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response saveGroupSpaceBindings(@Context UriInfo uriInfo, @Parameter(description="SpaceId of the space", required=true) @PathParam(value="spaceId") String spaceId, @Parameter(description="List of group names to be bound to the space", required=true) List<String> groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List spaceBoundGroups = this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(spaceId).stream().map(groupSpaceBinding -> groupSpaceBinding.getGroup()).collect(Collectors.toList());
        List spaceRemovedBoundGroups = this.groupSpaceBindingService.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_REMOVE).stream().filter(groupSpaceBinding -> groupSpaceBinding.getSpaceId().equals(spaceId)).map(groupSpaceBinding -> groupSpaceBinding.getGroup()).collect(Collectors.toList());
        spaceBoundGroups.removeAll(spaceRemovedBoundGroups);
        groupNames.removeAll(spaceBoundGroups);
        if (groupNames.size() == 0) {
            return Response.ok((Object)"Already bound!").build();
        }
        ArrayList groupSpaceBindings = new ArrayList();
        groupNames.stream().forEach(groupName -> groupSpaceBindings.add(new GroupSpaceBinding(spaceId, groupName)));
        this.groupSpaceBindingService.saveGroupSpaceBindings(groupSpaceBindings);
        return Response.ok().build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="removeGroupSpaceBinding/{bindingId}")
    @Operation(summary="Deletes a binding.", method="DELETE", description="This method deletes a binding in the following cases the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteSpaceBinding(@Context UriInfo uriInfo, @Parameter(description="spaceId", required=true) @PathParam(value="bindingId") String bindingId) throws Exception {
        GroupSpaceBinding binding = this.groupSpaceBindingService.findGroupSpaceBindingById(bindingId);
        if (binding != null) {
            this.groupSpaceBindingService.prepareDeleteGroupSpaceBinding(binding);
        }
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="getExport")
    @Operation(summary="Gets CSV report", method="GET", description="Given a (space,group,action,groupBindingId), it return all lines of the report in a csv file")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getReport(@Context UriInfo uriInfo, @Parameter(description="spaceId", required=true) @QueryParam(value="spaceId") String spaceId, @Parameter(description="action", required=true) @QueryParam(value="action") String action, @Parameter(description="group", required=true) @QueryParam(value="group") String group, @Parameter(description="groupBindingId") @QueryParam(value="groupBindingId") String groupBindingId) throws Exception {
        List reports = this.groupSpaceBindingService.findReportsForCsv(Long.parseLong(spaceId), Long.parseLong(groupBindingId), group, action);
        String csvString = this.computeCSV(spaceId, group, action, reports);
        try {
            String filename = action.substring(0, 1).toUpperCase() + action.substring(1, action.length()).toLowerCase() + "Binding_";
            filename = filename + this.spaceService.getSpaceById(spaceId).getPrettyName() + "_";
            if (group.charAt(0) == '/') {
                group = group.substring(1, group.length());
            }
            filename = filename + group.replace("/", "_") + "_";
            filename = filename + this.formater.format(new Date());
            File temp = null;
            temp = File.createTempFile(filename, ".csv");
            temp.deleteOnExit();
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            bw.write(csvString);
            bw.close();
            Response.ResponseBuilder response = Response.ok((Object)temp);
            response.header("Content-Disposition", (Object)("attachment; filename=" + filename + ".csv"));
            return response.build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating temp file");
            return Response.serverError().build();
        }
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Path(value="getBindingReportOperations")
    @Operation(summary="Gets list of groups entities from the parent group root.", method="GET", description="Returns a list of group entities in the following cases if the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getBindingReportOperations(@Context UriInfo uriInfo, @Parameter(description="spaceId", required=true) @QueryParam(value="spaceId") String spaceId) throws Exception {
        List bindingOperationReports = StringUtils.isBlank((CharSequence)spaceId) ? this.groupSpaceBindingService.getGroupSpaceBindingReportOperations() : this.groupSpaceBindingService.getGroupSpaceBindingReportOperations(spaceId);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        ArrayList<DataEntity> bindingOperationReportsDataEntities = new ArrayList<DataEntity>();
        for (GroupSpaceBindingOperationReport bindingOperationReport : bindingOperationReports) {
            GroupSpaceBindingOperationReportEntity operationReportEntity = EntityBuilder.buildEntityFromGroupSpaceBindingOperationReport(bindingOperationReport);
            OrganizationService organizationService = CommonsUtils.getOrganizationService();
            Group group = organizationService.getGroupHandler().findGroupById(bindingOperationReport.getGroup());
            GroupNodeEntity groupNodeEntity = group != null ? EntityBuilder.buildEntityFromGroup(group) : EntityBuilder.buildEntityFromGroupId(bindingOperationReport.getGroup());
            operationReportEntity.setGroup(groupNodeEntity.getDataEntity());
            Space space = this.spaceService.getSpaceById(Long.toString(bindingOperationReport.getSpaceId()));
            SpaceEntity spaceEntity = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), null);
            operationReportEntity.setSpace(spaceEntity.getDataEntity());
            bindingOperationReportsDataEntities.add(operationReportEntity.getDataEntity());
        }
        CollectionEntity collectionBindingReports = new CollectionEntity(bindingOperationReportsDataEntities, "groupSpaceBindingReportOperations", 0, 10);
        return EntityBuilder.getResponse(collectionBindingReports, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private String computeCSV(String spaceId, String group, String action, List<GroupSpaceBindingReportUser> reports) {
        StringBuilder sbResult = new StringBuilder();
        Space space = this.spaceService.getSpaceById(spaceId);
        sbResult.append(space.getDisplayName() + "\n");
        sbResult.append(group + "\n");
        sbResult.append(action + "\n");
        if (reports.size() != 0) {
            sbResult.append(String.valueOf(reports.get(0).getDate()) + "\n");
            sbResult.append(String.valueOf(reports.get(reports.size() - 1).getDate()) + "\n");
        }
        sbResult.append("Username,Action,Date,Present Before,Still in space\n");
        reports.stream().forEach(groupSpaceBindingReport -> {
            sbResult.append(groupSpaceBindingReport.getUsername() + ",");
            if (!groupSpaceBindingReport.getGroupSpaceBindingReportAction().getAction().equals("SYNCHRONIZE") && groupSpaceBindingReport.getAction().equals("REMOVE_USER") && (groupSpaceBindingReport.isWasPresentBefore() || groupSpaceBindingReport.isStillInSpace())) {
                sbResult.append(",");
            } else {
                sbResult.append(groupSpaceBindingReport.getAction() + ",");
            }
            sbResult.append(String.valueOf(groupSpaceBindingReport.getDate()) + ",");
            sbResult.append(groupSpaceBindingReport.isWasPresentBefore() + ",");
            if (groupSpaceBindingReport.getAction().equals("REMOVE_USER")) {
                sbResult.append(groupSpaceBindingReport.isStillInSpace());
            }
            sbResult.append("\n");
        });
        return sbResult.toString();
    }
}

