/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.utils;

import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.rest.model.PollOptionRestEntity;
import io.meeds.poll.rest.model.PollRestEntity;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.PollUtils;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class RestEntityBuilder {
    private static final String ONE_DAY_DURATION = "1day";
    private static final String THREE_DAYS_DURATION = "3days";
    private static final String ONE_WEEK_DURATION = "1week";
    private static final String TWO_WEEKS_DURATION = "2weeks";

    private RestEntityBuilder() {
    }

    public static PollRestEntity fromPoll(PollService pollService, Poll poll, Identity currentUserIdentity) throws IllegalAccessException {
        List pollOptions = pollService.getPollOptionsByPollId(poll.getId(), currentUserIdentity);
        ArrayList<PollOptionRestEntity> pollOptionRestEntities = new ArrayList<PollOptionRestEntity>();
        for (PollOption pollOption : pollOptions) {
            int pollOptionVotes = pollService.getPollOptionTotalVotes(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentUserIdentity);
            boolean isPollOptionVoted = pollService.isPollOptionVoted(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentUserIdentity);
            PollOptionRestEntity pollOptionRestEntity = RestEntityBuilder.fromPollOption(pollOption, pollOptionVotes, isPollOptionVoted);
            pollOptionRestEntities.add(pollOptionRestEntity);
        }
        return RestEntityBuilder.fromPoll(poll, pollOptionRestEntities);
    }

    public static final PollRestEntity fromPoll(Poll poll, List<PollOptionRestEntity> pollOptionRestEntities) {
        PollRestEntity pollRestEntity = new PollRestEntity();
        pollRestEntity.setId(poll.getId());
        pollRestEntity.setQuestion(poll.getQuestion());
        pollRestEntity.setOptions(pollOptionRestEntities);
        pollRestEntity.setEndDateTime(poll.getEndDate().getTime());
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (identityManager.getIdentity(String.valueOf(poll.getCreatorId())) != null) {
            pollRestEntity.setCreator(identityManager.getIdentity(String.valueOf(poll.getCreatorId())).getRemoteId());
        }
        return pollRestEntity;
    }

    public static final PollOptionRestEntity fromPollOption(PollOption pollOption, int votes, boolean voted) {
        PollOptionRestEntity pollOptionRestEntity = new PollOptionRestEntity();
        pollOptionRestEntity.setId(pollOption.getId());
        pollOptionRestEntity.setDescription(pollOption.getDescription());
        pollOptionRestEntity.setVotes(votes);
        pollOptionRestEntity.setVoted(voted);
        return pollOptionRestEntity;
    }

    public static final Poll toPoll(PollRestEntity pollRestEntity) {
        Date createdDate = new Date();
        ZonedDateTime createdZonedDateTime = ZonedDateTime.ofInstant(createdDate.toInstant(), ZoneOffset.UTC);
        ZonedDateTime endZonedDateTime = null;
        switch (pollRestEntity.getDuration()) {
            case "1day": {
                endZonedDateTime = createdZonedDateTime.plusDays(1L);
                break;
            }
            case "3days": {
                endZonedDateTime = createdZonedDateTime.plusDays(3L);
                break;
            }
            case "1week": {
                endZonedDateTime = createdZonedDateTime.plusDays(7L);
                break;
            }
            case "2weeks": {
                endZonedDateTime = createdZonedDateTime.plusDays(14L);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + pollRestEntity.getDuration());
            }
        }
        Poll poll = new Poll();
        poll.setQuestion(pollRestEntity.getQuestion());
        poll.setCreatedDate(createdDate);
        poll.setEndDate(PollUtils.toDate(endZonedDateTime));
        return poll;
    }

    public static final List<PollOption> toPollOptions(List<PollOptionRestEntity> pollOptionEntities) {
        return pollOptionEntities.stream().map(pollOptionEntity -> {
            PollOption pollOption = new PollOption();
            pollOption.setDescription(pollOptionEntity.getDescription());
            return pollOption;
        }).toList();
    }
}

