/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.common.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.picketlink.idm.common.transaction.NestedException;
import org.picketlink.idm.common.transaction.TransactionException;

public class Transactions {
    private static Logger log = Logger.getLogger(Transactions.class);
    private static final String[] STATUS_NAMES = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};
    public static final Type TYPE_NOT_SUPPORTED = new Type("NOT_SUPPORTED"){

        @Override
        void txBefore(TransactionManager tm, Transaction oldTx) {
        }

        @Override
        void txAfter(TransactionManager tm, Transaction oldTx) {
        }

        @Override
        void noTxBefore(TransactionManager tm) {
        }

        @Override
        void noTxAfter(TransactionManager tm) {
        }
    };
    public static final Type TYPE_SUPPORTS = new Type("SUPPORTS"){

        @Override
        void txBefore(TransactionManager tm, Transaction oldTx) throws TransactionException {
            Transactions.resume(tm, oldTx);
        }

        @Override
        void txAfter(TransactionManager tm, Transaction oldTx) {
            try {
                Transactions.suspend(tm);
            }
            catch (IllegalStateException ignore) {
                log.error((Object)"Problem when suspending transaction", (Throwable)ignore);
            }
        }

        @Override
        void noTxBefore(TransactionManager tm) {
        }

        @Override
        void noTxAfter(TransactionManager tm) {
        }
    };
    public static final Type TYPE_REQUIRED = new Type("REQUIRED"){

        @Override
        void txBefore(TransactionManager tm, Transaction oldTx) {
            Transactions.resume(tm, oldTx);
        }

        @Override
        void txAfter(TransactionManager tm, Transaction oldTx) {
            try {
                Transactions.suspend(tm);
            }
            catch (TransactionException ignore) {
                log.error((Object)"Problem when suspending transaction", (Throwable)ignore);
            }
        }

        @Override
        void noTxBefore(TransactionManager tm) throws TransactionException {
            Transactions.begin(tm);
        }

        @Override
        void noTxAfter(TransactionManager tm) {
            try {
                Transactions.end(tm);
            }
            catch (IllegalStateException ignore) {
                log.error((Object)"Problem when ending transaction", (Throwable)ignore);
            }
        }
    };
    public static final Type TYPE_REQUIRES_NEW = new Type("REQUIRES_NEW"){

        @Override
        void txBefore(TransactionManager tm, Transaction oldTx) throws TransactionException {
            Transactions.begin(tm);
        }

        @Override
        void txAfter(TransactionManager tm, Transaction oldTx) {
            try {
                Transactions.end(tm);
            }
            catch (IllegalStateException ignore) {
                log.error((Object)"Problem when ending transaction", (Throwable)ignore);
            }
        }

        @Override
        void noTxBefore(TransactionManager tm) throws TransactionException {
            Transactions.begin(tm);
        }

        @Override
        void noTxAfter(TransactionManager tm) {
            try {
                Transactions.end(tm);
            }
            catch (IllegalStateException ignore) {
                log.error((Object)"Problem when ending transaction", (Throwable)ignore);
            }
        }
    };
    public static final Type TYPE_MANDATORY = new Type("MANDATORY"){

        @Override
        void txBefore(TransactionManager tm, Transaction oldTx) throws TransactionException {
            Transactions.resume(tm, oldTx);
        }

        @Override
        void txAfter(TransactionManager tm, Transaction oldTx) {
        }

        @Override
        void noTxBefore(TransactionManager tm) throws TransactionException {
            throw new TransactionException("No incoming transaction");
        }

        @Override
        void noTxAfter(TransactionManager tm) {
            throw new UnsupportedOperationException("Should never ne called");
        }
    };
    public static final Type TYPE_NEVER = new Type("NEVER"){

        @Override
        void txBefore(TransactionManager tm, Transaction oldTx) throws TransactionException {
            throw new TransactionException("Need no incoming transaction");
        }

        @Override
        void txAfter(TransactionManager tm, Transaction oldTx) {
            throw new UnsupportedOperationException("Should never ne called");
        }

        @Override
        void noTxBefore(TransactionManager tm) {
        }

        @Override
        void noTxAfter(TransactionManager tm) {
        }
    };

    public static String decodeStatus(int status) {
        if (status >= 0 && status <= STATUS_NAMES.length) {
            return STATUS_NAMES[status];
        }
        return null;
    }

    public static Transaction applyBefore(Type type, TransactionManager tm) throws TransactionException, IllegalArgumentException {
        if (tm == null) {
            throw new IllegalArgumentException("No transaction manager provided");
        }
        if (type == null) {
            throw new IllegalArgumentException("No type");
        }
        Transaction oldTx = Transactions.suspend(tm);
        if (oldTx != null) {
            type.txBefore(tm, oldTx);
        } else {
            type.noTxBefore(tm);
        }
        return oldTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyAfter(Type type, TransactionManager tm, Transaction oldTx) throws TransactionException, IllegalArgumentException {
        if (tm == null) {
            throw new IllegalArgumentException("No transaction manager provided");
        }
        if (type == null) {
            throw new IllegalArgumentException("No type");
        }
        try {
            if (oldTx != null) {
                type.txAfter(tm, oldTx);
            } else {
                type.noTxAfter(tm);
            }
        }
        finally {
            if (oldTx != null) {
                try {
                    Transactions.resume(tm, oldTx);
                }
                catch (TransactionException ignore) {
                    log.error((Object)"Was not capable to resume the incoming transaction", (Throwable)ignore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object apply(Type type, TransactionManager tm, Runnable runnable) throws NestedException, TransactionException, IllegalArgumentException {
        Object ret;
        Throwable throwable;
        block24: {
            if (tm == null) {
                throw new IllegalArgumentException("No transaction manager provided");
            }
            if (runnable == null) {
                throw new IllegalArgumentException("No code to execute");
            }
            if (type == null) {
                throw new IllegalArgumentException("No type");
            }
            throwable = null;
            ret = null;
            Transaction oldTx = Transactions.suspend(tm);
            try {
                if (oldTx != null) {
                    type.txBefore(tm, oldTx);
                    try {
                        ret = runnable.run();
                        type.txAfter(tm, oldTx);
                        break block24;
                    }
                    catch (Throwable t) {
                        try {
                            throwable = t;
                            break block24;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            type.txAfter(tm, oldTx);
                        }
                    }
                }
                type.noTxBefore(tm);
                try {
                    ret = runnable.run();
                    type.noTxAfter(tm);
                }
                catch (Throwable t) {
                    try {
                        throwable = t;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        type.noTxAfter(tm);
                    }
                }
            }
            finally {
                if (oldTx != null) {
                    try {
                        Transactions.resume(tm, oldTx);
                    }
                    catch (TransactionException ignore) {
                        log.error((Object)"Was not capable to resume the incoming transaction", (Throwable)ignore);
                    }
                }
            }
        }
        if (throwable != null) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new NestedException(throwable);
        }
        return ret;
    }

    public static Object notSupported(TransactionManager tm, Runnable runnable) throws NestedException, TransactionException {
        return Transactions.apply(TYPE_NOT_SUPPORTED, tm, runnable);
    }

    public static Object never(TransactionManager tm, Runnable runnable) throws NestedException, TransactionException {
        return Transactions.apply(TYPE_NEVER, tm, runnable);
    }

    public static Object mandatory(TransactionManager tm, Runnable runnable) throws NestedException, TransactionException {
        return Transactions.apply(TYPE_MANDATORY, tm, runnable);
    }

    public static Object supports(TransactionManager tm, Runnable runnable) throws NestedException, TransactionException {
        return Transactions.apply(TYPE_SUPPORTS, tm, runnable);
    }

    public static Object required(TransactionManager tm, Runnable runnable) throws NestedException, TransactionException {
        return Transactions.apply(TYPE_REQUIRED, tm, runnable);
    }

    public static Object requiresNew(TransactionManager tm, Runnable runnable) throws NestedException, TransactionException {
        return Transactions.apply(TYPE_REQUIRES_NEW, tm, runnable);
    }

    public static void begin(TransactionManager tm) throws IllegalArgumentException, TransactionException {
        try {
            if (tm == null) {
                throw new IllegalArgumentException("No transaction manager");
            }
            tm.begin();
        }
        catch (SystemException e) {
            log.error((Object)"Problem when beginning transaction", (Throwable)e);
            throw new TransactionException(e);
        }
        catch (NotSupportedException e) {
            log.error((Object)"Problem when beginning transaction", (Throwable)e);
            throw new TransactionException(e);
        }
    }

    private static void setRollbackOnly(Transaction tx) throws IllegalArgumentException, TransactionException {
        try {
            if (tx == null) {
                throw new IllegalArgumentException("No transaction to set rollback only");
            }
            tx.setRollbackOnly();
        }
        catch (SystemException e) {
            log.error((Object)"Problem when setting transaction as rollback only", (Throwable)e);
            throw new TransactionException(e);
        }
    }

    public static void setRollbackOnly(TransactionManager tm) throws IllegalArgumentException, TransactionException {
        try {
            if (tm == null) {
                throw new IllegalArgumentException("No transaction manager");
            }
            Transaction tx = tm.getTransaction();
            if (tx == null) {
                throw new TransactionException("No active transaction to set rollback only");
            }
            Transactions.setRollbackOnly(tx);
        }
        catch (SystemException e) {
            log.error((Object)"Problem when setting transaction as rollback only", (Throwable)e);
            throw new TransactionException(e);
        }
    }

    public void safeSetRollbackOnly(TransactionManager tm) {
        try {
            Transactions.setRollbackOnly(tm);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (TransactionException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static void safeEnd(TransactionManager tm) {
        try {
            Transactions.end(tm);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (TransactionException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static boolean end(TransactionManager tm) throws IllegalArgumentException, TransactionException {
        try {
            if (tm == null) {
                throw new IllegalArgumentException("No transaction manager");
            }
            int status = tm.getStatus();
            switch (status) {
                case 1: {
                    tm.rollback();
                    return false;
                }
                case 0: {
                    tm.commit();
                    return true;
                }
            }
            throw new TransactionException("Abnormal status for ending a tx " + STATUS_NAMES[status]);
        }
        catch (SystemException e) {
            log.error((Object)"Problem when ending transaction", (Throwable)e);
            throw new TransactionException(e);
        }
        catch (HeuristicMixedException e) {
            log.error((Object)"Problem when ending transaction", (Throwable)e);
            throw new TransactionException(e);
        }
        catch (HeuristicRollbackException e) {
            log.error((Object)"Problem when ending transaction", (Throwable)e);
            throw new TransactionException(e);
        }
        catch (RollbackException e) {
            log.error((Object)"Problem when ending transaction", (Throwable)e);
            throw new TransactionException(e);
        }
    }

    public static void resume(TransactionManager tm, Transaction tx) throws IllegalArgumentException, TransactionException {
        try {
            if (tm == null) {
                throw new IllegalArgumentException("No transaction manager");
            }
            if (tx == null) {
                throw new IllegalArgumentException("No transaction to resume");
            }
            tm.resume(tx);
        }
        catch (Exception e) {
            log.error((Object)"Problem when resuming transaction", (Throwable)e);
            throw new TransactionException(e);
        }
    }

    public static Transaction suspend(TransactionManager tm) throws IllegalArgumentException, TransactionException {
        try {
            if (tm == null) {
                throw new IllegalArgumentException("No transaction manager");
            }
            return tm.suspend();
        }
        catch (SystemException e) {
            log.error((Object)"Problem when suspending transaction", (Throwable)e);
            throw new TransactionException(e);
        }
    }

    public static abstract class Type {
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public Transaction before(TransactionManager tm) {
            return Transactions.applyBefore(this, tm);
        }

        public void after(TransactionManager tm, Transaction oldTx) {
            Transactions.applyAfter(this, tm, oldTx);
        }

        abstract void txBefore(TransactionManager var1, Transaction var2) throws TransactionException;

        abstract void txAfter(TransactionManager var1, Transaction var2);

        abstract void noTxBefore(TransactionManager var1) throws TransactionException;

        abstract void noTxAfter(TransactionManager var1);

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Runnable {
        public Object run() throws Exception;
    }
}

