/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.listener;

import io.meeds.tenant.hub.service.HubService;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.web3j.crypto.WalletUtils;

@Component
public class DeedManagerUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(DeedManagerUserListener.class);
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private HubService hubService;
    private List<String> tenantManagerDefaultRoles = Arrays.asList("*:/platform/users", "*:/platform/administrators", "*:/platform/analytics", "*:/platform/rewarding");

    @PostConstruct
    public void init() {
        this.organizationService.getUserHandler().addUserEventListener((UserEventListener)this);
    }

    public void postSave(User user, boolean isNew) throws Exception {
        String address = user.getUserName();
        if (isNew && user.isEnabled() && WalletUtils.isValidAddress((String)address) && this.hubService.isDeedManager(address)) {
            this.saveHubHostRoles(user);
        }
    }

    public void saveHubHostRoles(User user) {
        LOG.info((Object)"Tenant manager registered, setting its default memberships as manager.");
        for (String membership : this.tenantManagerDefaultRoles) {
            if (!StringUtils.isNotBlank((CharSequence)membership)) continue;
            LOG.info("Add Tenant manager membership {}.", new Object[]{membership});
            if (StringUtils.contains((CharSequence)membership, (CharSequence)":")) {
                String[] membershipParts = StringUtils.split((String)membership, (String)":");
                this.addUserToGroup(user, membershipParts[1], membershipParts[0]);
                continue;
            }
            this.addUserToGroup(user, membership, "*");
        }
    }

    private void addUserToGroup(User user, String groupId, String membershipTypeId) {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        MembershipHandler membershipHandler = this.organizationService.getMembershipHandler();
        MembershipTypeHandler membershipTypeHandler = this.organizationService.getMembershipTypeHandler();
        try {
            Group group = groupHandler.findGroupById(groupId);
            MembershipType membershipType = membershipTypeHandler.findMembershipType(membershipTypeId);
            if (group != null && membershipType != null) {
                membershipHandler.linkMembership(user, group, membershipType, true);
            } else if (group == null) {
                LOG.warn("Group with id {} wasn't found. Tenant manager membership {} will not be set.", new Object[]{groupId, membershipTypeId + ":" + groupId});
            } else {
                LOG.warn("Membership Type with id {} wasn't found. Tenant manager membership {} will not be set.", new Object[]{membershipTypeId, membershipTypeId + ":" + groupId});
            }
        }
        catch (Exception e) {
            LOG.warn("Error while adding user {} to role {}:{}", new Object[]{user.getUserName(), membershipTypeId, groupId, e});
        }
    }
}

