/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.notification.plugin;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import org.apache.commons.lang3.LocaleUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class KudosActivityChildPlugin
extends AbstractNotificationChildPlugin {
    protected KudosService kudosService;

    public KudosActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        if (notification == null) {
            return "";
        }
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        Kudos kudos = this.getKudosService().getKudosByActivityId(Long.parseLong(activityId.replace("comment", "")));
        if (kudos == null) {
            return "";
        }
        String language = this.getLanguage(notification);
        Utils.transformKudosMessage(kudos, this.getUserIdentity(notification), LocaleUtils.toLocale((String)language));
        String message = kudos.getMessage();
        TemplateContext templateContext = new TemplateContext(this.getId(), language);
        templateContext.put((Object)"MESSAGE", (Object)message);
        return TemplateUtils.processGroovy((TemplateContext)templateContext);
    }

    public String getId() {
        return "exokudos:activity";
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }

    public KudosService getKudosService() {
        if (this.kudosService == null) {
            this.kudosService = (KudosService)ExoContainerContext.getService(KudosService.class);
        }
        return this.kudosService;
    }
}

