/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.storage;

import io.meeds.twitter.gamification.dao.TwitterAccountDAO;
import io.meeds.twitter.gamification.entity.TwitterAccountEntity;
import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.storage.mapper.TwitterAccountMapper;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class TwitterAccountStorage {
    private static final Scope TWITTER_CONNECTOR_SCOPE = Scope.APPLICATION.id("twitterConnector");
    private static final String BEARER_TOKEN_KEY = "BEARER_TOKEN";
    @Autowired
    private TwitterAccountDAO twitterAccountDAO;
    @Autowired
    private SettingService settingService;
    @Autowired
    private CodecInitializer codecInitializer;

    public TwitterAccount addTwitterAccount(TwitterAccount twitterAccount) throws ObjectAlreadyExistsException {
        TwitterAccount existsAccount = this.getTwitterAccountByRemoteId(twitterAccount.getRemoteId());
        if (existsAccount == null) {
            TwitterAccountEntity twitterAccountEntity = TwitterAccountMapper.toEntity(twitterAccount);
            twitterAccountEntity.setWatchedDate(new Date());
            twitterAccountEntity.setUpdatedDate(new Date());
            twitterAccountEntity.setRefreshDate(new Date());
            twitterAccountEntity = (TwitterAccountEntity)this.twitterAccountDAO.save(twitterAccountEntity);
            return TwitterAccountMapper.fromEntity(twitterAccountEntity);
        }
        throw new ObjectAlreadyExistsException((Object)existsAccount);
    }

    public TwitterAccount getTwitterAccountById(Long id) {
        return TwitterAccountMapper.fromEntity(this.twitterAccountDAO.findById(id).orElse(null));
    }

    public Page<TwitterAccount> getTwitterAccounts(Pageable pageable) {
        Page page = this.twitterAccountDAO.findAll(pageable);
        return page.map(TwitterAccountMapper::fromEntity);
    }

    public List<TwitterAccount> getTwitterAccounts() {
        List twitterAccountEntities = this.twitterAccountDAO.findAll();
        return twitterAccountEntities.stream().map(TwitterAccountMapper::fromEntity).toList();
    }

    public long countTwitterAccounts() {
        return this.twitterAccountDAO.count();
    }

    public TwitterAccount getTwitterAccountByRemoteId(long remoteId) {
        TwitterAccountEntity twitterAccountEntity = this.twitterAccountDAO.findTwitterAccountEntityByRemoteId(remoteId);
        return TwitterAccountMapper.fromEntity(twitterAccountEntity);
    }

    public TwitterAccount updateAccountLastMentionTweetId(long accountId, long lastMentionTweetId) {
        TwitterAccountEntity twitterAccountEntity = this.twitterAccountDAO.findById(accountId).orElse(null);
        if (twitterAccountEntity == null) {
            return null;
        }
        twitterAccountEntity.setLastMentionTweetId(lastMentionTweetId);
        return TwitterAccountMapper.fromEntity((TwitterAccountEntity)this.twitterAccountDAO.save(twitterAccountEntity));
    }

    public TwitterAccount deleteTwitterAccount(long accountId) {
        TwitterAccountEntity twitterAccountEntity = this.twitterAccountDAO.findById(accountId).orElse(null);
        if (twitterAccountEntity != null) {
            this.twitterAccountDAO.delete(twitterAccountEntity);
        }
        return TwitterAccountMapper.fromEntity(twitterAccountEntity);
    }

    public void saveTwitterBearerToken(String bearerToken) {
        String encodedBearerToken = this.encode(bearerToken);
        this.settingService.set(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY, SettingValue.create((String)encodedBearerToken));
    }

    public void deleteTwitterBearerToken() {
        this.settingService.remove(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY);
    }

    public String getTwitterBearerToken() {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY);
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            return this.decode(settingValue.getValue().toString());
        }
        return null;
    }

    private String encode(String token) {
        try {
            return this.codecInitializer.getCodec().encode(token);
        }
        catch (TokenServiceInitializationException e) {
            throw new IllegalStateException("Error encrypting token", e);
        }
    }

    private String decode(String encryptedToken) {
        try {
            return this.codecInitializer.getCodec().decode(encryptedToken);
        }
        catch (TokenServiceInitializationException e) {
            throw new IllegalStateException("Error decrypting token", e);
        }
    }
}

