/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchList;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;

public final class ImmutableFetchList
implements FetchList {
    public static ImmutableFetchList EMPTY = new ImmutableFetchList();
    private final Fetch[] fetches;

    private ImmutableFetchList() {
        this.fetches = null;
    }

    private ImmutableFetchList(Fetch[] fetches) {
        assert (fetches != null);
        this.fetches = fetches;
    }

    @Override
    public int size() {
        if (this.fetches == null) {
            return 0;
        }
        int size = 0;
        for (Fetch fetch : this.fetches) {
            if (fetch == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.fetches == null;
    }

    @Override
    public Fetch get(Fetchable fetchable) {
        return this.fetches == null ? null : this.fetches[fetchable.getFetchableKey()];
    }

    @Override
    public void forEach(Consumer<? super Fetch> consumer) {
        if (this.fetches != null) {
            for (Fetch fetch : this.fetches) {
                if (fetch == null) continue;
                consumer.accept(fetch);
            }
        }
    }

    @Override
    public void indexedForEach(IndexedConsumer<? super Fetch> consumer) {
        if (this.fetches != null) {
            int index = 0;
            for (Fetch fetch : this.fetches) {
                if (fetch == null) continue;
                consumer.accept(index++, fetch);
            }
        }
    }

    @Override
    public Iterator<Fetch> iterator() {
        if (this.fetches == null) {
            return Collections.emptyIterator();
        }
        return new FetchIterator();
    }

    public static class Builder {
        private final Fetch[] fetches;

        public Builder(FetchableContainer container) {
            this.fetches = new Fetch[container.getNumberOfFetchableKeys()];
        }

        public void add(Fetch fetch) {
            this.fetches[fetch.getFetchedMapping().getFetchableKey()] = fetch;
        }

        public ImmutableFetchList build() {
            for (Fetch fetch : this.fetches) {
                if (fetch == null) continue;
                return new ImmutableFetchList(this.fetches);
            }
            return EMPTY;
        }
    }

    private final class FetchIterator
    implements Iterator<Fetch> {
        private int idx;

        public FetchIterator() {
            assert (ImmutableFetchList.this.fetches != null);
            this.idx = 0;
            while (ImmutableFetchList.this.fetches[this.idx] == null) {
                ++this.idx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.idx < ImmutableFetchList.this.fetches.length;
        }

        @Override
        public Fetch next() {
            Fetch fetch = ImmutableFetchList.this.fetches[this.idx++];
            while (this.idx < ImmutableFetchList.this.fetches.length && ImmutableFetchList.this.fetches[this.idx] == null) {
                ++this.idx;
            }
            return fetch;
        }
    }
}

