/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.csrf;

import java.lang.annotation.Annotation;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.GenericMethodResource;
import org.exoplatform.services.rest.servlet.ServletContainerRequest;
import org.exoplatform.web.security.csrf.CSRFTokenUtil;
import org.exoplatform.web.security.csrf.ExoCSRFCheck;

public class CSRFAccessFilter
implements MethodInvokerFilter {
    private static final Log LOG = ExoLogger.getLogger(CSRFAccessFilter.class);

    public void accept(GenericMethodResource method) {
        for (Annotation a : method.getMethod().getAnnotations()) {
            Class<? extends Annotation> ac = a.annotationType();
            if (ac != ExoCSRFCheck.class) continue;
            ServletContainerRequest request = (ServletContainerRequest)ApplicationContextImpl.getCurrent().getContainerRequest();
            if (request == null) {
                LOG.warn("HTTP Request not found. Can't check CSRF token on method (method={})", new Object[]{method.getMethod().getName()});
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You do not have the permissions to perform this operation").type("text/plain").build());
            }
            if (CSRFTokenUtil.check(request.getServletRequest())) continue;
            LOG.warn("CSRF token is lost or this is an CSRF attack (method={})", new Object[]{method.getMethod().getName()});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You do not have the permissions to perform this operation").type("text/plain").build());
        }
    }
}

