/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.suggest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure1;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/homepage/intranet/spaces/")
@Produces(value={"application/json"})
@Deprecated
public class SpaceRestServices
implements ResourceContainer {
    private static final Log LOG;
    private static final CacheControl cacheControl;
    private static final String SPACE_NAME = "name";
    private static final String SPACE_ID = "spaceId";
    private static final String SPACE_DISPLAY_NAME = "displayName";
    private static final String SPACE_URL = "spaceUrl";
    private static final String SPACE_AVATAR_URL = "spaceAvatarUrl";
    private static final String SPACE_REGISTRATION = "registration";
    private static final String SPACE_MEMBERS = "members";
    private static final String SPACE_PRIVACY = "privacy";
    private static final String NUMBER = "number";
    private static final String SPACE_CREATED_DATE = "createdDate";
    private static final String ITEMS = "items";
    private final ExoContainer container;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public SpaceRestServices(ExoContainerContext ctx) {
        this.container = ctx.getContainer();
    }

    @GET
    @Path(value="suggestions")
    @DeprecatedAPI(value="Use SpaceRestResourcesV1.getSpaces instead")
    public Response getSuggestions(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)securityContext, (Object)uriInfo2);
        Object[] objectArray = new Object[]{this, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure1 spaceRestServices$AjcClosure1 = new SpaceRestServices$AjcClosure1(objectArray);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private JSONObject buildJSONObject(Space space, int k) throws JSONException {
        String avatar = space.getAvatarUrl();
        if (avatar == null) {
            avatar = "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
        }
        String spaceType = "";
        spaceType = space.getRegistration() == null || space.getRegistration().equals("open") ? "Public" : "Private";
        JSONObject json = new JSONObject();
        json.put(SPACE_NAME, (Object)space.getPrettyName());
        json.put(SPACE_ID, (Object)space.getId());
        json.put(SPACE_DISPLAY_NAME, (Object)space.getDisplayName());
        json.put(SPACE_URL, (Object)space.getUrl());
        json.put(SPACE_AVATAR_URL, (Object)avatar);
        json.put(SPACE_REGISTRATION, (Object)space.getRegistration());
        json.put(SPACE_MEMBERS, space.getMembers() == null ? 0 : space.getMembers().length);
        json.put(SPACE_PRIVACY, (Object)spaceType);
        json.put(NUMBER, k);
        json.put(SPACE_CREATED_DATE, space.getCreatedTime());
        return json;
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        SpaceRestServices.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceRestServices.class);
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    static final /* synthetic */ Response getSuggestions_aroundBody0(SpaceRestServices ajc$this, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            HashMap<Space, Integer> spacesWithMemberNum;
            String userId;
            JSONObject jsonGlobal;
            JSONArray jsonArray;
            block17: {
                Space[] suggestedSpaces;
                Identity[] connections;
                jsonArray = new JSONArray();
                jsonGlobal = new JSONObject();
                userId = ajc$this.getUserId(sc, uriInfo);
                if (userId == null) {
                    return Response.status((int)500).cacheControl(cacheControl).build();
                }
                SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
                ListAccess suggestedSpacesLA = spaceService.getMemberSpaces(userId);
                int size = suggestedSpacesLA.getSize();
                if (size == 0) {
                    jsonGlobal.put(ITEMS, (Object)jsonArray);
                    jsonGlobal.put("noConnections", 0);
                    jsonGlobal.put("username", (Object)userId);
                    return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
                }
                IdentityManager identityManager = (IdentityManager)ajc$this.container.getComponentInstanceOfType(IdentityManager.class);
                RelationshipManager relationshipManager = (RelationshipManager)ajc$this.container.getComponentInstanceOfType(RelationshipManager.class);
                Identity identity = identityManager.getOrCreateIdentity("organization", userId, false);
                ListAccess connectionsLA = relationshipManager.getConnections(identity);
                spacesWithMemberNum = new HashMap<Space, Integer>();
                int maxConnectionsToLoad = 100;
                int maxSpacesToLoad = 50;
                int maxSuggestions = 10;
                int totalConnections = connectionsLA.getSize();
                Random random = new Random();
                if (totalConnections > maxConnectionsToLoad) {
                    int startIndex = random.nextInt(totalConnections - maxConnectionsToLoad);
                    connections = (Identity[])connectionsLA.load(startIndex, maxConnectionsToLoad);
                } else {
                    connections = (Identity[])connectionsLA.load(0, totalConnections);
                }
                if (size > maxSpacesToLoad) {
                    int startIndex = random.nextInt(size - maxSpacesToLoad);
                    suggestedSpaces = (Space[])suggestedSpacesLA.load(startIndex, maxSpacesToLoad);
                } else {
                    suggestedSpaces = (Space[])suggestedSpacesLA.load(0, size);
                }
                for (Space space : suggestedSpaces) {
                    if (spaceService.isMember(space, identity.getRemoteId())) continue;
                    for (Identity connector : connections) {
                        if ("hidden".equals(space.getVisibility()) || "closed".equals(space.getRegistration()) || !spaceService.isMember(space, connector.getRemoteId()) || !spaceService.isIgnored(space, connector.getRemoteId())) continue;
                        Integer value = (Integer)spacesWithMemberNum.get(space);
                        value = value == null ? new Integer(1) : new Integer(value + 1);
                        spacesWithMemberNum.put(space, value);
                    }
                }
                if (!spacesWithMemberNum.isEmpty()) {
                    ArrayList<Space> spaces;
                    TreeMap<Integer, ArrayList<Space>> groupByCommonConnections = new TreeMap<Integer, ArrayList<Space>>();
                    for (Space space : spacesWithMemberNum.keySet()) {
                        Integer commonSpaces = (Integer)spacesWithMemberNum.get(space);
                        spaces = (ArrayList<Space>)groupByCommonConnections.get(commonSpaces);
                        if (spaces == null) {
                            spaces = new ArrayList<Space>();
                            groupByCommonConnections.put(commonSpaces, spaces);
                        }
                        spaces.add(space);
                    }
                    int suggestionLeft = maxSuggestions;
                    for (Integer key : groupByCommonConnections.descendingKeySet()) {
                        spaces = (List)groupByCommonConnections.get(key);
                        for (Space space : spaces) {
                            JSONObject json = ajc$this.buildJSONObject(space, key);
                            jsonArray.put((Object)json);
                            if (--suggestionLeft != 0) continue;
                            break block17;
                        }
                    }
                } else {
                    List lastSpaces = spaceService.getLastSpaces(10);
                    for (Space space : lastSpaces) {
                        if ("hidden".equals(space.getVisibility()) || "closed".equals(space.getRegistration()) || spaceService.isMember(space, identity.getRemoteId()) || spaceService.isPendingUser(space, identity.getRemoteId()) || spaceService.isInvitedUser(space, identity.getRemoteId()) || spaceService.isIgnored(space, identity.getRemoteId())) continue;
                        JSONObject json = ajc$this.buildJSONObject(space, 0);
                        json.put("username", (Object)userId);
                        jsonArray.put((Object)json);
                    }
                }
            }
            jsonGlobal.put(ITEMS, (Object)jsonArray);
            jsonGlobal.put("noConnections", spacesWithMemberNum.size());
            jsonGlobal.put("username", (Object)userId);
            return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space invitation rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceRestServices.java", SpaceRestServices.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuggestions", "org.exoplatform.social.rest.suggest.SpaceRestServices", "javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "sc:uriInfo", "", "javax.ws.rs.core.Response"), 68);
    }
}

