/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.storage.impl;

import io.meeds.task.search.TaskSearchConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.model.TaskSearchFilter;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.util.StorageUtil;

public class TaskStorageImpl
implements TaskStorage {
    private static final Log LOG = ExoLogger.getExoLogger(TaskStorageImpl.class);
    private static final Pattern pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    @Inject
    private final DAOHandler daoHandler;
    @Inject
    private final UserService userService;
    @Inject
    private final ProjectStorage projectStorage;
    @Inject
    private final TaskSearchConnector taskSearchConnector;

    public TaskStorageImpl(DAOHandler daoHandler, UserService userService, ProjectStorage projectStorage, TaskSearchConnector taskSearchConnector) {
        this.daoHandler = daoHandler;
        this.userService = userService;
        this.projectStorage = projectStorage;
        this.taskSearchConnector = taskSearchConnector;
    }

    @Override
    public TaskDto getTaskById(long id) {
        return StorageUtil.taskToDto((Task)this.daoHandler.getTaskHandler().find(Long.valueOf(id)), this.projectStorage);
    }

    @Override
    public TaskDto createTask(TaskDto task) {
        return StorageUtil.taskToDto((Task)this.daoHandler.getTaskHandler().create(StorageUtil.taskToEntity(task)), this.projectStorage);
    }

    @Override
    public TaskDto update(TaskDto task) {
        return StorageUtil.taskToDto((Task)this.daoHandler.getTaskHandler().update(StorageUtil.taskToEntity(task)), this.projectStorage);
    }

    @Override
    public void delete(TaskDto task) {
        this.daoHandler.getTaskHandler().delete(StorageUtil.taskToEntity(task));
    }

    @Override
    public List<TaskDto> findTasksByLabel(LabelDto label, List<Long> projectIds, String username, OrderBy orderBy, int offset, int limit) throws Exception {
        List<Task> taskEntities = Arrays.asList((Task[])this.daoHandler.getTaskHandler().findTasksByLabel(label.getId(), projectIds, username, orderBy).load(offset, limit));
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public int countTasksByLabel(LabelDto label, List<Long> projectIds, String username, OrderBy orderBy) throws Exception {
        return this.daoHandler.getTaskHandler().findTasksByLabel(label.getId(), projectIds, username, orderBy).getSize();
    }

    @Override
    public List<TaskDto> findByUser(String user) {
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add(user);
        List<Task> taskEntities = this.daoHandler.getTaskHandler().findAllByMembership(user, memberships);
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public List<TaskDto> findTasks(TaskQuery query, int offset, int limit) throws Exception {
        List<Task> taskEntities = Arrays.asList((Task[])this.daoHandler.getTaskHandler().findTasks(query).load(offset, limit));
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public int countTasks(TaskQuery query) throws Exception {
        return this.daoHandler.getTaskHandler().findTasks(query).getSize();
    }

    @Override
    public <T> List<T> selectTaskField(TaskQuery query, String fieldName) {
        return this.daoHandler.getTaskHandler().selectTaskField(query, fieldName);
    }

    @Override
    public TaskDto findTaskByActivityId(String activityId) {
        return StorageUtil.taskToDto(this.daoHandler.getTaskHandler().findTaskByActivityId(activityId), this.projectStorage);
    }

    @Override
    public void updateStatus(Status stOld, Status stNew) {
        this.daoHandler.getTaskHandler().updateStatus(stOld, stNew);
    }

    @Override
    public void updateTaskOrder(long currentTaskId, Status newStatus, long[] orders) {
        this.daoHandler.getTaskHandler().updateTaskOrder(currentTaskId, newStatus, orders);
    }

    @Override
    public Set<String> getCoworker(long taskid) {
        return this.daoHandler.getTaskHandler().getCoworker(taskid);
    }

    @Override
    public TaskDto getTaskWithCoworkers(long id) {
        return StorageUtil.taskToDto(this.daoHandler.getTaskHandler().getTaskWithCoworkers(id), this.projectStorage);
    }

    @Override
    public List<TaskDto> getUncompletedTasks(String user, int limit) {
        List<Task> taskEntities = this.daoHandler.getTaskHandler().getUncompletedTasks(user, limit);
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public Long countUncompletedTasks(String user) {
        return this.daoHandler.getTaskHandler().countUncompletedTasks(user);
    }

    @Override
    public List<TaskDto> getAssignedTasks(String user, int limit) {
        List<Task> taskEntities = this.daoHandler.getTaskHandler().getAssignedTasks(user, limit);
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public Long countAssignedTasks(String user) {
        return this.daoHandler.getTaskHandler().countAssignedTasks(user);
    }

    @Override
    public List<TaskDto> getWatchedTasks(String user, int limit) {
        List<Task> taskEntities = this.daoHandler.getTaskHandler().getWatchedTasks(user, limit);
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public Long countWatchedTasks(String user) {
        return this.daoHandler.getTaskHandler().countWatchedTasks(user);
    }

    @Override
    public List<TaskDto> getCollaboratedTasks(String user, int limit) {
        List<Task> taskEntities = this.daoHandler.getTaskHandler().getCollaboratedTasks(user, limit);
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public Long countCollaboratedTasks(String user) {
        return this.daoHandler.getTaskHandler().countCollaboratedTasks(user);
    }

    @Override
    public List<TaskDto> getIncomingTasks(String user, int offset, int limit) throws Exception {
        List<Task> taskEntities = Arrays.asList((Task[])this.daoHandler.getTaskHandler().getIncomingTasks(user).load(offset, limit));
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public int countIncomingTasks(String user) throws Exception {
        return this.daoHandler.getTaskHandler().getIncomingTasks(user).getSize();
    }

    @Override
    public List<TaskDto> getOverdueTasks(String user, int limit) {
        List<Task> taskEntities = this.daoHandler.getTaskHandler().getOverdueTasks(user, limit);
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).collect(Collectors.toList());
    }

    @Override
    public Long countOverdueTasks(String user) {
        return this.daoHandler.getTaskHandler().countOverdueTasks(user);
    }

    @Override
    public void addWatcherToTask(String username, TaskDto task) {
        Set<String> watchers = this.getWatchersOfTask(task);
        if (watchers != null && !watchers.contains(username)) {
            watchers.add(username);
            task.setWatcher(watchers);
            this.daoHandler.getTaskHandler().update(StorageUtil.taskToEntity(task));
        }
    }

    @Override
    public void deleteWatcherOfTask(String username, TaskDto task) throws Exception {
        Set<String> watchers = this.getWatchersOfTask(task);
        if (watchers == null || !watchers.contains(username)) {
            throw new Exception("Cannot remove watcher " + username + "of task because watcher does not exist.");
        }
        watchers.remove(username);
        task.setWatcher(watchers);
        this.daoHandler.getTaskHandler().update(StorageUtil.taskToEntity(task));
    }

    @Override
    public Set<String> getWatchersOfTask(TaskDto task) {
        return this.daoHandler.getTaskHandler().getWatchersOfTask(StorageUtil.taskToEntity(task));
    }

    @Override
    public List<TaskDto> findTasks(String user, List<String> memberships, String query, int limit) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            TaskSearchFilter filter = new TaskSearchFilter();
            filter.setTerm(query);
            filter.setLimit(limit);
            filter.setPermissions(CollectionUtils.isNotEmpty(memberships) ? memberships : Arrays.asList(user));
            List<Long> taskIds = this.taskSearchConnector.search(filter);
            return taskIds.stream().map(this::getTaskById).filter(Objects::nonNull).toList();
        }
        List<Task> taskEntities = this.daoHandler.getTaskHandler().findTasks(user, memberships, limit);
        return taskEntities.stream().map(taskEntity -> StorageUtil.taskToDto(taskEntity, this.projectStorage)).toList();
    }

    @Override
    public long countTasks(String user, String query, List<String> memberships) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            TaskSearchFilter filter = new TaskSearchFilter();
            filter.setTerm(query);
            filter.setLimit(0);
            if (CollectionUtils.isEmpty(memberships)) {
                memberships = Arrays.asList(user);
            }
            filter.setPermissions(memberships);
            return this.taskSearchConnector.count(filter);
        }
        return this.daoHandler.getTaskHandler().countTasks(user);
    }

    @Override
    public ChangeLogEntry addTaskLog(ChangeLogEntry changeLogEntry) throws EntityNotFoundException {
        return StorageUtil.changeLogToDto((ChangeLog)this.daoHandler.getTaskLogHandler().create(StorageUtil.changeLogToEntity(changeLogEntry, this.userService)), this.userService);
    }

    @Override
    public List<ChangeLogEntry> getTaskLogs(long taskId, int offset, int limit) throws Exception {
        return Arrays.asList((ChangeLog[])this.daoHandler.getTaskLogHandler().findTaskLogs(taskId).load(offset, limit)).stream().map(changeLog -> StorageUtil.changeLogToDto(changeLog, this.userService)).collect(Collectors.toList());
    }

    @Override
    public List<Object[]> countTaskStatusByProject(long projectId) {
        return this.daoHandler.getTaskHandler().countTaskStatusByProject(projectId);
    }

    @Override
    public List<Long> getAllIds(int offset, int limit) {
        return this.daoHandler.getTaskHandler().getAllIds(offset, limit);
    }
}

