/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.template.GroovyElement;
import org.exoplatform.commons.notification.template.TemplateContentTransformerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.jsoup.Jsoup;

public class TemplateUtils {
    private static final Log LOG = ExoLogger.getLogger(TemplateUtils.class);
    private static final int MAX_SUBJECT_LENGTH = 50;

    public static String processGroovy(TemplateContext ctx) {
        return ((TemplateContentTransformerService)ExoContainerContext.getService(TemplateContentTransformerService.class)).processGroovy(ctx);
    }

    public static String processSubject(TemplateContext ctx) {
        return ((TemplateContentTransformerService)ExoContainerContext.getService(TemplateContentTransformerService.class)).processSubject(ctx);
    }

    public static String processDigest(TemplateContext ctx) {
        return ((TemplateContentTransformerService)ExoContainerContext.getService(TemplateContentTransformerService.class)).processDigest(ctx);
    }

    public static String loadGroovyTemplate(String templatePath) {
        String string;
        block10: {
            InputStream inputStream = TemplateUtils.getTemplateInputStream(templatePath);
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (StringUtils.startsWith((CharSequence)templatePath, (CharSequence)"war:/notification/templates")) {
                        LOG.info("Failed to read default template file: {}. An empty message will be used", new Object[]{templatePath});
                    } else {
                        LOG.warn("Failed to read template file: {}. An empty message will be used", new Object[]{templatePath, e});
                    }
                    return "";
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static Element loadGroovyElement(String pluginId, String language) {
        PluginConfig templateConfig = TemplateUtils.getPluginConfig(pluginId);
        return new GroovyElement().language(language).config(templateConfig);
    }

    public static String getExcerptSubject(String subject) {
        String newSubject = StringEscapeUtils.unescapeHtml4((String)TemplateUtils.cleanHtmlTags(subject));
        if (newSubject != null && newSubject.length() > 50) {
            int lastSpace = (newSubject = newSubject.substring(0, 50)).lastIndexOf(" ");
            return (lastSpace > 0 ? newSubject.substring(0, lastSpace) : newSubject) + "...";
        }
        return newSubject;
    }

    public static String cleanHtmlTags(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return Jsoup.parse((String)str).text();
    }

    public static PluginConfig getPluginConfig(String pluginId) {
        PluginConfig pluginConfig = NotificationContextImpl.cloneInstance().getPluginSettingService().getPluginConfig(pluginId);
        if (pluginConfig == null) {
            throw new IllegalStateException("PluginConfig is NULL with plugId = " + pluginId);
        }
        return pluginConfig;
    }

    public static String getResourceBundle(String key, Locale locale, String resourcePath) {
        ResourceBundleService bundleService;
        ResourceBundle res;
        if (key == null || key.trim().length() == 0 || resourcePath == null || resourcePath.isEmpty()) {
            return "";
        }
        if (locale == null || locale.getLanguage().isEmpty()) {
            locale = ResourceBundleService.DEFAULT_CROWDIN_LOCALE;
        }
        if ((res = (bundleService = CommonsUtils.getService(ResourceBundleService.class)).getResourceBundle(resourcePath, locale)) != null && res.containsKey(key)) {
            return res.getString(key);
        }
        LOG.warn((Object)("Resource Bundle key not found. " + key + " in source path: " + resourcePath));
        return key;
    }

    public static InputStream getTemplateInputStream(String templatePath) {
        ConfigurationManager configurationManager = CommonsUtils.getService(ConfigurationManager.class);
        Object uri = templatePath;
        if (!(templatePath.startsWith("war:") || templatePath.startsWith("jar:") || templatePath.startsWith("classpath:"))) {
            if (templatePath.startsWith("/")) {
                templatePath = templatePath.substring(1);
            }
            if (configurationManager.getURL((String)(uri = "war:/" + templatePath)) == null && configurationManager.getURL((String)(uri = "jar:/" + templatePath)) == null) {
                uri = "classpath:/" + templatePath;
            }
        }
        return configurationManager.getInputStream((String)uri);
    }
}

