/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.api.websocket;

import io.meeds.analytics.api.websocket.listener.AnalyticsWebSocketListener;
import io.meeds.analytics.model.UserSettings;
import jakarta.annotation.PostConstruct;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsWebSocketService {
    public static final String COMETD_CHANNEL = "/service/analytics";
    private static final Log LOG = ExoLogger.getLogger(AnalyticsWebSocketService.class);
    private ListenerService listenerService;
    private ContinuationService continuationService;
    private EXoContinuationBayeux continuationBayeux;
    private ServerChannel channel;
    private String cometdContextName;

    @PostConstruct
    public void init() {
        if (this.channel == null) {
            this.channel = (ServerChannel)this.getContinuationBayeux().createChannelIfAbsent(COMETD_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
            this.channel.addListener((ConfigurableServerChannel.ServerChannelListener)new AnalyticsWebSocketListener(this, this.getListenerService()));
        }
    }

    public UserSettings getUserSettings(String username) {
        UserSettings userSettings = new UserSettings();
        userSettings.setCometdToken(this.getUserToken(username));
        userSettings.setCometdContext(this.getCometdContextName());
        return userSettings;
    }

    public String getUserToken(String username) {
        try {
            return this.getContinuationService().getUserToken(username);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not retrieve continuation token for user " + username), (Throwable)e);
            return "";
        }
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private String getCometdContextName() {
        if (this.cometdContextName == null) {
            this.cometdContextName = this.getContinuationBayeux() == null ? "cometd" : this.getContinuationBayeux().getCometdContextName();
        }
        return this.cometdContextName;
    }

    private EXoContinuationBayeux getContinuationBayeux() {
        if (this.continuationBayeux == null) {
            this.continuationBayeux = (EXoContinuationBayeux)CommonsUtils.getService(EXoContinuationBayeux.class);
        }
        return this.continuationBayeux;
    }

    private ContinuationService getContinuationService() {
        if (this.continuationService == null) {
            this.continuationService = (ContinuationService)CommonsUtils.getService(ContinuationService.class);
        }
        return this.continuationService;
    }
}

