/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.plugin;

import io.meeds.crowdin.gamification.model.Event;
import io.meeds.crowdin.gamification.plugin.CrowdinTriggerPlugin;
import io.meeds.crowdin.gamification.services.CrowdinTriggerService;
import io.meeds.crowdin.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StringCommentCreatedTriggerPlugin
extends CrowdinTriggerPlugin {
    @Autowired
    private CrowdinTriggerService crowdinTriggerService;

    @PostConstruct
    public void init() {
        this.crowdinTriggerService.addPlugin(this);
    }

    @Override
    public List<Event> getEvents(String trigger, Map<String, Object> payload) {
        return Collections.singletonList(new Event("stringCommentCreated", Utils.extractSubItem(payload, "comment", "user", "username"), Utils.extractSubItem(payload, "comment", "user", "username"), Utils.constructObjectIdAsJsonString(payload, "comment"), "comment", this.getProjectId(payload), Utils.extractSubItem(payload, "comment", "targetLanguage", "id"), true, Utils.extractSubItem(payload, "comment", "string", "file", "directoryId"), trigger.equals("stringComment.deleted"), Utils.countWords(Utils.extractSubItem(payload, "translation", "string", "text"))));
    }

    @Override
    public String getEventName() {
        return "stringComment.created";
    }

    @Override
    public String getCancellingEventName() {
        return "stringComment.deleted";
    }

    @Override
    public String getProjectId(Map<String, Object> payload) {
        return Utils.extractSubItem(payload, "comment", "string", "project", "id");
    }
}

