/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import java.io.IOException;
import org.gatein.pc.portlet.impl.jsr168.Dispatch;
import org.gatein.pc.portlet.impl.jsr168.DispatchType;
import org.gatein.pc.portlet.impl.jsr168.DispatchedHttpServletRequest;
import org.gatein.pc.portlet.impl.jsr168.DispatchedHttpServletResponse;

public class DispatchedRequestDispatcher
implements RequestDispatcher {
    private final RequestDispatcher realDispatcher;
    private final String path;

    public DispatchedRequestDispatcher(RequestDispatcher realDispatcher, String path) {
        this.realDispatcher = realDispatcher;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        DispatchedHttpServletRequest dreq = DispatchedRequestDispatcher.unwrap(req);
        DispatchedRequestDispatcher.unwrap(resp);
        dreq.pushDispatch(new Dispatch(DispatchType.INCLUDE, this.path));
        try {
            this.realDispatcher.include(req, resp);
        }
        finally {
            dreq.popDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        DispatchedHttpServletRequest dreq = DispatchedRequestDispatcher.unwrap(req);
        DispatchedRequestDispatcher.unwrap(resp);
        dreq.pushDispatch(new Dispatch(DispatchType.FORWARD, this.path));
        try {
            this.realDispatcher.include(req, resp);
        }
        finally {
            dreq.popDispatch();
        }
    }

    private static DispatchedHttpServletRequest unwrap(ServletRequest wrapped) {
        while (true) {
            if (wrapped instanceof DispatchedHttpServletRequest) {
                return (DispatchedHttpServletRequest)wrapped;
            }
            if (!(wrapped instanceof ServletRequestWrapper)) break;
            ServletRequestWrapper wrapper = (ServletRequestWrapper)wrapped;
            wrapped = wrapper.getRequest();
        }
        throw new IllegalArgumentException();
    }

    private static DispatchedHttpServletResponse unwrap(ServletResponse wrapped) {
        while (true) {
            if (wrapped instanceof DispatchedHttpServletResponse) {
                return (DispatchedHttpServletResponse)wrapped;
            }
            if (!(wrapped instanceof ServletResponseWrapper)) break;
            ServletResponseWrapper wrapper = (ServletResponseWrapper)wrapped;
            wrapped = wrapper.getResponse();
        }
        throw new IllegalArgumentException();
    }
}

