/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import org.springframework.boot.autoconfigure.ssl.CertificateMatcher;
import org.springframework.boot.autoconfigure.ssl.JksSslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.PemSslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.SslBundleProperties;
import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreDetails;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public final class PropertiesSslBundle
implements SslBundle {
    private final SslStoreBundle stores;
    private final SslBundleKey key;
    private final SslOptions options;
    private final String protocol;
    private final SslManagerBundle managers;

    private PropertiesSslBundle(SslStoreBundle stores, SslBundleProperties properties) {
        this.stores = stores;
        this.key = PropertiesSslBundle.asSslKeyReference(properties.getKey());
        this.options = PropertiesSslBundle.asSslOptions(properties.getOptions());
        this.protocol = properties.getProtocol();
        this.managers = SslManagerBundle.from((SslStoreBundle)this.stores, (SslBundleKey)this.key);
    }

    private static SslBundleKey asSslKeyReference(SslBundleProperties.Key key) {
        return key != null ? SslBundleKey.of((String)key.getPassword(), (String)key.getAlias()) : SslBundleKey.NONE;
    }

    private static SslOptions asSslOptions(SslBundleProperties.Options options) {
        return options != null ? SslOptions.of(options.getCiphers(), options.getEnabledProtocols()) : SslOptions.NONE;
    }

    public SslStoreBundle getStores() {
        return this.stores;
    }

    public SslBundleKey getKey() {
        return this.key;
    }

    public SslOptions getOptions() {
        return this.options;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SslManagerBundle getManagers() {
        return this.managers;
    }

    public static SslBundle get(PemSslBundleProperties properties) {
        return PropertiesSslBundle.get(properties, ApplicationResourceLoader.get());
    }

    public static SslBundle get(PemSslBundleProperties properties, ResourceLoader resourceLoader) {
        PemSslStore keyStore = PropertiesSslBundle.getPemSslStore("keystore", properties.getKeystore(), resourceLoader);
        if (keyStore != null) {
            keyStore = keyStore.withAlias(properties.getKey().getAlias()).withPassword(properties.getKey().getPassword());
        }
        PemSslStore trustStore = PropertiesSslBundle.getPemSslStore("truststore", properties.getTruststore(), resourceLoader);
        PemSslStoreBundle storeBundle = new PemSslStoreBundle(keyStore, trustStore);
        return new PropertiesSslBundle((SslStoreBundle)storeBundle, properties);
    }

    private static PemSslStore getPemSslStore(String propertyName, PemSslBundleProperties.Store properties, ResourceLoader resourceLoader) {
        PemSslStoreDetails details = PropertiesSslBundle.asPemSslStoreDetails(properties);
        PemSslStore pemSslStore = PemSslStore.load((PemSslStoreDetails)details, (ResourceLoader)resourceLoader);
        if (properties.isVerifyKeys()) {
            CertificateMatcher certificateMatcher = new CertificateMatcher(pemSslStore.privateKey());
            Assert.state((boolean)certificateMatcher.matchesAny(pemSslStore.certificates()), () -> "Private key in %s matches none of the certificates in the chain".formatted(propertyName));
        }
        return pemSslStore;
    }

    private static PemSslStoreDetails asPemSslStoreDetails(PemSslBundleProperties.Store properties) {
        return new PemSslStoreDetails(properties.getType(), properties.getCertificate(), properties.getPrivateKey(), properties.getPrivateKeyPassword());
    }

    public static SslBundle get(JksSslBundleProperties properties) {
        return PropertiesSslBundle.get(properties, ApplicationResourceLoader.get());
    }

    public static SslBundle get(JksSslBundleProperties properties, ResourceLoader resourceLoader) {
        SslStoreBundle storeBundle = PropertiesSslBundle.asSslStoreBundle(properties, resourceLoader);
        return new PropertiesSslBundle(storeBundle, properties);
    }

    private static SslStoreBundle asSslStoreBundle(JksSslBundleProperties properties, ResourceLoader resourceLoader) {
        JksSslStoreDetails keyStoreDetails = PropertiesSslBundle.asStoreDetails(properties.getKeystore());
        JksSslStoreDetails trustStoreDetails = PropertiesSslBundle.asStoreDetails(properties.getTruststore());
        return new JksSslStoreBundle(keyStoreDetails, trustStoreDetails, resourceLoader);
    }

    private static JksSslStoreDetails asStoreDetails(JksSslBundleProperties.Store properties) {
        return new JksSslStoreDetails(properties.getType(), properties.getProvider(), properties.getLocation(), properties.getPassword());
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator((Object)this);
        creator.append("key", (Object)this.key);
        creator.append("options", (Object)this.options);
        creator.append("protocol", (Object)this.protocol);
        creator.append("stores", (Object)this.stores);
        return creator.toString();
    }
}

