/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.util.BitSet;
import org.exoplatform.commons.utils.CharEncoder;
import org.exoplatform.commons.utils.CharsetCharEncoder;
import org.gatein.common.io.UndeclaredIOException;

public final class PercentEncoding {
    private static final CharEncoder encoder;
    private static final char[] ALPHABET;
    public static final PercentEncoding PATH_SEGMENT;
    public static final PercentEncoding QUERY_PARAM;
    private final BitSet allowed;

    private PercentEncoding(BitSet allowed) {
        this.allowed = allowed;
    }

    boolean accept(char c) {
        return c < this.allowed.length() && this.allowed.get(c);
    }

    public void encode(CharSequence s, Appendable appendable) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.encode(c, appendable);
        }
    }

    public String encode(CharSequence s) {
        try {
            StringBuilder sb = new StringBuilder(s.length());
            this.encode(s, (Appendable)sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public void encode(char c, Appendable appendable) throws IOException {
        if (this.accept(c)) {
            appendable.append(c);
        } else {
            byte[] bytes;
            for (byte b : bytes = encoder.encode(c)) {
                appendable.append('%');
                appendable.append(ALPHABET[(b & 0xF0) >> 4]);
                appendable.append(ALPHABET[b & 0xF]);
            }
        }
    }

    static {
        int c;
        encoder = CharsetCharEncoder.getUTF8();
        ALPHABET = "0123456789ABCDEF".toCharArray();
        BitSet allowed = new BitSet();
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        allowed.set(95);
        allowed.set(46);
        allowed.set(45);
        allowed.set(126);
        allowed.set(33);
        allowed.set(36);
        allowed.set(38);
        allowed.set(39);
        allowed.set(40);
        allowed.set(41);
        allowed.set(42);
        allowed.set(43);
        allowed.set(44);
        allowed.set(59);
        allowed.set(61);
        allowed.set(58);
        allowed.set(64);
        PATH_SEGMENT = new PercentEncoding(allowed);
        allowed = new BitSet(128);
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        allowed.set(95);
        allowed.set(46);
        allowed.set(45);
        allowed.set(126);
        allowed.set(33);
        allowed.set(36);
        allowed.set(39);
        allowed.set(40);
        allowed.set(41);
        allowed.set(42);
        allowed.set(43);
        allowed.set(44);
        allowed.set(59);
        allowed.set(58);
        allowed.set(64);
        allowed.set(63);
        allowed.set(47);
        QUERY_PARAM = new PercentEncoding(allowed);
    }
}

