/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import io.meeds.social.space.constant.SpaceMembershipStatus;
import jakarta.persistence.Tuple;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.XSpaceFilter;
import org.exoplatform.social.core.jpa.storage.EntityConverterUtils;
import org.exoplatform.social.core.jpa.storage.SpaceStorage$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.SpaceStorage$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.SpaceStorage$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceExternalInvitationDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.SpaceDAO;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceExternalInvitationEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.web.security.PortalToken;
import org.exoplatform.web.security.Token;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class SpaceStorage {
    private static final String DEFAULT_BANNER_URL = "/social/images/defaultSpaceBanner.webp";
    private static final Log LOG;
    private static final int BATCH_SIZE = 100;
    private static final String SPACE_METADATA_OBJECT_TYPE = "space";
    private SpaceDAO spaceDAO;
    private SpaceMemberDAO spaceMemberDAO;
    private IdentityDAO identityDAO;
    private IdentityStorage identityStorage;
    private ActivityDAO activityDAO;
    private SpaceExternalInvitationDAO spaceExternalInvitationDAO;
    private FavoriteService favoriteService;
    private RemindPasswordTokenService remindPasswordTokenService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public SpaceStorage(SpaceDAO spaceDAO, SpaceMemberDAO spaceMemberDAO, IdentityStorage identityStorage, IdentityDAO identityDAO, ActivityDAO activityDAO, SpaceExternalInvitationDAO spaceExternalInvitationDAO, FavoriteService favoriteService, RemindPasswordTokenService remindPasswordTokenService) {
        this.spaceDAO = spaceDAO;
        this.identityStorage = identityStorage;
        this.spaceMemberDAO = spaceMemberDAO;
        this.identityDAO = identityDAO;
        this.activityDAO = activityDAO;
        this.spaceExternalInvitationDAO = spaceExternalInvitationDAO;
        this.favoriteService = favoriteService;
        this.remindPasswordTokenService = remindPasswordTokenService;
    }

    @ExoTransactional
    public void deleteSpace(String id) throws SpaceStorageException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        SpaceStorage$AjcClosure1 spaceStorage$AjcClosure1 = new SpaceStorage$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(spaceStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<Space> getAccessibleSpaces(String userId) throws SpaceStorageException {
        return this.getAccessibleSpaces(userId, 0L, -1L);
    }

    public List<Space> getAccessibleSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getAccessibleSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, SpaceMembershipStatus.MEMBER, spaceFilter, offset, limit);
    }

    public int getAccessibleSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, SpaceMembershipStatus.MEMBER, spaceFilter);
    }

    public int getAccessibleSpacesCount(String userId) throws SpaceStorageException {
        return this.getAccessibleSpacesByFilterCount(userId, null);
    }

    public List<Space> getAllSpaces() throws SpaceStorageException {
        return this.getSpaces(0L, -1L);
    }

    public int getAllSpacesByFilterCount(SpaceFilter spaceFilter) {
        return this.getSpacesCount(null, null, spaceFilter);
    }

    public int getAllSpacesCount() throws SpaceStorageException {
        return this.getAllSpacesByFilterCount(null);
    }

    public List<Space> getInvitedSpaces(String userId) throws SpaceStorageException {
        return this.getInvitedSpaces(userId, 0L, -1L);
    }

    public List<Space> getInvitedSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getInvitedSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, SpaceMembershipStatus.INVITED, spaceFilter, offset, limit);
    }

    public int getInvitedSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, SpaceMembershipStatus.INVITED, spaceFilter);
    }

    public int getInvitedSpacesCount(String userId) throws SpaceStorageException {
        return this.getInvitedSpacesByFilterCount(userId, null);
    }

    public List<Space> getLastAccessedSpace(SpaceFilter spaceFilter, int offset, int limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter);
        xFilter.setLastAccess(true);
        return this.getSpaces(spaceFilter.getRemoteId(), SpaceMembershipStatus.MEMBER, xFilter, offset, limit);
    }

    public int getLastAccessedSpaceCount(SpaceFilter spaceFilter) throws SpaceStorageException {
        return this.getMemberSpacesByFilterCount(spaceFilter.getRemoteId(), spaceFilter);
    }

    public List<Space> getLastSpaces(int limit) {
        List<Long> ids = this.spaceDAO.getLastSpaces(limit);
        return this.buildList(ids);
    }

    public List<Space> getManagerSpaces(String userId, long offset, long limit) {
        return this.getManagerSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getManagerSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, SpaceMembershipStatus.MANAGER, spaceFilter, offset, limit);
    }

    public int getManagerSpacesCount(String userId) {
        return this.getManagerSpacesByFilterCount(userId, null);
    }

    public int getManagerSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, SpaceMembershipStatus.MANAGER, spaceFilter);
    }

    public List<String> getSpaceIdentityIdsByUserRole(String remoteId, String status, int offset, int limit) {
        SpaceMembershipStatus spaceMemberStatus = SpaceMembershipStatus.valueOf((String)status.toUpperCase());
        List<Long> spaceIdentityIds = this.spaceMemberDAO.getSpaceIdentityIdsByUserRole(remoteId, spaceMemberStatus, offset, limit);
        LinkedList<String> ids = new LinkedList<String>();
        if (spaceIdentityIds != null && !spaceIdentityIds.isEmpty()) {
            for (Long spaceId : spaceIdentityIds) {
                ids.add(String.valueOf(spaceId));
            }
        }
        return ids;
    }

    public List<String> getFavoriteSpaceIdentityIds(String userIdentityId, SpaceFilter spaceFilter, int offset, int limit) {
        List<Space> spaces = this.getFavoriteSpacesByFilter(userIdentityId, spaceFilter, offset, limit);
        LinkedList<String> ids = new LinkedList<String>();
        if (!CollectionUtils.isEmpty(spaces)) {
            for (Space space : spaces) {
                Identity spaceIdentity = this.identityStorage.findIdentity(SPACE_METADATA_OBJECT_TYPE, space.getPrettyName());
                if (spaceIdentity == null) continue;
                ids.add(String.valueOf(spaceIdentity.getId()));
            }
        }
        return ids;
    }

    public List<String> getMemberRoleSpaceIdentityIds(String identityId, int offset, int limit) throws SpaceStorageException {
        Identity identity = this.identityStorage.findIdentityById(identityId);
        List<Long> spaceIds = this.spaceMemberDAO.getSpacesIdsByUserName(identity.getRemoteId(), offset, limit);
        LinkedList<String> ids = new LinkedList<String>();
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (Long spaceId : spaceIds) {
                ids.add(String.valueOf(spaceId));
            }
        }
        return ids;
    }

    public List<String> getMemberRoleSpaceIds(String identityId, int offset, int limit) throws SpaceStorageException {
        Identity identity = this.identityStorage.findIdentityById(identityId);
        List<Long> spaceIds = this.spaceMemberDAO.getSpaceIdByMemberId(identity.getRemoteId(), offset, limit);
        LinkedList<String> ids = new LinkedList<String>();
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (Long spaceId : spaceIds) {
                ids.add(String.valueOf(spaceId));
            }
        }
        return ids;
    }

    public List<String> getManagerRoleSpaceIds(String identityId, int offset, int limit) throws SpaceStorageException {
        Identity identity = this.identityStorage.findIdentityById(identityId);
        List<Long> spaceIds = this.spaceMemberDAO.getSpaceIdsByUserRole(identity.getRemoteId(), SpaceMembershipStatus.MANAGER, offset, limit);
        LinkedList<String> ids = new LinkedList<String>();
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (Long spaceId : spaceIds) {
                ids.add(String.valueOf(spaceId));
            }
        }
        return ids;
    }

    public List<Space> getMemberSpaces(String userId) throws SpaceStorageException {
        return this.getMemberSpaces(userId, 0L, -1L);
    }

    public List<Space> getMemberSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getMemberSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, SpaceMembershipStatus.MEMBER, spaceFilter, offset, limit);
    }

    public List<Space> getFavoriteSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        SpaceFilter favoriteSpaceFilter = spaceFilter.clone();
        favoriteSpaceFilter.setFavorite(true);
        return this.getSpaces(userId, null, favoriteSpaceFilter, offset, limit);
    }

    public int getFavoriteSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        SpaceFilter favoriteSpaceFilter = spaceFilter.clone();
        favoriteSpaceFilter.setFavorite(true);
        return this.getSpacesCount(userId, null, favoriteSpaceFilter);
    }

    public int getMemberSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, SpaceMembershipStatus.MEMBER, spaceFilter);
    }

    public int getMemberSpacesCount(String userId) throws SpaceStorageException {
        return this.getMemberSpacesByFilterCount(userId, null);
    }

    public List<Space> getPendingSpaces(String userId) throws SpaceStorageException {
        return this.getPendingSpaces(userId, 0L, -1L);
    }

    public List<Space> getPendingSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getPendingSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, SpaceMembershipStatus.PENDING, spaceFilter, offset, limit);
    }

    public int getPendingSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, SpaceMembershipStatus.PENDING, spaceFilter);
    }

    public int getPendingSpacesCount(String userId) throws SpaceStorageException {
        return this.getPendingSpacesByFilterCount(userId, null);
    }

    public Space getSpaceByGroupId(String groupId) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByGroupId(groupId);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceById(long spaceId) throws SpaceStorageException {
        SpaceEntity entity = (SpaceEntity)this.spaceDAO.find(Long.valueOf(spaceId));
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceByPrettyName(String spacePrettyName) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByPrettyName(spacePrettyName);
        return this.fillSpaceFromEntity(entity);
    }

    public List<Space> getSpaces(long offset, long limit) throws SpaceStorageException {
        return this.getSpacesByFilter(null, offset, limit);
    }

    public List<Space> getSpacesByFilter(SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(null, null, spaceFilter, offset, limit);
    }

    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        return this.getVisibleSpaces(userId, spaceFilter, 0L, -1L);
    }

    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter, long offset, long limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter);
        xFilter.setRemoteId(userId);
        xFilter.setStatus(SpaceMembershipStatus.MEMBER);
        xFilter.setExtraStatus(SpaceMembershipStatus.INVITED);
        xFilter.setIncludePrivate(true);
        return this.getSpacesByFilter(xFilter, offset, limit);
    }

    public int getVisibleSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter);
        xFilter.setRemoteId(userId);
        xFilter.setStatus(SpaceMembershipStatus.MEMBER);
        xFilter.setIncludePrivate(true);
        return this.getSpacesCount(userId, null, xFilter);
    }

    public Instant getSpaceMembershipDate(long spaceId, String username) {
        return this.spaceMemberDAO.getSpaceMembershipDate(spaceId, username);
    }

    public void renameSpace(Space space) throws SpaceStorageException {
        SpaceEntity entity = (SpaceEntity)this.spaceDAO.find(Long.valueOf(Long.parseLong(space.getId())));
        Identity identitySpace = this.identityStorage.findIdentity(SPACE_METADATA_OBJECT_TYPE, entity.getPrettyName());
        EntityConverterUtils.buildFrom(space, entity);
        entity.setUpdatedDate(new Date());
        this.spaceDAO.update(entity);
        if (identitySpace != null) {
            identitySpace.setRemoteId(space.getPrettyName());
            this.identityStorage.saveIdentity(identitySpace);
            Profile profileSpace = identitySpace.getProfile();
            profileSpace.setProperty("Url", (Object)space.getUrl());
            this.identityStorage.saveProfile(profileSpace);
        }
    }

    public void ignoreSpace(String spaceId, String userId) {
        SpaceMemberEntity entity = this.spaceMemberDAO.getSpaceMemberShip(userId, Long.parseLong(spaceId), null);
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find(Long.valueOf(Long.parseLong(spaceId)));
        if (entity == null) {
            entity = new SpaceMemberEntity();
            entity.setSpace(spaceEntity);
            entity.setUserId(userId);
            entity.setStatus(SpaceMembershipStatus.IGNORED);
            entity.setCreatedDate(Instant.now());
            this.spaceMemberDAO.create(entity);
        } else {
            this.spaceMemberDAO.delete(entity);
        }
    }

    public boolean isSpaceIgnored(String spaceId, String userId) {
        SpaceMemberEntity entity = this.spaceMemberDAO.getSpaceMemberShip(userId, Long.parseLong(spaceId), SpaceMembershipStatus.IGNORED);
        return entity != null;
    }

    @ExoTransactional
    public Space saveSpace(Space space, boolean isNew) throws SpaceStorageException {
        Space space2 = space;
        boolean bl = isNew;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)space2, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, space2, Conversions.booleanObject((boolean)bl), joinPoint};
        SpaceStorage$AjcClosure3 spaceStorage$AjcClosure3 = new SpaceStorage$AjcClosure3(objectArray);
        return (Space)ExoTransactionalAspect.aspectOf().around(spaceStorage$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void updateSpaceAccessed(String remoteId, Space space) {
        String string = remoteId;
        Space space2 = space;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)space2);
        Object[] objectArray = new Object[]{this, string, space2, joinPoint};
        SpaceStorage$AjcClosure5 spaceStorage$AjcClosure5 = new SpaceStorage$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(spaceStorage$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public List<Space> getPendingSpaceRequestsToManage(String username, int offset, int limit) {
        List<Tuple> spaceRequestsToManage = this.spaceMemberDAO.getPendingSpaceRequestsToManage(username, offset, limit);
        if (spaceRequestsToManage == null || spaceRequestsToManage.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (Tuple tuple : spaceRequestsToManage) {
            Space space = new Space();
            space.setId(tuple.get(1).toString());
            space.setPendingUsers(new String[]{tuple.get(0).toString()});
            spaces.add(space);
        }
        return spaces;
    }

    public int countPendingSpaceRequestsToManage(String username) {
        return this.spaceMemberDAO.countPendingSpaceRequestsToManage(username);
    }

    public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String spaceId) {
        return this.spaceExternalInvitationDAO.findSpaceExternalInvitationsBySpaceId(spaceId).stream().map(this::fillSpaceExternalInvitationFromEntity).toList();
    }

    public void saveSpaceExternalInvitation(String spaceId, String email, String tokenId) {
        SpaceExternalInvitationEntity spaceExternalInvitation = new SpaceExternalInvitationEntity();
        spaceExternalInvitation.setSpaceId(spaceId);
        spaceExternalInvitation.setUserEmail(email);
        spaceExternalInvitation.setTokenId(tokenId);
        spaceExternalInvitation.setCreatedDate(Instant.now());
        this.spaceExternalInvitationDAO.create(spaceExternalInvitation);
    }

    public SpaceExternalInvitation findSpaceExternalInvitationById(String invitationId) {
        SpaceExternalInvitationEntity spaceExternalInvitationEntity = (SpaceExternalInvitationEntity)this.spaceExternalInvitationDAO.find(Long.valueOf(Long.parseLong(invitationId)));
        return this.fillSpaceExternalInvitationFromEntity(spaceExternalInvitationEntity);
    }

    public void deleteSpaceExternalInvitation(SpaceExternalInvitation spaceExternalInvitation) {
        SpaceExternalInvitationEntity spaceExternalInvitationEntity = (SpaceExternalInvitationEntity)this.spaceExternalInvitationDAO.find(spaceExternalInvitation.getInvitationId());
        this.spaceExternalInvitationDAO.delete(spaceExternalInvitationEntity);
    }

    public List<String> findExternalInvitationsSpacesByEmail(String email) {
        return this.spaceExternalInvitationDAO.findExternalInvitationsSpacesByEmail(email);
    }

    public void deleteExternalUserInvitations(String email) {
        this.spaceExternalInvitationDAO.deleteExternalUserInvitations(email);
    }

    public int countExternalMembers(Long spaceId) {
        return this.spaceMemberDAO.countExternalMembers(spaceId);
    }

    public List<Space> getCommonSpaces(String userId, String otherUserId, int offset, int limit) {
        List<SpaceEntity> commonSpaces = this.spaceDAO.getCommonSpaces(userId, otherUserId, offset, limit);
        return commonSpaces.stream().map(this::fillSpaceFromEntity).toList();
    }

    public int countCommonSpaces(String userId, String otherUserId) {
        return this.spaceDAO.countCommonSpaces(userId, otherUserId);
    }

    public Map<Long, Long> countSpacesByTemplate() {
        return this.spaceDAO.countSpacesByTemplate();
    }

    public List<Long> getSpaceCategoryIds() {
        return this.spaceDAO.getSpaceCategoryIds();
    }

    private String[] getSpaceMembers(long spaceId, SpaceMembershipStatus status) {
        int countSpaceMembers = this.spaceMemberDAO.countSpaceMembers(spaceId, status);
        if (countSpaceMembers == 0) {
            return new String[0];
        }
        ArrayList<String> membersList = new ArrayList<String>();
        for (int offset = 0; offset < countSpaceMembers; offset += 100) {
            List<String> spaceMembers = this.spaceMemberDAO.getSpaceMembers(spaceId, status, offset, 100);
            for (String username : spaceMembers) {
                if (StringUtils.isBlank((CharSequence)username)) continue;
                membersList.add(username);
            }
        }
        if (membersList.size() < countSpaceMembers) {
            LOG.warn("Space members count '{}' is different from retrieved space members from database {}", new Object[]{countSpaceMembers, membersList.size()});
        }
        return membersList.toArray(new String[0]);
    }

    private Space fillSpaceFromEntity(SpaceEntity entity) {
        if (entity == null) {
            return null;
        }
        Space space = new Space();
        this.fillSpaceSimpleFromEntity(entity, space);
        space.setPendingUsers(this.getSpaceMembers(entity.getId(), SpaceMembershipStatus.PENDING));
        space.setInvitedUsers(this.getSpaceMembers(entity.getId(), SpaceMembershipStatus.INVITED));
        String[] members = this.getSpaceMembers(entity.getId(), SpaceMembershipStatus.MEMBER);
        String[] redactors = this.getSpaceMembers(entity.getId(), SpaceMembershipStatus.REDACTOR);
        String[] publishers = this.getSpaceMembers(entity.getId(), SpaceMembershipStatus.PUBLISHER);
        String[] managers = this.getSpaceMembers(entity.getId(), SpaceMembershipStatus.MANAGER);
        HashSet<String> membersList = new HashSet<String>();
        if (members != null) {
            membersList.addAll(Arrays.asList(members));
        }
        if (managers != null) {
            membersList.addAll(Arrays.asList(managers));
        }
        space.setMembers(membersList.toArray(new String[0]));
        space.setRedactors(redactors);
        space.setPublishers(publishers);
        space.setManagers(managers);
        space.setLastUpdatedTime(entity.getUpdatedDate().getTime());
        return space;
    }

    private List<Space> getSpaces(String userId, SpaceMembershipStatus status, SpaceFilter spaceFilter, long offset, long limit) {
        if (StringUtils.isBlank((CharSequence)userId) && (spaceFilter == null || StringUtils.isBlank((CharSequence)spaceFilter.getRemoteId())) && status != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Can't search for spaces with membership while user is null", (Throwable)new IllegalStateException());
            } else {
                LOG.warn((Object)"Can't search for spaces with membership while user is null. Enable debug level for full stack trace.");
            }
        }
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        if (userId != null) {
            filter.setRemoteId(userId);
            if (status != null) {
                filter.setStatus(status);
            }
        }
        if (filter.isFavorite() && StringUtils.isNotBlank((CharSequence)filter.getRemoteId())) {
            this.addFavoriteSpaceIdsToFilter(filter);
            if (CollectionUtils.isEmpty(filter.getIds())) {
                return Collections.emptyList();
            }
        }
        List<Long> spaceIds = this.spaceDAO.getSpaceIdsByFilter(filter, offset, limit);
        return spaceIds.stream().map(this::getSpaceById).toList();
    }

    private int getSpacesCount(String userId, SpaceMembershipStatus status, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)userId) && status != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Can't search for spaces with membership while user is null", (Throwable)new IllegalStateException());
            } else {
                LOG.warn((Object)"Can't search for spaces with membership while user is null. Enable debug level for full stack trace.");
            }
        }
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        if (userId != null) {
            filter.setRemoteId(userId);
            if (status != null) {
                filter.setStatus(status);
            }
        }
        if (filter.isFavorite() && StringUtils.isNotBlank((CharSequence)filter.getRemoteId())) {
            this.addFavoriteSpaceIdsToFilter(filter);
            if (CollectionUtils.isEmpty(filter.getIds())) {
                return 0;
            }
        }
        return this.spaceDAO.getSpacesCountByFilter(filter);
    }

    private void addFavoriteSpaceIdsToFilter(XSpaceFilter filter) {
        Identity identity = this.identityStorage.findIdentity("organization", filter.getRemoteId());
        if (identity != null) {
            long userIdentityId = Long.parseLong(identity.getId());
            List metadataItems = this.favoriteService.getFavoriteItemsByCreatorAndType(SPACE_METADATA_OBJECT_TYPE, userIdentityId, 0L, -1L);
            Set<Long> favoriteSpaceIds = metadataItems.stream().map(metadataItem -> Long.parseLong(metadataItem.getObjectId())).collect(Collectors.toSet());
            filter.setIds(favoriteSpaceIds);
        }
    }

    private List<Space> buildList(List<Long> ids) {
        LinkedList<Space> spaces = new LinkedList<Space>();
        if (ids != null) {
            for (Long id : ids) {
                spaces.add(this.getSpaceById(id));
            }
        }
        return spaces;
    }

    private Space fillSpaceSimpleFromEntity(SpaceEntity entity, Space space) {
        space.setId(String.valueOf(entity.getId()));
        space.setDisplayName(entity.getDisplayName());
        space.setPrettyName(entity.getPrettyName());
        if (entity.getRegistration() != null) {
            space.setRegistration(entity.getRegistration().name().toLowerCase());
        }
        space.setDescription(entity.getDescription());
        space.setTemplateId(entity.getTemplateId() == null ? 0L : entity.getTemplateId());
        if (entity.getVisibility() != null) {
            space.setVisibility(entity.getVisibility().name().toLowerCase());
        }
        space.setGroupId(entity.getGroupId());
        space.setPublicSiteId(entity.getPublicSiteId());
        space.setPublicSiteVisibility(entity.getPublicSiteVisibility() == null ? null : entity.getPublicSiteVisibility().name().toLowerCase());
        space.setUrl(entity.getUrl());
        space.setCreatedTime(Long.valueOf(entity.getCreatedDate().getTime()));
        space.setLastUpdatedTime(entity.getUpdatedDate().getTime());
        space.setDeletePermissions(entity.getDeletePermissions());
        space.setLayoutPermissions(entity.getLayoutPermissions());
        space.setPublicSitePermissions(entity.getPublicSitePermissions());
        space.setCategoryIds(entity.getCategoryIds());
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = entity::getAvatarLastUpdated;
        supplierArray[1] = () -> new Date(System.currentTimeMillis());
        Date lastUpdated = (Date)ObjectUtils.getFirstNonNull((Supplier[])supplierArray);
        space.setAvatarLastUpdated(Long.valueOf(lastUpdated.getTime()));
        space.setAvatarUrl(LinkProvider.buildAvatarURL(SPACE_METADATA_OBJECT_TYPE, space.getId(), true, lastUpdated.getTime()));
        lastUpdated = entity.getBannerLastUpdated();
        if (lastUpdated == null) {
            space.setBannerUrl(DEFAULT_BANNER_URL);
        } else {
            Long bannerLastUpdated = lastUpdated.getTime();
            space.setBannerLastUpdated(bannerLastUpdated);
            space.setBannerUrl(LinkProvider.buildBannerURL(SPACE_METADATA_OBJECT_TYPE, space.getId(), true, bannerLastUpdated));
        }
        return space;
    }

    private SpaceExternalInvitation fillSpaceExternalInvitationFromEntity(SpaceExternalInvitationEntity spaceExternalInvitationEntity) {
        SpaceExternalInvitation spaceExternalInvitation = new SpaceExternalInvitation();
        spaceExternalInvitation.setInvitationId(spaceExternalInvitationEntity.getInvitationId());
        spaceExternalInvitation.setSpaceId(spaceExternalInvitationEntity.getSpaceId());
        spaceExternalInvitation.setUserEmail(spaceExternalInvitationEntity.getUserEmail());
        spaceExternalInvitation.setTokenId(spaceExternalInvitationEntity.getTokenId());
        PortalToken token = this.remindPasswordTokenService.getToken(spaceExternalInvitationEntity.getTokenId(), "external-registration");
        spaceExternalInvitation.setExpired(token == null || token.isExpired());
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = spaceExternalInvitationEntity::getCreatedDate;
        supplierArray[1] = () -> this.lambda$fillSpaceExternalInvitationFromEntity$2((Token)token);
        Instant createdDate = (Instant)ObjectUtils.getFirstNonNull((Supplier[])supplierArray);
        if (createdDate != null) {
            spaceExternalInvitation.setCreatedDate(createdDate.toEpochMilli());
        }
        return spaceExternalInvitation;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    private Instant computeCreatedDate(Token token) {
        return token == null ? null : Instant.ofEpochMilli(token.getExpirationTimeMillis()).minusSeconds(this.remindPasswordTokenService.getValidityTime());
    }

    private /* synthetic */ Instant lambda$fillSpaceExternalInvitationFromEntity$2(Token token) {
        return this.computeCreatedDate(token);
    }

    static {
        SpaceStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceStorage.class);
    }

    static final /* synthetic */ void deleteSpace_aroundBody0(SpaceStorage ajc$this, String id, JoinPoint joinPoint) {
        SpaceEntity entity = (SpaceEntity)ajc$this.spaceDAO.find(Long.valueOf(Long.parseLong(id)));
        if (entity != null) {
            Identity spaceIdentity = ajc$this.identityStorage.findIdentity(SPACE_METADATA_OBJECT_TYPE, entity.getPrettyName());
            if (spaceIdentity == null) {
                LOG.warn("Space with pretty name '{}' hasn't a related identity", new Object[]{entity.getPrettyName()});
            } else {
                ajc$this.identityDAO.hardDeleteIdentity(Long.parseLong(spaceIdentity.getId()));
                ajc$this.activityDAO.deleteActivitiesByOwnerId(spaceIdentity.getId());
            }
            ajc$this.spaceDAO.delete(entity);
            LOG.debug("Space {} removed", new Object[]{entity.getPrettyName()});
        }
    }

    static final /* synthetic */ Space saveSpace_aroundBody2(SpaceStorage ajc$this, Space space, boolean isNew, JoinPoint joinPoint) {
        SpaceEntity entity;
        if (isNew) {
            entity = new SpaceEntity();
            EntityConverterUtils.buildFrom(space, entity);
            entity.setUpdatedDate(new Date());
            entity = (SpaceEntity)ajc$this.spaceDAO.create(entity);
            space.setId(String.valueOf(entity.getId()));
        } else {
            Long id = Long.parseLong(space.getId());
            entity = (SpaceEntity)ajc$this.spaceDAO.find(id);
            if (entity != null) {
                EntityConverterUtils.buildFrom(space, entity);
                entity.setUpdatedDate(new Date());
                entity = (SpaceEntity)ajc$this.spaceDAO.update(entity);
            } else {
                throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_SAVE_SPACE);
            }
        }
        return ajc$this.getSpaceById(entity.getId());
    }

    static final /* synthetic */ void updateSpaceAccessed_aroundBody4(SpaceStorage ajc$this, String remoteId, Space space, JoinPoint joinPoint) {
        SpaceMemberEntity member = ajc$this.spaceMemberDAO.getSpaceMemberShip(remoteId, Long.parseLong(space.getId()), SpaceMembershipStatus.MEMBER);
        if (member != null) {
            member.setVisited(true);
            member.setLastAccess(new Date());
        }
        ajc$this.spaceMemberDAO.update(member);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceStorage.java", SpaceStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteSpace", "org.exoplatform.social.core.jpa.storage.SpaceStorage", "java.lang.String", "id", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 117);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveSpace", "org.exoplatform.social.core.jpa.storage.SpaceStorage", "org.exoplatform.social.core.space.model.Space:boolean", "space:isNew", "org.exoplatform.social.core.storage.SpaceStorageException", "org.exoplatform.social.core.space.model.Space"), 439);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSpaceAccessed", "org.exoplatform.social.core.jpa.storage.SpaceStorage", "java.lang.String:org.exoplatform.social.core.space.model.Space", "remoteId:space", "", "void"), 466);
    }
}

