/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.Explanation;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.lang.Nullable;

public class SearchDocumentAdapter
implements SearchDocument {
    private final float score;
    private final Object[] sortValues;
    private final Map<String, List<Object>> fields = new HashMap<String, List<Object>>();
    private final Document delegate;
    private final Map<String, List<String>> highlightFields = new HashMap<String, List<String>>();
    private final Map<String, SearchDocumentResponse> innerHits = new HashMap<String, SearchDocumentResponse>();
    @Nullable
    private final NestedMetaData nestedMetaData;
    @Nullable
    private final Explanation explanation;
    @Nullable
    private final List<String> matchedQueries;
    @Nullable
    private final String routing;

    public SearchDocumentAdapter(Document delegate, float score, Object[] sortValues, Map<String, List<Object>> fields, Map<String, List<String>> highlightFields, Map<String, SearchDocumentResponse> innerHits, @Nullable NestedMetaData nestedMetaData, @Nullable Explanation explanation, @Nullable List<String> matchedQueries, @Nullable String routing) {
        this.delegate = delegate;
        this.score = score;
        this.sortValues = sortValues;
        this.fields.putAll(fields);
        this.highlightFields.putAll(highlightFields);
        this.innerHits.putAll(innerHits);
        this.nestedMetaData = nestedMetaData;
        this.explanation = explanation;
        this.matchedQueries = matchedQueries;
        this.routing = routing;
    }

    @Override
    public SearchDocument append(String key, Object value) {
        this.delegate.append(key, value);
        return this;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public Map<String, List<Object>> getFields() {
        return this.fields;
    }

    @Override
    public Object[] getSortValues() {
        return this.sortValues;
    }

    @Override
    public Map<String, List<String>> getHighlightFields() {
        return this.highlightFields;
    }

    @Override
    public String getIndex() {
        return this.delegate.getIndex();
    }

    @Override
    public boolean hasId() {
        return this.delegate.hasId();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public void setId(String id) {
        this.delegate.setId(id);
    }

    @Override
    public boolean hasVersion() {
        return this.delegate.hasVersion();
    }

    @Override
    public long getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public void setVersion(long version) {
        this.delegate.setVersion(version);
    }

    @Override
    public boolean hasSeqNo() {
        return this.delegate.hasSeqNo();
    }

    @Override
    public long getSeqNo() {
        return this.delegate.getSeqNo();
    }

    @Override
    public void setSeqNo(long seqNo) {
        this.delegate.setSeqNo(seqNo);
    }

    @Override
    public boolean hasPrimaryTerm() {
        return this.delegate.hasPrimaryTerm();
    }

    @Override
    public long getPrimaryTerm() {
        return this.delegate.getPrimaryTerm();
    }

    @Override
    public void setPrimaryTerm(long primaryTerm) {
        this.delegate.setPrimaryTerm(primaryTerm);
    }

    @Override
    public Map<String, SearchDocumentResponse> getInnerHits() {
        return this.innerHits;
    }

    @Override
    @Nullable
    public NestedMetaData getNestedMetaData() {
        return this.nestedMetaData;
    }

    @Override
    @Nullable
    public <T> T get(Object key, Class<T> type) {
        return this.delegate.get(key, type);
    }

    @Override
    public String toJson() {
        return this.delegate.toJson();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (this.delegate.containsKey(key)) {
            return this.delegate.get(key);
        }
        return this.fields.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    @Nullable
    public Explanation getExplanation() {
        return this.explanation;
    }

    @Override
    @Nullable
    public List<String> getMatchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchDocumentAdapter)) {
            return false;
        }
        SearchDocumentAdapter that = (SearchDocumentAdapter)o;
        return Float.compare(that.score, this.score) == 0 && this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.delegate.forEach(action);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public String getRouting() {
        return this.routing;
    }

    public String toString() {
        String id = this.hasId() ? this.getId() : "?";
        String version = this.hasVersion() ? Long.toString(this.getVersion()) : "?";
        return this.getClass().getSimpleName() + "@" + id + "#" + version + " " + this.toJson();
    }
}

