/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.application.ResourceRequestFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PwaSwService {
    private static final Log LOG = ExoLogger.getLogger(PwaSwService.class);
    private static final boolean DEVELOPPING = PropertyManager.isDevelopping();
    private static final String OFFLINE_ENABLED_VARIABLE = "@pwa.offline.enabled@";
    private static final String DEVELOPMENT_VARIABLE = "@development@";
    private static final String SW_EXTENSIONS = "@service-worker-extensions@";
    private static final String ASSETS_VERSION_VARIABLE = "@assets-version@";
    private static AtomicReference<String> serviceWorkerContent = new AtomicReference();
    @Autowired
    private PortalContainer container;
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${pwa.service.worker.path:jar:/pwa/service-worker.js}")
    private String serviceWorkerPath;
    @Value(value="${pwa.service.worker.extension.path:../../js/service-worker-extension.js}")
    private String serviceWorkerExtensionPath;
    @Value(value="${pwa.offline.enabled:false}")
    private boolean offlineEnabled;

    public boolean isOfflineEnabled() {
        return this.offlineEnabled;
    }

    public void setOfflineEnabled(boolean offlineEnabled) {
        this.offlineEnabled = offlineEnabled;
    }

    public String getContent() {
        String content;
        if ((serviceWorkerContent.get() == null || DEVELOPPING) && (content = this.getJavascriptContent(this.serviceWorkerPath)) != null) {
            content = this.replaceExtensions(content);
            content = this.replaceVariables(content);
            serviceWorkerContent.set(DEVELOPPING ? content : this.minify(content));
        }
        return serviceWorkerContent.get();
    }

    private String replaceVariables(String content) {
        if (ResourceRequestFilter.version != null) {
            content = content.replace(ASSETS_VERSION_VARIABLE, ResourceRequestFilter.version);
        }
        content = content.replace(OFFLINE_ENABLED_VARIABLE, String.valueOf(this.offlineEnabled));
        content = content.replace(DEVELOPMENT_VARIABLE, String.valueOf(DEVELOPPING));
        return content;
    }

    private String replaceExtensions(String content) {
        if (StringUtils.isBlank((CharSequence)this.serviceWorkerExtensionPath)) {
            content = content.replace(SW_EXTENSIONS, "");
        } else if (this.container.getPortalClassLoader() != null) {
            Enumeration<URL> resources = this.container.getPortalClassLoader().getResources(this.serviceWorkerExtensionPath);
            if (resources != null) {
                StringBuilder extensionContents = new StringBuilder();
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    InputStream is = url.openStream();
                    try {
                        String extensionContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                        if (extensionContent == null) continue;
                        extensionContents.append(extensionContent).append("\n");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                content = content.replace(SW_EXTENSIONS, extensionContents.toString());
            } else {
                content = content.replace(SW_EXTENSIONS, "");
            }
        } else {
            content = content.replace(SW_EXTENSIONS, "");
        }
        return content;
    }

    private String minify(String javascript) {
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2021);
        options.setStrictModeInput(false);
        options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        WarningLevel.QUIET.setOptionsForWarningLevel(options);
        SourceFile extern = SourceFile.fromCode((String)"extern", (String)"");
        javascript = SourceFile.fromCode((String)"code", (String)javascript).getCode();
        SourceFile jsInput = SourceFile.fromCode((String)"jsInput", (String)javascript);
        compiler.compile(extern, jsInput, options);
        return compiler.toSource();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJavascriptContent(String path) {
        try (InputStream is = this.configurationManager.getInputStream(path);){
            if (is == null) return null;
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't find service worker path: {}", new Object[]{path, e});
        }
        return null;
    }
}

