/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.model.ProgramColorAlreadyExists;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.rest.builder.ProgramBuilder;
import io.meeds.gamification.rest.model.ProgramList;
import io.meeds.gamification.rest.model.ProgramRestEntity;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.translation.service.TranslationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="/gamification/programs")
public class ProgramRest
implements ResourceContainer {
    private static final String DEFAULT_COVER_PATH = System.getProperty("meeds.engagementCenter.program.defaultCoverPath", "/skin/images/program_default_cover.png");
    private static final String DEFAULT_AVATAR_PATH = System.getProperty("meeds.engagementCenter.program.defaultAvatarPath", "/skin/images/program_default_avatar.png");
    private static final String PROGRAM_NOT_FOUND_MESSAGE = "The program doesn't exit";
    private static final Log LOG = ExoLogger.getLogger(ProgramRest.class);
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private static final CacheControl CACHECONTROL = new CacheControl();
    protected PortalContainer portalContainer;
    protected ProgramService programService;
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected TranslationService translationService;
    protected SecuritySettingService securitySettingService;
    protected UserACL userAcl;
    public byte[] defaultProgramCover = null;
    public byte[] defaultProgramAvatar = null;

    public ProgramRest(PortalContainer portalContainer, ProgramService programService, RuleService ruleService, TranslationService translationService, IdentityManager identityManager, SecuritySettingService securitySettingService, UserACL userAcl) {
        this.portalContainer = portalContainer;
        this.programService = programService;
        this.ruleService = ruleService;
        this.translationService = translationService;
        this.identityManager = identityManager;
        this.securitySettingService = securitySettingService;
        this.userAcl = userAcl;
    }

    @GET
    @Produces(value={"application/json", "text/plain"})
    @Operation(summary="Retrieves the list of available programs", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPrograms(@Context HttpServletRequest request, @Parameter(description="Offset of results to retrieve") @QueryParam(value="offset") @DefaultValue(value="0") int offset, @Parameter(description="Limit of results to retrieve") @QueryParam(value="limit") @DefaultValue(value="0") int limit, @Parameter(description="Programs status filtering, possible values: ENABLED, DISABLED and ALL. Default value = ENABLED.", required=false) @QueryParam(value="status") @DefaultValue(value="ENABLED") EntityStatusType programStatus, @Parameter(description="Whether retrieve owned programs only or not") @QueryParam(value="owned") boolean owned, @Parameter(description="If true, this will return the filtered programs sorted by budget. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="sortByBudget") @DefaultValue(value="false") boolean sortByBudget, @Parameter(description="If true, this will return the filtered programs including deleted ones. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="includeDeleted") @DefaultValue(value="false") boolean includeDeleted, @Parameter(description="If true, this will return the total count of filtered programs. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="returnSize") @DefaultValue(value="false") boolean returnSize, @Parameter(description="Used to retrieve the title and description in requested language") @QueryParam(value="lang") String lang, @Parameter(description="Term to search.") @QueryParam(value="query") String query, @Parameter(description="Sort field. Possible values: createdDate, startDate, endDate or score.") @QueryParam(value="sortBy") @DefaultValue(value="title") String sortField, @Parameter(description="Whether to retrieve results sorted descending or not") @QueryParam(value="sortDescending") @DefaultValue(value="true") boolean sortDescending, @Parameter(description="Space audience identifier") @QueryParam(value="spaceId") @DefaultValue(value="0") long spaceId, @Parameter(description="Used to retrieve extra information about the program") @QueryParam(value="expand") String expand) {
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ProgramFilter programFilter = new ProgramFilter();
        programFilter.setSortByBudget(sortByBudget);
        programFilter.setIncludeDeleted(includeDeleted);
        programFilter.setStatus(programStatus);
        programFilter.setSortBy(sortField);
        programFilter.setSortDescending(sortDescending);
        if (spaceId > 0L) {
            programFilter.setSpacesIds(Collections.singletonList(spaceId));
            programFilter.setExcludeOpen(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            programFilter.setProgramTitle(query);
        }
        if (owned) {
            long currentUserIdentityId = Utils.getCurrentUserIdentityId();
            if (currentUserIdentityId == 0L) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            programFilter.setOwnerId(currentUserIdentityId);
        }
        List<String> expandFields = Utils.getExpandOptions(expand);
        String currentUser = Utils.getCurrentUser();
        try {
            ProgramList programList = new ProgramList();
            List<ProgramRestEntity> programs = this.getProgramsRestEntitiesByFilter(programFilter, this.getLocale(lang), offset, limit, expandFields, currentUser);
            boolean anonymous = StringUtils.isBlank((CharSequence)currentUser);
            if (expandFields.contains("administrators") && !anonymous) {
                programList.setAdministrators(ProgramBuilder.buildAdministrators(this.programService, this.userAcl));
            }
            if (returnSize) {
                int programsSize = this.programService.countPrograms(programFilter, currentUser);
                programList.setSize(programsSize);
            }
            programList.setPrograms(programs);
            programList.setOffset(offset);
            programList.setLimit(limit);
            return Response.ok((Object)programList).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @POST
    @Produces(value={"application/json", "text/plain"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a program", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createProgram(@Context HttpServletRequest request, @Parameter(description="Program object to create", required=true) ProgramDTO program) {
        if (program == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Program object is mandatory").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            program = this.programService.createProgram(program, identity);
            return Response.ok((Object)ProgramBuilder.toRestEntity(this.programService, this.ruleService, this.translationService, this.userAcl, program, this.getLocale(request), Utils.getCurrentUser(), null, true)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
        catch (ProgramColorAlreadyExists e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"program.form.programColor.programColorAlreadyUsed").type("text/plain").build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates an existing program", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateProgram(@Context HttpServletRequest request, @Parameter(description="Program id", required=true) @PathParam(value="id") long programId, @Parameter(description="Program object to update", required=true) ProgramDTO program) {
        if (program == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Program object is mandatory").build();
        }
        if (programId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Program technical identifier must be positive").build();
        }
        program.setId(programId);
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            program = this.programService.updateProgram(program, identity);
            return Response.ok((Object)ProgramBuilder.toRestEntity(this.programService, this.ruleService, this.translationService, this.userAcl, program, this.getLocale(request), Utils.getCurrentUser(), null, true)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)PROGRAM_NOT_FOUND_MESSAGE).build();
        }
        catch (ProgramColorAlreadyExists e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"program.form.programColor.programColorAlreadyUsed").type("text/plain").build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="{programId}")
    @Operation(summary="Deletes an existing program identified by its id", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteProgram(@Context HttpServletRequest request, @Parameter(description="Program id to be deleted", required=true) @PathParam(value="programId") long programId) {
        if (programId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The parameter 'id' must be positive integer").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            this.programService.deleteProgramById(programId, identity);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="{id}/color")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @Operation(summary="Returns true if the color can be used, else return false", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response checkProgramColorValidity(@Parameter(description="program id", required=true) @PathParam(value="id") long programId, @Parameter(description="Program color to check its validity", required=true) @FormParam(value="color") String color) {
        return Response.ok((Object)String.valueOf(this.programService.canUseProgramColor(programId, color))).build();
    }

    @GET
    @Path(value="{id}/cover")
    @Produces(value={"image/png"})
    @Operation(summary="Gets a program cover", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden request"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getProgramCover(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") Long lastModified, @Parameter(description="program id", required=true) @PathParam(value="id") String programId, @Parameter(description="A mandatory valid token that is used to authorize anonymous request", required=true) @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-cover", (CharSequence)programId);
        String lastUpdated = null;
        ProgramDTO program = null;
        if (isDefault) {
            lastUpdated = Utils.toRFC3339Date(new Date(Utils.DEFAULT_LAST_MODIFIED));
        } else {
            program = this.programService.getProgramById(Long.valueOf(programId));
            if (program == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)PROGRAM_NOT_FOUND_MESSAGE).build();
            }
            isDefault = program.getCoverFileId() == 0L;
            lastUpdated = program.getLastModifiedDate();
        }
        try {
            if (!isDefault && RestUtils.isAnonymous() && !Utils.isAttachmentTokenValid(token, programId, "cover", lastModified)) {
                LOG.warn("An anonymous user attempts to access avatar of space {} without a valid access token", new Object[]{programId});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            EntityTag eTag = new EntityTag(lastUpdated);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = isDefault ? this.getDefaultCoverInputStream() : this.programService.getProgramCoverStream(Long.valueOf(programId));
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
            if (lastModified != null) {
                builder.cacheControl(CACHECONTROL);
                builder.lastModified(Utils.parseRFC3339Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 604800000L));
            }
            return builder.build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)PROGRAM_NOT_FOUND_MESSAGE).build();
        }
    }

    @GET
    @Path(value="{id}/avatar")
    @Produces(value={"image/png"})
    @Operation(summary="Gets a program avatar", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden request"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getProgramAvatar(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") Long lastModified, @Parameter(description="program id", required=true) @PathParam(value="id") String programId, @Parameter(description="A mandatory valid token that is used to authorize anonymous request", required=true) @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-avatar", (CharSequence)programId);
        String lastUpdated = null;
        ProgramDTO program = null;
        if (isDefault) {
            lastUpdated = Utils.toRFC3339Date(new Date(Utils.DEFAULT_LAST_MODIFIED));
        } else {
            program = this.programService.getProgramById(Long.valueOf(programId));
            if (program == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)PROGRAM_NOT_FOUND_MESSAGE).build();
            }
            isDefault = program.getAvatarFileId() == 0L;
            lastUpdated = program.getLastModifiedDate();
        }
        try {
            if (!isDefault && RestUtils.isAnonymous() && !Utils.isAttachmentTokenValid(token, programId, "avatar", lastModified)) {
                LOG.warn("An anonymous user attempts to access avatar of space {} without a valid access token", new Object[]{programId});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            EntityTag eTag = new EntityTag(lastUpdated);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = isDefault ? this.getDefaultAvatarInputStream() : this.programService.getProgramAvatarStream(Long.valueOf(programId));
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
            if (lastModified != null) {
                builder.cacheControl(CACHECONTROL);
                builder.lastModified(Utils.parseRFC3339Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 604800000L));
            }
            return builder.build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)PROGRAM_NOT_FOUND_MESSAGE).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="{programId}/cover")
    @Operation(summary="Deletes program cover identified by program id", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Object not found")})
    public Response deleteProgramCover(@Context HttpServletRequest request, @Parameter(description="Program identifier", required=true) @PathParam(value="programId") long programId) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            this.programService.deleteProgramCoverById(programId, identity);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="{programId}/avatar")
    @Operation(summary="Deletes program avatar identified by program id", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Object not found")})
    public Response deleteProgramAvatar(@Context HttpServletRequest request, @Parameter(description="Program identifier", required=true) @PathParam(value="programId") long programId) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            this.programService.deleteProgramAvatarById(programId, identity);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{programId}")
    @Operation(summary="Retrieves a program by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getProgramById(@Context HttpServletRequest request, @Parameter(description="Program technical identifier", required=true) @PathParam(value="programId") long programId, @Parameter(description="Used to retrieve the title and description in requested language") @QueryParam(value="lang") String lang, @Parameter(description="Used to retrieve extra information about the program") @QueryParam(value="expand") String expand) {
        if (programId == 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Program Id must be not null").build();
        }
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            ProgramDTO program = this.programService.getProgramById(programId, currentUser);
            List<String> expandFields = Utils.getExpandOptions(expand);
            return Response.ok((Object)ProgramBuilder.toRestEntity(this.programService, this.ruleService, this.translationService, this.userAcl, program, this.getLocale(lang), currentUser, expandFields, true)).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    private Locale getLocale(String lang) {
        return StringUtils.isBlank((CharSequence)lang) ? null : Locale.forLanguageTag(lang);
    }

    private Locale getLocale(HttpServletRequest request) {
        return request == null ? null : request.getLocale();
    }

    private List<ProgramRestEntity> getProgramsRestEntitiesByFilter(ProgramFilter filter, Locale locale, int offset, int limit, List<String> expandFields, String currentUser) throws IllegalAccessException {
        List<ProgramDTO> programs = this.programService.getPrograms(filter, currentUser, offset, limit);
        return ProgramBuilder.toRestEntities(this.programService, this.ruleService, this.translationService, this.userAcl, locale, programs, expandFields, currentUser);
    }

    private InputStream getDefaultCoverInputStream() throws IOException {
        if (this.defaultProgramCover == null) {
            InputStream is = this.portalContainer.getPortalContext().getResourceAsStream(DEFAULT_COVER_PATH);
            this.defaultProgramCover = is == null ? new byte[0] : IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return new ByteArrayInputStream(this.defaultProgramCover);
    }

    private InputStream getDefaultAvatarInputStream() throws IOException {
        if (this.defaultProgramAvatar == null) {
            InputStream is = this.portalContainer.getPortalContext().getResourceAsStream(DEFAULT_AVATAR_PATH);
            this.defaultProgramAvatar = is == null ? new byte[0] : IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return new ByteArrayInputStream(this.defaultProgramAvatar);
    }

    static {
        CACHECONTROL.setMaxAge(604800);
        CACHECONTROL.setPrivate(false);
    }
}

