/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.model;

import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.commons.utils.IOUtil;

public abstract class Attachment {
    private static final int KB_SIZE = 1024;
    private static final int MB_SIZE = 0x100000;
    private String id;
    private String fileName;
    private String mimeType;
    private byte[] imageBytes;
    private long lastModified;

    protected Attachment() {
    }

    protected Attachment(String id, String fileName, String mimeType, InputStream inputStream, long lastModified) throws IOException {
        this.id = id;
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.lastModified = lastModified;
        this.setInputStream(inputStream);
    }

    public abstract String getAttachmentType();

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String s) {
        this.fileName = s;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String s) {
        this.mimeType = s;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getSize() {
        int length = this.imageBytes.length;
        if (length >= 0x100000) {
            double size = (double)length / 1048576.0;
            return size + " MB";
        }
        if (length >= 1024) {
            double size = (double)length / 1024.0;
            return size + " KB";
        }
        return length + " Bytes";
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setInputStream(InputStream input) throws IOException {
        this.imageBytes = (byte[])(input != null ? IOUtil.getStreamContentAsBytes((InputStream)input) : null);
    }
}

