/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.search;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.search.SearchException;

public class Sorting
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5457261377640398889L;
    public final SortBy sortBy;
    public final OrderBy orderBy;

    public Sorting(SortBy sortBy, OrderBy orderBy) {
        if (sortBy == null) {
            throw new SearchException("sortBy cannot be null");
        }
        if (orderBy == null) {
            throw new SearchException("orderBy cannot be null");
        }
        this.sortBy = sortBy;
        this.orderBy = orderBy;
    }

    public static final Sorting valueOf(String sortByField, String orderByField) {
        if (StringUtils.isNotBlank((CharSequence)sortByField)) {
            SortBy sortBy = SortBy.valueOf(sortByField.toUpperCase());
            OrderBy orderBy = StringUtils.isBlank((CharSequence)orderByField) ? OrderBy.ASC : OrderBy.valueOf(orderByField.toUpperCase());
            return new Sorting(sortBy, orderBy);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sorting)) {
            return false;
        }
        Sorting sorting = (Sorting)o;
        if (this.orderBy != sorting.orderBy) {
            return false;
        }
        return this.sortBy == sorting.sortBy;
    }

    public int hashCode() {
        int result = this.sortBy != null ? this.sortBy.hashCode() : 0;
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        return result;
    }

    public Sorting clone() throws CloneNotSupportedException {
        return (Sorting)super.clone();
    }

    public static enum SortBy {
        RELEVANCY("relevancy"),
        DATE("date"),
        TITLE("title"),
        LASTNAME("lastName"),
        FIRSTNAME("firstName"),
        FULLNAME("fullName"),
        LASTVISITED("lastVisited");

        private String fieldName;

        private SortBy(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    public static enum OrderBy {
        ASC,
        DESC;

    }
}

