/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class LikeCommentPlugin
extends BaseNotificationPlugin {
    public static final String ID = "LikeCommentPlugin";

    public LikeCommentPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Space space;
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        String[] likersId = activity.getLikeIdentityIds();
        String liker = Utils.getUserId(likersId[likersId.length - 1]);
        String likeTo = Utils.getUserId(activity.getPosterId());
        String spaceId = !activity.isComment() ? activity.getSpaceId() : Utils.getActivityManager().getParentActivity(activity).getSpaceId();
        SpaceService spaceService = Utils.getSpaceService();
        if (spaceId != null && !spaceService.isMember(space = spaceService.getSpaceById(spaceId), likeTo) && !spaceService.isSuperManager(space, likeTo)) {
            return null;
        }
        NotificationInfo notification = NotificationInfo.instance().to(likeTo).setFrom(liker).setSpaceId(spaceId == null ? 0L : Long.parseLong(spaceId)).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.LIKER.getKey(), liker).key(this.getId()).end();
        notification = SocialNotificationUtils.addUserToPreviousNotification(notification, SocialNotificationUtils.LIKERS.getKey(), activity.getId(), liker);
        return notification;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        String[] likersId = activity.getLikeIdentityIds();
        return !activity.getPosterId().equals(likersId[likersId.length - 1]);
    }
}

