/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.plugin.databind;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.model.SpaceTemplateDatabind;
import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.plugin.databind.SpaceTemplateDatabindPlugin$AjcClosure1;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SpaceTemplateDatabindPlugin
implements DatabindPlugin {
    public static final String OBJECT_TYPE = "SpaceTemplate";
    public static final String CONFIG_JSON = "config.json";
    private static final List<String> ADMINISTRATORS_GROUP;
    private static final Random RANDOM;
    private long superUserIdentityId;
    @Autowired
    protected DatabindService databindService;
    @Autowired
    protected FileService fileService;
    @Autowired
    protected TranslationService translationService;
    @Autowired
    protected SpaceTemplateService spaceTemplateService;
    @Autowired
    protected AttachmentService attachmentService;
    @Autowired
    protected UserACL userAcl;
    @Autowired
    protected IdentityManager identityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.databindService.addPlugin((DatabindPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canHandleDatabind(String objectType, String objectId) {
        return StringUtils.equals((CharSequence)OBJECT_TYPE, (CharSequence)objectType);
    }

    public void serialize(String objectId, ZipOutputStream zipOutputStream, String username) {
        FileItem file;
        TranslationField translationDescriptionField;
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(Long.parseLong(objectId), username, Locale.getDefault(), true);
        SpaceTemplateDatabind databind = new SpaceTemplateDatabind();
        TranslationField translationNameField = this.translationService.getTranslationField("spaceTemplate", Long.parseLong(objectId), "name", username);
        if (translationNameField != null) {
            Map<String, String> names = translationNameField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setNames(names);
        }
        if ((translationDescriptionField = this.translationService.getTranslationField("spaceTemplate", Long.parseLong(objectId), "description", username)) != null) {
            Map<String, String> descriptions = translationDescriptionField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setDescriptions(descriptions);
        }
        if ((file = this.fileService.getFile(spaceTemplate.getBannerFileId())) != null) {
            databind.setBannerFile(Base64.encodeBase64String((byte[])file.getAsByte()));
        }
        databind.setIcon(spaceTemplate.getIcon());
        databind.setSpaceFields(spaceTemplate.getSpaceFields());
        databind.setSpaceDefaultVisibility(spaceTemplate.getSpaceDefaultVisibility());
        databind.setSpaceDefaultRegistration(spaceTemplate.getSpaceDefaultRegistration());
        databind.setSpaceAllowContentCreation(spaceTemplate.isSpaceAllowContentCreation());
        String jsonData = JsonUtils.toJsonString((Object)databind);
        SiteKey siteKey = SiteKey.groupTemplate((String)spaceTemplate.getLayout());
        String folderPath = String.valueOf(siteKey.getType()) + "-" + siteKey.getName();
        this.writeToZip(zipOutputStream, folderPath + "/config.json", jsonData);
    }

    public CompletableFuture<Pair<DatabindReport, File>> deserialize(File zipFile, Map<String, String> params, String username) {
        return CompletableFuture.supplyAsync(() -> this.importSpaceTemplates(zipFile)).thenApply(processedTemplates -> {
            DatabindReport report = new DatabindReport();
            report.setSuccess(!processedTemplates.isEmpty());
            report.setProcessedItems(processedTemplates);
            return Pair.of((Object)report, (Object)zipFile);
        });
    }

    @ContainerTransactional
    public List<String> importSpaceTemplates(File zipFile) {
        File file = zipFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file);
        Object[] objectArray = new Object[]{this, file, joinPoint};
        SpaceTemplateDatabindPlugin$AjcClosure1 spaceTemplateDatabindPlugin$AjcClosure1 = new SpaceTemplateDatabindPlugin$AjcClosure1(objectArray);
        return (List)ContainerTransactionalAspect.aspectOf().around(spaceTemplateDatabindPlugin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Map<String, SpaceTemplateDatabind> extractTemplates(File zipFile) {
        HashMap<String, SpaceTemplateDatabind> templateDatabindMap = new HashMap<String, SpaceTemplateDatabind>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), StandardCharsets.UTF_8);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                SpaceTemplateDatabind databindFromJson;
                int bytesRead;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                String jsonContent = baos.toString(StandardCharsets.UTF_8);
                String entryName = entry.getName();
                if (!entryName.endsWith(CONFIG_JSON) || (databindFromJson = (SpaceTemplateDatabind)JsonUtils.fromJsonString((String)jsonContent, SpaceTemplateDatabind.class)) == null) continue;
                String key = entryName.substring(0, entryName.lastIndexOf(47));
                templateDatabindMap.put(key, databindFromJson);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading zip file", e);
        }
        return templateDatabindMap;
    }

    private void saveBanner(long spaceTemplateId, byte[] bannerBytes) {
        File tempFile = null;
        try {
            tempFile = this.getBannerFile(bannerBytes);
            String uploadId = "SpaceTemplateBanner" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            this.attachmentService.deleteAttachments("spaceTemplateBanner", String.valueOf(spaceTemplateId));
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "spaceTemplateBanner", String.valueOf(spaceTemplateId), null, this.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving banner file as attachment for space template '%s'", spaceTemplateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    private void saveNames(SpaceTemplateDatabind spaceTemplateDatabind, SpaceTemplate spaceTemplate) {
        this.translationService.saveTranslationLabels("spaceTemplate", spaceTemplate.getId(), "name", SpaceTemplateDatabindPlugin.convertToLocaleMap(spaceTemplateDatabind.getNames()));
    }

    private void saveDescriptions(SpaceTemplateDatabind spaceTemplateDatabind, SpaceTemplate spaceTemplate) {
        this.translationService.saveTranslationLabels("spaceTemplate", spaceTemplate.getId(), "description", SpaceTemplateDatabindPlugin.convertToLocaleMap(spaceTemplateDatabind.getDescriptions()));
    }

    private String processSpaceTemplate(SpaceTemplateDatabind spaceTemplateDatabind) {
        SpaceTemplate spaceTemplate = SpaceTemplateDatabindPlugin.getSpaceTemplate(spaceTemplateDatabind);
        SpaceTemplate createdSpaceTemplate = this.spaceTemplateService.createSpaceTemplate(spaceTemplate);
        this.saveNames(spaceTemplateDatabind, createdSpaceTemplate);
        this.saveDescriptions(spaceTemplateDatabind, createdSpaceTemplate);
        if (spaceTemplateDatabind.getBannerFile() != null) {
            this.saveBanner(createdSpaceTemplate.getId(), Base64.decodeBase64((String)spaceTemplateDatabind.getBannerFile()));
        }
        return String.valueOf(createdSpaceTemplate.getId());
    }

    private static SpaceTemplate getSpaceTemplate(SpaceTemplateDatabind spaceTemplateDatabind) {
        SpaceTemplate spaceTemplate = new SpaceTemplate();
        spaceTemplate.setIcon(spaceTemplateDatabind.getIcon());
        spaceTemplate.setSpaceDefaultVisibility(spaceTemplateDatabind.getSpaceDefaultVisibility());
        spaceTemplate.setSpaceFields(spaceTemplateDatabind.getSpaceFields());
        spaceTemplate.setSpaceDefaultRegistration(spaceTemplateDatabind.getSpaceDefaultRegistration());
        spaceTemplate.setSpaceAllowContentCreation(spaceTemplateDatabind.isSpaceAllowContentCreation());
        spaceTemplate.setAdminPermissions(ADMINISTRATORS_GROUP);
        spaceTemplate.setPermissions(ADMINISTRATORS_GROUP);
        spaceTemplate.setSpaceLayoutPermissions(ADMINISTRATORS_GROUP);
        spaceTemplate.setSpacePublicSitePermissions(ADMINISTRATORS_GROUP);
        spaceTemplate.setSpaceDeletePermissions(ADMINISTRATORS_GROUP);
        spaceTemplate.setEnabled(true);
        return spaceTemplate;
    }

    private File getBannerFile(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Banner data is null");
        }
        File tempFile = File.createTempFile("temp", ".png");
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
        return tempFile;
    }

    private void writeToZip(ZipOutputStream zipOutputStream, String filePath, String content) throws IOException {
        ZipEntry entry = new ZipEntry(filePath);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }

    private static Map<Locale, String> convertToLocaleMap(Map<String, String> inputMap) {
        return inputMap.entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue));
    }

    private void createUpdatedZipWithSpaceTemplateIds(File originalZip, Map<String, String> spaceTemplateIds) {
        File tempZipFile = File.createTempFile("updated_", ".zip");
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(originalZip), StandardCharsets.UTF_8);
             FileOutputStream fos = new FileOutputStream(tempZipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                zos.putNextEntry(new ZipEntry(entry.getName()));
                if (entry.getName().endsWith(CONFIG_JSON)) {
                    int bytesRead;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = zis.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                    String jsonContent = baos.toString(StandardCharsets.UTF_8);
                    String folderName = entry.getName().substring(0, entry.getName().lastIndexOf(47));
                    String spaceTemplateId = spaceTemplateIds.get(folderName);
                    if (spaceTemplateId != null) {
                        jsonContent = this.updateConfigJsonWithSpaceTemplateId(jsonContent, spaceTemplateId);
                    }
                    zos.write(jsonContent.getBytes(StandardCharsets.UTF_8));
                } else {
                    zos.write(zis.readAllBytes());
                }
                zos.closeEntry();
            }
        }
        Files.move(tempZipFile.toPath(), originalZip.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private String updateConfigJsonWithSpaceTemplateId(String jsonContent, String spaceTemplateId) {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode configJsonNode = objectMapper.readTree(jsonContent);
        ((ObjectNode)configJsonNode).put("spaceTemplateId", spaceTemplateId);
        return objectMapper.writeValueAsString((Object)configJsonNode);
    }

    static {
        SpaceTemplateDatabindPlugin.ajc$preClinit();
        ADMINISTRATORS_GROUP = Collections.singletonList("*:/platform/administrators");
        RANDOM = new Random();
    }

    static final /* synthetic */ List importSpaceTemplates_aroundBody0(SpaceTemplateDatabindPlugin ajc$this, File zipFile, JoinPoint joinPoint) {
        Map<String, SpaceTemplateDatabind> instances = ajc$this.extractTemplates(zipFile);
        HashMap<String, String> spaceTemplateIds = new HashMap<String, String>();
        ArrayList<String> processedSpaceTemplates = new ArrayList<String>();
        for (Map.Entry<String, SpaceTemplateDatabind> entry : instances.entrySet()) {
            String folderName = entry.getKey();
            SpaceTemplateDatabind spaceTemplate = entry.getValue();
            String createdId = ajc$this.processSpaceTemplate(spaceTemplate);
            processedSpaceTemplates.add(spaceTemplate.getLayout());
            spaceTemplateIds.put(folderName, createdId);
        }
        ajc$this.createUpdatedZipWithSpaceTemplateIds(zipFile, spaceTemplateIds);
        return processedSpaceTemplates;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceTemplateDatabindPlugin.java", SpaceTemplateDatabindPlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importSpaceTemplates", "io.meeds.social.space.template.plugin.databind.SpaceTemplateDatabindPlugin", "java.io.File", "zipFile", "", "java.util.List"), 182);
    }
}

