/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.reflect.KFunction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.data.util.NullableUtils;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class NullnessMethodInvocationValidator
implements MethodInterceptor {
    private final ParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
    private final Map<Method, MethodNullness> nullabilityCache = new ConcurrentHashMap<Method, MethodNullness>(16);

    public static boolean supports(Class<?> type) {
        return KotlinDetector.isKotlinPresent() && KotlinReflectionUtils.isSupportedKotlinClass(type) || NullableUtils.isNonNull(type, ElementType.METHOD) || NullableUtils.isNonNull(type, ElementType.PARAMETER);
    }

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        MethodNullness nullness = this.nullabilityCache.get(method);
        if (nullness == null) {
            nullness = MethodNullness.of(method, this.discoverer);
            this.nullabilityCache.put(method, nullness);
        }
        Object[] arguments = invocation.getArguments();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (nullness.isNullableParameter(i) || arguments.length >= i && arguments[i] != null) continue;
            throw this.argumentIsNull(method, nullness.getMethodParameterName(i));
        }
        Object result = invocation.proceed();
        if (result == null && !nullness.isNullableReturn()) {
            throw this.returnValueIsNull(method);
        }
        return result;
    }

    protected RuntimeException argumentIsNull(Method method, String parameterName) {
        return new IllegalArgumentException(String.format("Parameter %s in %s.%s must not be null", parameterName, ClassUtils.getShortName(method.getDeclaringClass()), method.getName()));
    }

    protected RuntimeException returnValueIsNull(Method method) {
        return new NullPointerException("Return value is null but must not be null");
    }

    static final class MethodNullness {
        private final boolean nullableReturn;
        private final boolean[] nullableParameters;
        private final MethodParameter[] methodParameters;

        private MethodNullness(boolean nullableReturn, boolean[] nullableParameters, MethodParameter[] methodParameters) {
            this.nullableReturn = nullableReturn;
            this.nullableParameters = nullableParameters;
            this.methodParameters = methodParameters;
        }

        static MethodNullness of(Method method, ParameterNameDiscoverer discoverer) {
            boolean nullableReturn = MethodNullness.isNullableParameter(new MethodParameter(method, -1));
            boolean[] nullableParameters = new boolean[method.getParameterCount()];
            MethodParameter[] methodParameters = new MethodParameter[method.getParameterCount()];
            for (int i = 0; i < method.getParameterCount(); ++i) {
                MethodParameter parameter = new MethodParameter(method, i);
                parameter.initParameterNameDiscovery(discoverer);
                nullableParameters[i] = MethodNullness.isNullableParameter(parameter);
                methodParameters[i] = parameter;
            }
            return new MethodNullness(nullableReturn, nullableParameters, methodParameters);
        }

        String getMethodParameterName(int index) {
            String parameterName = this.methodParameters[index].getParameterName();
            if (parameterName == null) {
                parameterName = String.format("of type %s at index %d", ClassUtils.getShortName((Class)this.methodParameters[index].getParameterType()), index);
            }
            return parameterName;
        }

        boolean isNullableReturn() {
            return this.nullableReturn;
        }

        boolean isNullableParameter(int index) {
            return this.nullableParameters[index];
        }

        private static boolean isNullableParameter(MethodParameter parameter) {
            return MethodNullness.requiresNoValue(parameter) || NullableUtils.isExplicitNullable(parameter) || KotlinReflectionUtils.isSupportedKotlinClass(parameter.getDeclaringClass()) && (ReflectionUtils.isNullable(parameter) || MethodNullness.allowNullableReturn(parameter.getMethod()));
        }

        private static boolean allowNullableReturn(@Nullable Method method) {
            if (method == null) {
                return false;
            }
            KFunction<?> function = KotlinDetector.isKotlinType(method.getDeclaringClass()) ? KotlinReflectionUtils.findKotlinFunction(method) : null;
            return function != null && function.getReturnType().isMarkedNullable();
        }

        private static boolean requiresNoValue(MethodParameter parameter) {
            return ReflectionUtils.isVoid(parameter.getParameterType());
        }

        public boolean[] getNullableParameters() {
            return this.nullableParameters;
        }

        public MethodParameter[] getMethodParameters() {
            return this.methodParameters;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodNullness)) {
                return false;
            }
            MethodNullness that = (MethodNullness)o;
            if (this.nullableReturn != that.nullableReturn) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.nullableParameters, (Object)that.nullableParameters)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.methodParameters, (Object)that.methodParameters);
        }

        public int hashCode() {
            int result = this.nullableReturn ? 1 : 0;
            result = 31 * result + Arrays.hashCode(this.nullableParameters);
            result = 31 * result + Arrays.hashCode(this.methodParameters);
            return result;
        }

        public String toString() {
            return "MethodInvocationValidator.Nullability(nullableReturn=" + this.isNullableReturn() + ", nullableParameters=" + Arrays.toString(this.getNullableParameters()) + ", methodParameters=" + Arrays.deepToString(this.getMethodParameters()) + ")";
        }
    }
}

