/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.lifecycle;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;

public class SpaceSiteTemplateLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<PortalRequestContext> {
    private static final String PREVIEW_SPACE_ID_PARAM = "previewSpaceId";
    private SpaceService spaceService;

    public void onInit(Application app) throws Exception {
        this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
    }

    public void onStartRequest(Application app, PortalRequestContext context) {
        if (!(app instanceof PortalApplication)) {
            return;
        }
        String spaceId = context.getRequest().getParameter(PREVIEW_SPACE_ID_PARAM);
        SiteKey siteKey = context.getSiteKey();
        if (siteKey == null || siteKey.getType() != SiteType.GROUP_TEMPLATE || StringUtils.isBlank((CharSequence)spaceId)) {
            return;
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space != null) {
            SpaceUtils.setSpaceByContext((PortalRequestContext)context, (Object)space);
        }
    }
}

