/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.blockchain.listener;

import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.service.BlockchainTransactionService;
import io.meeds.wallet.service.WalletTransactionService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TransactionWithNonceVerifierListener
extends Listener<Object, Map<String, Object>> {
    private static final Log LOG = ExoLogger.getLogger(TransactionWithNonceVerifierListener.class);
    private BlockchainTransactionService blockchainTransactionService;
    private WalletTransactionService transactionService;

    public TransactionWithNonceVerifierListener(BlockchainTransactionService blockchainTransactionService, WalletTransactionService transactionService) {
        this.blockchainTransactionService = blockchainTransactionService;
        this.transactionService = transactionService;
    }

    public void onEvent(Event<Object, Map<String, Object>> event) throws Exception {
        String hash = null;
        try {
            Map transactionDetailObject = (Map)event.getData();
            hash = (String)transactionDetailObject.get("hash");
            TransactionDetail transactionDetail = this.transactionService.getTransactionByHash(hash);
            if (transactionDetail == null || transactionDetail.isPending()) {
                return;
            }
            this.refreshEtherTransactions(transactionDetail.getFromWallet(), transactionDetail.getNonce());
        }
        catch (Exception e) {
            LOG.error("Error refreshing ether transaction with hash {}", new Object[]{hash, e});
        }
    }

    private void refreshEtherTransactions(Wallet fromWallet, long untilNonce) {
        if (fromWallet == null) {
            return;
        }
        List transactions = this.transactionService.getPendingWalletTransactionsSent(fromWallet.getAddress());
        if (CollectionUtils.isNotEmpty((Collection)transactions)) {
            transactions.forEach(transactionDetail -> {
                if (transactionDetail.getNonce() < untilNonce) {
                    try {
                        this.blockchainTransactionService.addTransactionToRefreshFromBlockchain(transactionDetail);
                    }
                    catch (Exception e) {
                        LOG.warn("Error refreshing Transaction {}", new Object[]{transactionDetail.getHash(), e});
                    }
                }
            });
        }
    }
}

