/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.webui.application.WebuiRequestContext;

public class UserProfileLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    public static final String USER_PROFILE_ATTRIBUTE_NAME = "PortalUserProfile";
    private OrganizationService organizationService;

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        String username = context.getRemoteUser();
        if (username == null) {
            context.setAttribute(USER_PROFILE_ATTRIBUTE_NAME, null);
        } else {
            UserProfile userProfile = this.getOrganizationService().getUserProfileHandler().findUserProfileByName(username);
            context.setAttribute(USER_PROFILE_ATTRIBUTE_NAME, userProfile);
        }
    }

    public OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        }
        return this.organizationService;
    }
}

